/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepository;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingTree;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.Collection;

public class CraftingCalculatorImpl
implements CraftingCalculator {
    private final PatternRepository patternRepository;
    private final RootStorage rootStorage;

    public CraftingCalculatorImpl(PatternRepository patternRepository, RootStorage rootStorage) {
        this.patternRepository = patternRepository;
        this.rootStorage = rootStorage;
    }

    @Override
    public <T> void calculate(ResourceKey resource, long amount, CraftingCalculatorListener<T> listener, CancellationToken cancellationToken) throws CancellationException {
        CoreValidations.validateLargerThanZero(amount, "Requested amount must be greater than 0");
        Collection<Pattern> patterns = this.patternRepository.getByOutput(resource);
        CraftingCalculatorListener<T> lastChildListener = null;
        for (Pattern pattern : patterns) {
            Amount patternAmount = Amount.of(pattern, resource, amount);
            if (patternAmount.getTotal() < 0L) {
                throw new NumberOverflowDuringCalculationException();
            }
            CraftingCalculatorListener<T> childListener = listener.childCalculationStarted(pattern, resource, patternAmount);
            CraftingTree<T> tree = CraftingTree.root(pattern, this.rootStorage, patternAmount, this.patternRepository, childListener);
            childListener.rootCalculationStarted(resource, patternAmount.getTotal());
            CraftingTree.CalculationResult calculationResult = tree.calculate(cancellationToken);
            if (calculationResult == CraftingTree.CalculationResult.MISSING_RESOURCES) {
                lastChildListener = childListener;
                continue;
            }
            listener.childCalculationCompleted(childListener);
            return;
        }
        if (lastChildListener == null) {
            throw new IllegalStateException("No pattern found for " + String.valueOf(resource));
        }
        listener.childCalculationCompleted(lastChildListener);
    }
}

