/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskContainer.class);
    private final PatternProvider patternProvider;
    private final List<Task> tasks = new CopyOnWriteArrayList<Task>();
    private final List<Task> tasksView = Collections.unmodifiableList(this.tasks);
    private final Set<ParentContainer> parents = new HashSet<ParentContainer>();

    public TaskContainer(PatternProvider patternProvider) {
        this.patternProvider = patternProvider;
    }

    public List<Task> getAll() {
        return this.tasksView;
    }

    public List<TaskStatus> getStatuses() {
        return this.tasks.stream().map(Task::getStatus).toList();
    }

    public void onRemovedFromContainer(ParentContainer parent) {
        this.tasks.forEach(parent::taskRemoved);
        this.parents.remove(parent);
    }

    public void onAddedIntoContainer(ParentContainer parent) {
        this.tasks.forEach(task -> parent.taskAdded(this.patternProvider, (Task)task));
        this.parents.add(parent);
    }

    public void add(Task task, @Nullable Network network) {
        this.tasks.add(task);
        if (network != null) {
            this.attach(task, network.getComponent(StorageNetworkComponent.class));
        }
    }

    public void cancel(TaskId id) {
        for (Task task : this.tasks) {
            if (!task.getId().equals(id)) continue;
            task.cancel();
            return;
        }
        throw new IllegalArgumentException("Task %s not found".formatted(id));
    }

    public void attachAll(Network network) {
        StorageNetworkComponent storage = network.getComponent(StorageNetworkComponent.class);
        this.tasks.forEach(task -> this.attach((Task)task, storage));
    }

    public void detachAll(Network network) {
        StorageNetworkComponent storage = network.getComponent(StorageNetworkComponent.class);
        this.tasks.forEach(task -> this.detach((Task)task, storage));
    }

    private void attach(Task task, StorageNetworkComponent storage) {
        storage.addListener(task);
    }

    private void detach(Task task, StorageNetworkComponent storage) {
        storage.removeListener(task);
    }

    public void step(Network network, StepBehavior stepBehavior, TaskListener listener) {
        StorageNetworkComponent storage = network.getComponent(StorageNetworkComponent.class);
        ExternalPatternSinkProvider sinkProvider = network.getComponent(AutocraftingNetworkComponent.class);
        this.tasks.removeIf(task -> this.step((Task)task, storage, sinkProvider, stepBehavior, listener));
    }

    private boolean step(Task task, StorageNetworkComponent storage, ExternalPatternSinkProvider sinkProvider, StepBehavior stepBehavior, TaskListener listener) {
        boolean completed;
        boolean changed;
        try {
            changed = task.step(storage, sinkProvider, stepBehavior, listener);
            completed = task.getState() == TaskState.COMPLETED;
        }
        catch (Exception e) {
            LOGGER.error("Exception while stepping task {} {}, removing task", new Object[]{task.getResource(), task.getAmount(), e});
            changed = false;
            completed = true;
        }
        if (completed) {
            this.detach(task, storage);
            this.parents.forEach(parent -> parent.taskCompleted(task));
        } else if (changed) {
            this.parents.forEach(parent -> parent.taskChanged(task));
        }
        return completed;
    }

    public long getAmount(ResourceKey resource) {
        return this.tasks.stream().filter(task -> task.getResource().equals(resource)).mapToLong(Task::getAmount).sum();
    }
}

