/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceExportState;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage.InterfaceExternalStorageProvider;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class InterfaceExternalStorageProviderImpl
implements InterfaceExternalStorageProvider {
    private final InterfaceNetworkNode networkNode;

    public InterfaceExternalStorageProviderImpl(InterfaceNetworkNode networkNode) {
        this.networkNode = networkNode;
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.isAnotherInterfaceActingAsExternalStorage(actor)) {
            return 0L;
        }
        InterfaceExportState exportState = this.networkNode.getExportState();
        if (exportState == null) {
            return 0L;
        }
        return exportState.extract(resource, amount, action);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.isAnotherInterfaceActingAsExternalStorage(actor)) {
            return 0L;
        }
        InterfaceExportState exportState = this.networkNode.getExportState();
        if (exportState == null) {
            return 0L;
        }
        return exportState.insert(resource, amount, action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAnotherInterfaceActingAsExternalStorage(Actor actor) {
        NetworkNode node;
        if (!(actor instanceof NetworkNodeActor)) return false;
        NetworkNodeActor networkNodeActor = (NetworkNodeActor)actor;
        try {
            NetworkNode networkNode;
            node = networkNode = networkNodeActor.networkNode();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(node instanceof InterfaceNetworkNode)) return false;
        InterfaceNetworkNode actingInterface = (InterfaceNetworkNode)node;
        if (!actingInterface.isActingAsExternalStorage()) return false;
        return true;
    }

    @Override
    public Iterator<ResourceAmount> iterator() {
        InterfaceExportState exportState = this.networkNode.getExportState();
        if (exportState == null) {
            return Collections.emptyIterator();
        }
        ArrayList<ResourceAmount> slots = new ArrayList<ResourceAmount>();
        for (int i = 0; i < exportState.getSlots(); ++i) {
            ResourceKey resource = exportState.getExportedResource(i);
            if (resource == null) continue;
            slots.add(new ResourceAmount(resource, exportState.getExportedAmount(i)));
        }
        return slots.iterator();
    }

    @Override
    public InterfaceNetworkNode getInterface() {
        return this.networkNode;
    }
}

