/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.security;

import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityDecision;
import com.refinedmods.refinedstorage.api.network.security.SecurityDecisionProvider;
import com.refinedmods.refinedstorage.api.network.security.SecurityNetworkComponent;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class SecurityNetworkComponentImpl
implements SecurityNetworkComponent {
    private final Set<SecurityDecisionProvider> providers = new LinkedHashSet<SecurityDecisionProvider>();
    private final SecurityPolicy defaultPolicy;

    public SecurityNetworkComponentImpl(SecurityPolicy defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    @Override
    public void onContainerAdded(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof SecurityDecisionProvider) {
            SecurityDecisionProvider provider = (SecurityDecisionProvider)((Object)networkNode);
            this.providers.add(provider);
        }
    }

    @Override
    public void onContainerRemoved(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof SecurityDecisionProvider) {
            SecurityDecisionProvider provider = (SecurityDecisionProvider)((Object)networkNode);
            this.providers.remove(provider);
        }
    }

    @Override
    public boolean isAllowed(Permission permission, SecurityActor actor) {
        Set<SecurityDecisionProvider> activeProviders = this.providers.stream().filter(SecurityDecisionProvider::isProviderActive).collect(Collectors.toSet());
        if (activeProviders.isEmpty()) {
            return this.defaultPolicy.isAllowed(permission);
        }
        Set decisions = activeProviders.stream().map(provider -> CoreValidations.validateNotNull(provider.isAllowed(permission, actor), "Decision cannot be null")).collect(Collectors.toSet());
        boolean anyDenied = decisions.stream().anyMatch(decision -> decision == SecurityDecision.DENY);
        if (anyDenied) {
            return false;
        }
        boolean anyAllowed = decisions.stream().anyMatch(decision -> decision == SecurityDecision.ALLOW);
        if (anyAllowed) {
            return true;
        }
        return this.tryFallback(permission, activeProviders);
    }

    @Override
    public boolean contains(SecurityNetworkComponent component) {
        for (SecurityDecisionProvider provider : this.providers) {
            if (!provider.contains(component)) continue;
            return true;
        }
        return false;
    }

    private boolean tryFallback(Permission permission, Set<SecurityDecisionProvider> activeProviders) {
        Set decisions = activeProviders.stream().map(provider -> CoreValidations.validateNotNull(provider.isAllowed(permission), "Decision cannot be null")).collect(Collectors.toSet());
        boolean anyDenied = decisions.stream().anyMatch(decision -> decision == SecurityDecision.DENY);
        if (anyDenied) {
            return false;
        }
        return decisions.stream().anyMatch(decision -> decision == SecurityDecision.ALLOW);
    }
}

