/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage.tracked;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorageRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.4")
public class InMemoryTrackedStorageRepository
implements TrackedStorageRepository {
    protected final Map<Class<? extends Actor>, Map<ResourceKey, TrackedResource>> trackedResourcesByActorType = new HashMap<Class<? extends Actor>, Map<ResourceKey, TrackedResource>>();

    @Override
    public void update(ResourceKey resource, Actor actor, long time) {
        Map resourceMap = this.trackedResourcesByActorType.computeIfAbsent(actor.getClass(), k -> new HashMap());
        TrackedResource existing = (TrackedResource)resourceMap.get(resource);
        if (existing == null) {
            resourceMap.put(resource, new TrackedResource(actor.getName(), time));
        } else {
            existing.update(actor.getName(), time);
        }
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        Map<ResourceKey, TrackedResource> resources = this.trackedResourcesByActorType.get(actorType);
        if (resources != null) {
            return Optional.ofNullable(resources.get(resource));
        }
        return Optional.empty();
    }
}

