/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.RefinedStorageClientApiImpl;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApiProxy;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterScreen;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerScreen;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorScreen;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridScreen;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewScreen;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorScreen;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorScreen;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.controller.ControllerScreen;
import com.refinedmods.refinedstorage.common.detector.DetectorScreen;
import com.refinedmods.refinedstorage.common.exporter.ExporterScreen;
import com.refinedmods.refinedstorage.common.grid.screen.CraftingGridScreen;
import com.refinedmods.refinedstorage.common.grid.screen.GridScreen;
import com.refinedmods.refinedstorage.common.grid.screen.hint.FluidGridInsertionHint;
import com.refinedmods.refinedstorage.common.iface.InterfaceScreen;
import com.refinedmods.refinedstorage.common.importer.ImporterScreen;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterScreen;
import com.refinedmods.refinedstorage.common.networking.RelayScreen;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterScreen;
import com.refinedmods.refinedstorage.common.security.FallbackSecurityCardScreen;
import com.refinedmods.refinedstorage.common.security.SecurityCardScreen;
import com.refinedmods.refinedstorage.common.security.SecurityManagerScreen;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.diskdrive.DiskDriveScreen;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceScreen;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageScreen;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridScreen;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorScreen;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.FluidResourceRendering;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResourceRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.CompositeClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.ResourceClientTooltipComponent;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeScreen;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinationClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import net.minecraft.class_746;

public abstract class AbstractClientModInitializer {
    public static void initializeClientPlatformApi() {
        ((RefinedStorageClientApiProxy)RefinedStorageClientApi.INSTANCE).setDelegate(new RefinedStorageClientApiImpl());
    }

    protected static void registerScreens(ScreenRegistration registration) {
        registration.register(Menus.INSTANCE.getDiskDrive(), DiskDriveScreen::new);
        registration.register(Menus.INSTANCE.getGrid(), GridScreen::new);
        registration.register(Menus.INSTANCE.getCraftingGrid(), CraftingGridScreen::new);
        registration.register(Menus.INSTANCE.getPatternGrid(), PatternGridScreen::new);
        registration.register(Menus.INSTANCE.getWirelessGrid(), GridScreen::new);
        registration.register(Menus.INSTANCE.getController(), ControllerScreen::new);
        registration.register(Menus.INSTANCE.getItemStorage(), new ScreenConstructor<class_1703, class_465<class_1703>>(){

            @Override
            public class_465<class_1703> create(class_1703 menu, class_1661 inventory, class_2561 title) {
                return RefinedStorageClientApi.INSTANCE.createStorageBlockScreen(menu, inventory, title, ItemResource.class);
            }
        });
        registration.register(Menus.INSTANCE.getFluidStorage(), new ScreenConstructor<class_1703, class_465<class_1703>>(){

            @Override
            public class_465<class_1703> create(class_1703 menu, class_1661 inventory, class_2561 title) {
                return RefinedStorageClientApi.INSTANCE.createStorageBlockScreen(menu, inventory, title, FluidResource.class);
            }
        });
        registration.register(Menus.INSTANCE.getImporter(), ImporterScreen::new);
        registration.register(Menus.INSTANCE.getExporter(), ExporterScreen::new);
        registration.register(Menus.INSTANCE.getInterface(), InterfaceScreen::new);
        registration.register(Menus.INSTANCE.getExternalStorage(), ExternalStorageScreen::new);
        registration.register(Menus.INSTANCE.getDetector(), DetectorScreen::new);
        registration.register(Menus.INSTANCE.getDestructor(), DestructorScreen::new);
        registration.register(Menus.INSTANCE.getConstructor(), ConstructorScreen::new);
        registration.register(Menus.INSTANCE.getRegulatorUpgrade(), RegulatorUpgradeScreen::new);
        registration.register(Menus.INSTANCE.getWirelessTransmitter(), WirelessTransmitterScreen::new);
        registration.register(Menus.INSTANCE.getStorageMonitor(), StorageMonitorScreen::new);
        registration.register(Menus.INSTANCE.getNetworkTransmitter(), NetworkTransmitterScreen::new);
        registration.register(Menus.INSTANCE.getPortableGridBlock(), PortableGridScreen::new);
        registration.register(Menus.INSTANCE.getPortableGridItem(), PortableGridScreen::new);
        registration.register(Menus.INSTANCE.getSecurityCard(), SecurityCardScreen::new);
        registration.register(Menus.INSTANCE.getFallbackSecurityCard(), FallbackSecurityCardScreen::new);
        registration.register(Menus.INSTANCE.getSecurityManager(), SecurityManagerScreen::new);
        registration.register(Menus.INSTANCE.getRelay(), RelayScreen::new);
        registration.register(Menus.INSTANCE.getDiskInterface(), DiskInterfaceScreen::new);
        registration.register(Menus.INSTANCE.getAutocrafter(), AutocrafterScreen::new);
        registration.register(Menus.INSTANCE.getAutocraftingStorageMonitor(), new ScreenConstructor<AutocraftingPreviewContainerMenu, AutocraftingPreviewScreen>(){

            @Override
            public AutocraftingPreviewScreen create(AutocraftingPreviewContainerMenu menu, class_1661 inventory, class_2561 title) {
                return new AutocraftingPreviewScreen(menu, inventory);
            }
        });
        registration.register(Menus.INSTANCE.getAutocrafterManager(), AutocrafterManagerScreen::new);
        registration.register(Menus.INSTANCE.getAutocraftingMonitor(), AutocraftingMonitorScreen::new);
        registration.register(Menus.INSTANCE.getWirelessAutocraftingMonitor(), AutocraftingMonitorScreen::new);
    }

    protected static void registerAlternativeGridHints() {
        RefinedStorageClientApi.INSTANCE.addAlternativeGridInsertionHint(new FluidGridInsertionHint());
    }

    protected static void registerResourceRendering() {
        RefinedStorageClientApi.INSTANCE.registerResourceRendering(ItemResource.class, ItemResourceRendering.INSTANCE);
        RefinedStorageClientApi.INSTANCE.registerResourceRendering(FluidResource.class, new FluidResourceRendering(Platform.INSTANCE.getBucketAmount()));
    }

    protected static void handleInputEvents() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_304 openWirelessGrid = KeyMappings.INSTANCE.getOpenWirelessGrid();
        while (openWirelessGrid != null && openWirelessGrid.method_1436()) {
            RefinedStorageApi.INSTANCE.useSlotReferencedItem((class_1657)player, Items.INSTANCE.getWirelessGrid(), Items.INSTANCE.getCreativeWirelessGrid());
        }
        class_304 openPortableGrid = KeyMappings.INSTANCE.getOpenPortableGrid();
        while (openPortableGrid != null && openPortableGrid.method_1436()) {
            RefinedStorageApi.INSTANCE.useSlotReferencedItem((class_1657)player, new class_1792[]{Items.INSTANCE.getPortableGrid(), Items.INSTANCE.getCreativePortableGrid()});
        }
        class_304 openWirelessAutocraftingMonitor = KeyMappings.INSTANCE.getOpenWirelessAutocraftingMonitor();
        while (openWirelessAutocraftingMonitor != null && openWirelessAutocraftingMonitor.method_1436()) {
            RefinedStorageApi.INSTANCE.useSlotReferencedItem((class_1657)player, Items.INSTANCE.getWirelessAutocraftingMonitor(), Items.INSTANCE.getCreativeWirelessAutocraftingMonitor());
        }
    }

    protected static void registerDiskModels() {
        class_2960 diskModel = IdentifierUtil.createIdentifier("block/disk/disk");
        for (ItemStorageVariant variant : ItemStorageVariant.values()) {
            class_1792 item = Items.INSTANCE.getItemStorageDisk(variant);
            RefinedStorageClientApi.INSTANCE.registerDiskModel(item, diskModel);
        }
        class_2960 fluidDiskModel = IdentifierUtil.createIdentifier("block/disk/fluid_disk");
        for (FluidStorageVariant variant : FluidStorageVariant.values()) {
            class_1792 item = Items.INSTANCE.getFluidStorageDisk(variant);
            RefinedStorageClientApi.INSTANCE.registerDiskModel(item, fluidDiskModel);
        }
    }

    protected static CompositeClientTooltipComponent createRegulatorUpgradeClientTooltipComponent(Set<UpgradeMapping> destinations, @Nullable ResourceAmount configuredResource, class_2561 help) {
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        if (configuredResource != null) {
            components.add(new ResourceClientTooltipComponent(configuredResource));
        } else {
            components.add(new UpgradeDestinationClientTooltipComponent(destinations));
        }
        components.add(HelpClientTooltipComponent.create(help));
        return new CompositeClientTooltipComponent(components);
    }

    @FunctionalInterface
    public static interface ScreenConstructor<T extends class_1703, U extends class_437> {
        public U create(T var1, class_1661 var2, class_2561 var3);
    }

    @FunctionalInterface
    public static interface ScreenRegistration {
        public <M extends class_1703, U extends class_437> void register(class_3917<? extends M> var1, ScreenConstructor<M, U> var2);
    }
}

