/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.core.component.ComponentMapFactory;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.NetworkBuilder;
import com.refinedmods.refinedstorage.api.network.NetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.NetworkBuilderImpl;
import com.refinedmods.refinedstorage.api.network.impl.NetworkFactory;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategyFactory;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategyFactory;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.GridSynchronizer;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.importer.ImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.api.storage.externalstorage.ExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.registry.PlatformRegistry;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceFactory;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceProvider;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.api.wirelesstransmitter.WirelessTransmitterRangeModifier;
import com.refinedmods.refinedstorage.common.autocrafting.CompositePatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.common.content.ContentIds;
import com.refinedmods.refinedstorage.common.grid.NoopGridSynchronizer;
import com.refinedmods.refinedstorage.common.grid.strategy.CompositeGridExtractionStrategy;
import com.refinedmods.refinedstorage.common.grid.strategy.CompositeGridInsertionStrategy;
import com.refinedmods.refinedstorage.common.grid.strategy.CompositeGridScrollingStrategy;
import com.refinedmods.refinedstorage.common.grid.view.GridResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.networking.CompositeWirelessTransmitterRangeModifier;
import com.refinedmods.refinedstorage.common.storage.ClientStorageRepository;
import com.refinedmods.refinedstorage.common.storage.StorageContainerItemHelperImpl;
import com.refinedmods.refinedstorage.common.storage.StorageRepositoryImpl;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlock;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockBlockEntity;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockCodecs;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockContainerMenu;
import com.refinedmods.refinedstorage.common.storagemonitor.CompositeStorageMonitorExtractionStrategy;
import com.refinedmods.refinedstorage.common.storagemonitor.CompositeStorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.energy.EnergyItemHelperImpl;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemEnergyStorage;
import com.refinedmods.refinedstorage.common.support.network.ConnectionProviderImpl;
import com.refinedmods.refinedstorage.common.support.network.InWorldNetworkNodeContainerBuilder;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeContainerProviderImpl;
import com.refinedmods.refinedstorage.common.support.network.item.NetworkItemHelperImpl;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.registry.PlatformRegistryImpl;
import com.refinedmods.refinedstorage.common.support.resource.CompositeRecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.support.resource.FluidResourceFactory;
import com.refinedmods.refinedstorage.common.support.resource.ItemResourceFactory;
import com.refinedmods.refinedstorage.common.support.slotreference.CompositeSlotReferenceProvider;
import com.refinedmods.refinedstorage.common.support.slotreference.InventorySlotReference;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeRegistryImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.ServerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class RefinedStorageApiImpl
implements RefinedStorageApi {
    private static final class_5250 NO_PERMISSION = IdentifierUtil.createTranslation("misc", "no_permission");
    private final StorageRepository clientStorageRepository = new ClientStorageRepository(C2SPackets::sendStorageInfoRequest);
    private final ComponentMapFactory<NetworkComponent, Network> networkComponentMapFactory = new ComponentMapFactory();
    private final NetworkBuilder networkBuilder = new NetworkBuilderImpl(new NetworkFactory(this.networkComponentMapFactory));
    private final PlatformRegistry<StorageType> storageTypeRegistry = new PlatformRegistryImpl<StorageType>();
    private final PlatformRegistry<ResourceType> resourceTypeRegistry = new PlatformRegistryImpl<ResourceType>();
    private final PlatformRegistry<GridSynchronizer> gridSynchronizerRegistry = new PlatformRegistryImpl<GridSynchronizer>();
    private final GridResourceRepositoryMapper gridResourceRepositoryMapper = new GridResourceRepositoryMapper();
    private final PlatformRegistry<ImporterTransferStrategyFactory> importerTransferStrategyRegistry = new PlatformRegistryImpl<ImporterTransferStrategyFactory>();
    private final PlatformRegistry<ExporterTransferStrategyFactory> exporterTransferStrategyRegistry = new PlatformRegistryImpl<ExporterTransferStrategyFactory>();
    private final UpgradeRegistry upgradeRegistry = new UpgradeRegistryImpl();
    private final List<ExternalStorageProviderFactory> externalStorageProviderFactories = new ArrayList<ExternalStorageProviderFactory>();
    private final Queue<DestructorStrategyFactory> destructorStrategyFactories = new PriorityQueue<DestructorStrategyFactory>(Comparator.comparingInt(DestructorStrategyFactory::getPriority));
    private final Queue<ConstructorStrategyFactory> constructorStrategyFactories = new PriorityQueue<ConstructorStrategyFactory>(Comparator.comparingInt(ConstructorStrategyFactory::getPriority));
    private final CompositeStorageMonitorInsertionStrategy storageMonitorInsertionStrategy = new CompositeStorageMonitorInsertionStrategy();
    private final CompositeStorageMonitorExtractionStrategy storageMonitorExtractionStrategy = new CompositeStorageMonitorExtractionStrategy();
    private final CompositeRecipeModIngredientConverter ingredientConverter = new CompositeRecipeModIngredientConverter();
    private final StorageContainerItemHelper storageContainerItemHelper = new StorageContainerItemHelperImpl();
    private final List<GridInsertionStrategyFactory> gridInsertionStrategyFactories = new ArrayList<GridInsertionStrategyFactory>();
    private final List<GridExtractionStrategyFactory> gridExtractionStrategyFactories = new ArrayList<GridExtractionStrategyFactory>();
    private final List<GridScrollingStrategyFactory> gridScrollingStrategyFactories = new ArrayList<GridScrollingStrategyFactory>();
    private final ResourceFactory itemResourceFactory = new ItemResourceFactory();
    private final ResourceFactory fluidResourceFactory = new FluidResourceFactory();
    private final Set<ResourceFactory> resourceFactories = new HashSet<ResourceFactory>();
    private final CompositeWirelessTransmitterRangeModifier wirelessTransmitterRangeModifier = new CompositeWirelessTransmitterRangeModifier();
    private final EnergyItemHelper energyItemHelper = new EnergyItemHelperImpl();
    private final NetworkItemHelper networkItemHelper = new NetworkItemHelperImpl();
    private final PlatformRegistry<SlotReferenceFactory> slotReferenceFactoryRegistry = new PlatformRegistryImpl<SlotReferenceFactory>();
    private final CompositeSlotReferenceProvider slotReferenceProvider = new CompositeSlotReferenceProvider();
    private final PlatformRegistry<PlatformPermission> permissionRegistry = new PlatformRegistryImpl<PlatformPermission>();
    private final List<ResourceContainerInsertStrategy> resourceExtractStrategies = new ArrayList<ResourceContainerInsertStrategy>();
    private final WeakHashMap<class_1937, Map<UUID, Pattern>> patternCache = new WeakHashMap();
    private final CompositePatternProviderExternalPatternSinkFactory patternProviderExternalPatternSinkFactory = new CompositePatternProviderExternalPatternSinkFactory();

    public RefinedStorageApiImpl() {
        this.gridSynchronizerRegistry.register(IdentifierUtil.createIdentifier("off"), NoopGridSynchronizer.INSTANCE);
    }

    @Override
    public PlatformRegistry<StorageType> getStorageTypeRegistry() {
        return this.storageTypeRegistry;
    }

    @Override
    public StorageRepository getClientStorageRepository() {
        return this.clientStorageRepository;
    }

    @Override
    public StorageRepository getStorageRepository(class_1937 level) {
        class_3218 serverLevel = Objects.requireNonNull(level.method_8503().method_3847(class_1937.field_25179));
        return (StorageRepository)serverLevel.method_17983().method_17924(new class_18.class_8645(StorageRepositoryImpl::new, StorageRepositoryImpl::new, null), "refinedstorage_storages");
    }

    @Override
    public StorageContainerItemHelper getStorageContainerItemHelper() {
        return this.storageContainerItemHelper;
    }

    @Override
    public PlatformRegistry<ResourceType> getResourceTypeRegistry() {
        return this.resourceTypeRegistry;
    }

    @Override
    public PlatformRegistry<ImporterTransferStrategyFactory> getImporterTransferStrategyRegistry() {
        return this.importerTransferStrategyRegistry;
    }

    @Override
    public PlatformRegistry<ExporterTransferStrategyFactory> getExporterTransferStrategyRegistry() {
        return this.exporterTransferStrategyRegistry;
    }

    @Override
    public void addExternalStorageProviderFactory(ExternalStorageProviderFactory factory) {
        this.externalStorageProviderFactories.add(factory);
    }

    @Override
    public Collection<ExternalStorageProviderFactory> getExternalStorageProviderFactories() {
        return this.externalStorageProviderFactories;
    }

    @Override
    public Collection<DestructorStrategyFactory> getDestructorStrategyFactories() {
        return this.destructorStrategyFactories;
    }

    @Override
    public void addDestructorStrategyFactory(DestructorStrategyFactory factory) {
        this.destructorStrategyFactories.add(factory);
    }

    @Override
    public Collection<ConstructorStrategyFactory> getConstructorStrategyFactories() {
        return this.constructorStrategyFactories;
    }

    @Override
    public void addConstructorStrategyFactory(ConstructorStrategyFactory factory) {
        this.constructorStrategyFactories.add(factory);
    }

    @Override
    public void addStorageMonitorExtractionStrategy(StorageMonitorExtractionStrategy strategy) {
        this.storageMonitorExtractionStrategy.addStrategy(strategy);
    }

    @Override
    public StorageMonitorExtractionStrategy getStorageMonitorExtractionStrategy() {
        return this.storageMonitorExtractionStrategy;
    }

    @Override
    public void addStorageMonitorInsertionStrategy(StorageMonitorInsertionStrategy strategy) {
        this.storageMonitorInsertionStrategy.addStrategy(strategy);
    }

    @Override
    public StorageMonitorInsertionStrategy getStorageMonitorInsertionStrategy() {
        return this.storageMonitorInsertionStrategy;
    }

    @Override
    public void addPatternProviderExternalPatternSinkFactory(PatternProviderExternalPatternSinkFactory factory) {
        this.patternProviderExternalPatternSinkFactory.addFactory(factory);
    }

    @Override
    public PatternProviderExternalPatternSinkFactory getPatternProviderExternalPatternSinkFactory() {
        return this.patternProviderExternalPatternSinkFactory;
    }

    @Override
    public ComponentMapFactory<NetworkComponent, Network> getNetworkComponentMapFactory() {
        return this.networkComponentMapFactory;
    }

    @Override
    public PlatformRegistry<GridSynchronizer> getGridSynchronizerRegistry() {
        return this.gridSynchronizerRegistry;
    }

    @Override
    public ResourceRepositoryMapper<GridResource> getGridResourceRepositoryMapper() {
        return this.gridResourceRepositoryMapper;
    }

    @Override
    public void addGridResourceRepositoryMapper(Class<? extends ResourceKey> resourceClass, ResourceRepositoryMapper<GridResource> mapper) {
        this.gridResourceRepositoryMapper.addFactory(resourceClass, mapper);
    }

    @Override
    public UpgradeRegistry getUpgradeRegistry() {
        return this.upgradeRegistry;
    }

    @Override
    public NetworkNodeContainerProvider createNetworkNodeContainerProvider() {
        return new NetworkNodeContainerProviderImpl();
    }

    @Override
    public InWorldNetworkNodeContainer.Builder createNetworkNodeContainer(class_2586 blockEntity, NetworkNode networkNode) {
        return new InWorldNetworkNodeContainerBuilder(blockEntity, networkNode);
    }

    @Override
    public void initializeNetworkNodeContainer(InWorldNetworkNodeContainer container, @Nullable class_1937 level, @Nullable Runnable callback) {
        if (level == null || level.method_8608()) {
            return;
        }
        ConnectionProviderImpl connectionProvider = new ConnectionProviderImpl(level);
        ServerListener.queue(server -> {
            if (container.isRemoved()) {
                return;
            }
            this.networkBuilder.initialize(container, connectionProvider);
            if (callback != null) {
                callback.run();
            }
        });
    }

    @Override
    public void removeNetworkNodeContainer(InWorldNetworkNodeContainer container, @Nullable class_1937 level) {
        if (level == null || level.method_8608()) {
            return;
        }
        if (container.getNode().getNetwork() == null) {
            return;
        }
        ConnectionProviderImpl connectionProvider = new ConnectionProviderImpl(level);
        this.networkBuilder.remove(container, connectionProvider);
    }

    @Override
    public void updateNetworkNodeContainer(InWorldNetworkNodeContainer container, @Nullable class_1937 level) {
        if (level == null || level.method_8608() || container.getNode().getNetwork() == null) {
            return;
        }
        ConnectionProviderImpl connectionProvider = new ConnectionProviderImpl(level);
        this.networkBuilder.update(container, connectionProvider);
    }

    @Override
    public GridInsertionStrategy createGridInsertionStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        return new CompositeGridInsertionStrategy(Platform.INSTANCE.getDefaultGridInsertionStrategyFactory().create(containerMenu, player, grid), this.gridInsertionStrategyFactories.stream().map(f -> f.create(containerMenu, player, grid)).toList());
    }

    @Override
    public void addGridInsertionStrategyFactory(GridInsertionStrategyFactory insertionStrategyFactory) {
        this.gridInsertionStrategyFactories.add(insertionStrategyFactory);
    }

    @Override
    public void addResourceContainerInsertStrategy(ResourceContainerInsertStrategy strategy) {
        this.resourceExtractStrategies.add(strategy);
    }

    @Override
    public Collection<ResourceContainerInsertStrategy> getResourceContainerInsertStrategies() {
        return Collections.unmodifiableList(this.resourceExtractStrategies);
    }

    @Override
    public GridExtractionStrategy createGridExtractionStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        List<GridExtractionStrategy> strategies = this.gridExtractionStrategyFactories.stream().map(f -> f.create(containerMenu, player, grid)).toList();
        return new CompositeGridExtractionStrategy(strategies);
    }

    @Override
    public void addGridExtractionStrategyFactory(GridExtractionStrategyFactory extractionStrategyFactory) {
        this.gridExtractionStrategyFactories.add(extractionStrategyFactory);
    }

    @Override
    public GridScrollingStrategy createGridScrollingStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        List<GridScrollingStrategy> strategies = this.gridScrollingStrategyFactories.stream().map(f -> f.create(containerMenu, player, grid)).toList();
        return new CompositeGridScrollingStrategy(strategies);
    }

    @Override
    public void addGridScrollingStrategyFactory(GridScrollingStrategyFactory scrollingStrategyFactory) {
        this.gridScrollingStrategyFactories.add(scrollingStrategyFactory);
    }

    @Override
    public void addResourceFactory(ResourceFactory factory) {
        this.resourceFactories.add(factory);
    }

    @Override
    public ResourceFactory getItemResourceFactory() {
        return this.itemResourceFactory;
    }

    @Override
    public StorageType getItemStorageType() {
        return StorageTypes.ITEM;
    }

    @Override
    public ResourceFactory getFluidResourceFactory() {
        return this.fluidResourceFactory;
    }

    @Override
    public StorageType getFluidStorageType() {
        return StorageTypes.FLUID;
    }

    @Override
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.resourceFactories;
    }

    @Override
    public void addIngredientConverter(RecipeModIngredientConverter converter) {
        this.ingredientConverter.addConverter(converter);
    }

    @Override
    public RecipeModIngredientConverter getIngredientConverter() {
        return this.ingredientConverter;
    }

    @Override
    public void addWirelessTransmitterRangeModifier(WirelessTransmitterRangeModifier rangeModifier) {
        this.wirelessTransmitterRangeModifier.addModifier(rangeModifier);
    }

    @Override
    public WirelessTransmitterRangeModifier getWirelessTransmitterRangeModifier() {
        return this.wirelessTransmitterRangeModifier;
    }

    @Override
    public Optional<EnergyStorage> getEnergyStorage(class_1799 stack) {
        return Platform.INSTANCE.getEnergyStorage(stack);
    }

    @Override
    public EnergyItemHelper getEnergyItemHelper() {
        return this.energyItemHelper;
    }

    @Override
    public EnergyStorage asItemEnergyStorage(EnergyStorage energyStorage, class_1799 stack) {
        return new ItemEnergyStorage(stack, energyStorage);
    }

    @Override
    public EnergyStorage asBlockItemEnergyStorage(EnergyStorage energyStorage, class_1799 stack, class_2591<?> blockEntityType) {
        return new ItemBlockEnergyStorage(energyStorage, stack, blockEntityType);
    }

    @Override
    public NetworkItemHelper getNetworkItemHelper() {
        return this.networkItemHelper;
    }

    @Override
    public PlatformRegistry<SlotReferenceFactory> getSlotReferenceFactoryRegistry() {
        return this.slotReferenceFactoryRegistry;
    }

    @Override
    public void addSlotReferenceProvider(SlotReferenceProvider provider) {
        this.slotReferenceProvider.addProvider(provider);
    }

    @Override
    public SlotReference createInventorySlotReference(class_1657 player, class_1268 hand) {
        return InventorySlotReference.of(player, hand);
    }

    @Override
    public void useSlotReferencedItem(class_1657 player, class_1792 ... items) {
        HashSet<class_1792> validItems = new HashSet<class_1792>(Arrays.asList(items));
        this.slotReferenceProvider.findForUse(player, items[0], validItems).ifPresent(C2SPackets::sendUseSlotReferencedItem);
    }

    @Override
    public PlatformRegistry<PlatformPermission> getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Override
    public SecurityPolicy createDefaultSecurityPolicy() {
        return new SecurityPolicy(this.permissionRegistry.getAll().stream().filter(PlatformPermission::isAllowedByDefault).collect(Collectors.toSet()));
    }

    @Override
    public void sendNoPermissionToOpenMessage(class_3222 player, class_2561 target) {
        this.sendMessage(player, (class_2561)NO_PERMISSION, (class_2561)IdentifierUtil.createTranslation("misc", "no_permission.open", target));
    }

    @Override
    public void sendNoPermissionMessage(class_3222 player, class_2561 message) {
        this.sendMessage(player, (class_2561)NO_PERMISSION, message);
    }

    @Override
    public void sendMessage(class_3222 player, class_2561 title, class_2561 message) {
        S2CPackets.sendMessage(player, title, message);
    }

    @Override
    public boolean canPlaceNetworkNode(class_3222 player, class_1937 level, class_2338 pos, class_2680 state) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjacentPos = pos.method_10093(direction);
            NetworkNodeContainerProvider adjacentProvider = Platform.INSTANCE.getContainerProvider(level, adjacentPos, direction.method_10153());
            if (adjacentProvider == null || adjacentProvider.canBuild(player)) continue;
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(player, (class_2561)IdentifierUtil.createTranslation("misc", "no_permission.build.place", state.method_26204().method_9518()));
            return false;
        }
        return true;
    }

    @Override
    public Optional<Pattern> getPattern(class_1799 stack, class_1937 level) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof PatternProviderItem)) {
            return Optional.empty();
        }
        PatternProviderItem providerItem = (PatternProviderItem)class_17922;
        UUID id = providerItem.getId(stack);
        if (id == null) {
            return Optional.empty();
        }
        Map patternLevelCache = this.patternCache.computeIfAbsent(level, l -> new HashMap());
        return Optional.ofNullable(patternLevelCache.computeIfAbsent(id, i -> providerItem.getPattern(stack, level).orElse(null)));
    }

    @Override
    public class_2960 getCreativeModeTabId() {
        return ContentIds.CREATIVE_MODE_TAB;
    }

    @Override
    public class_2960 getColoredCreativeModeTabId() {
        return ContentIds.COLORED_CREATIVE_MODE_TAB;
    }

    @Override
    public AbstractNetworkNodeContainerBlockEntity<?> createStorageBlockEntity(class_2338 pos, class_2680 state, StorageBlockProvider provider) {
        return new StorageBlockBlockEntity(pos, state, provider);
    }

    @Override
    public class_2248 createStorageBlock(class_4970.class_2251 properties, StorageBlockProvider provider) {
        return new StorageBlock(properties, provider);
    }

    @Override
    public class_1703 createStorageBlockContainerMenu(int syncId, class_1657 player, StorageBlockData data, ResourceFactory resourceFactory, class_3917<?> menuType) {
        return new StorageBlockContainerMenu(menuType, syncId, player, data, resourceFactory);
    }

    @Override
    public class_9139<class_9129, StorageBlockData> getStorageBlockDataStreamCodec() {
        return StorageBlockCodecs.STREAM_CODEC;
    }
}

