/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.grid.view;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.3.0")
public abstract class AbstractGridResource<T extends PlatformResourceKey>
implements GridResource {
    protected final T resource;
    private final String name;
    private final Function<GridResourceAttributeKey, Set<String>> attributes;

    protected AbstractGridResource(T resource, String name, Map<GridResourceAttributeKey, Set<String>> attributes) {
        this.resource = resource;
        this.name = name;
        this.attributes = key -> attributes.getOrDefault(key, Collections.emptySet());
    }

    protected AbstractGridResource(T resource, String name, Function<GridResourceAttributeKey, Set<String>> attributes) {
        this.resource = resource;
        this.name = name;
        this.attributes = attributes;
    }

    @Override
    @Nullable
    public TrackedResource getTrackedResource(Function<ResourceKey, TrackedResource> trackedResourceProvider) {
        return trackedResourceProvider.apply((ResourceKey)this.resource);
    }

    @Override
    public long getAmount(ResourceRepository<GridResource> repository) {
        return repository.getAmount((ResourceKey)this.resource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getAttribute(GridResourceAttributeKey key) {
        return this.attributes.apply(key);
    }

    @Override
    public boolean isAutocraftable(ResourceRepository<GridResource> repository) {
        return repository.isSticky((ResourceKey)this.resource);
    }

    @Override
    @Nullable
    public PlatformResourceKey getResourceForRecipeMods() {
        return this.resource;
    }

    public String toString() {
        return "AbstractGridResource{resource=" + String.valueOf(this.resource) + ", name='" + this.name + "', attributes=" + String.valueOf(this.attributes) + "}";
    }
}

