/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.storage;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.4")
public abstract class AbstractStorageContainerBlockItem
extends class_1747 {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStorageContainerBlockItem.class);
    protected final StorageContainerItemHelper helper;

    protected AbstractStorageContainerBlockItem(class_2248 block, class_1792.class_1793 properties, StorageContainerItemHelper helper) {
        super(block, properties);
        this.helper = helper;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        super.method_7888(stack, level, entity, slotId, isSelected);
        this.helper.transferStorageIfNecessary(stack, level, entity, this::createStorage);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        return this.helper.tryDisassembly(level, player, stack, this.createPrimaryDisassemblyByproduct(stack.method_7947()), this.createSecondaryDisassemblyByproduct(stack.method_7947()));
    }

    protected boolean method_7710(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        if (!level.method_8608()) {
            this.updateBlockEntityTag(pos, level, stack);
        }
        return super.method_7710(pos, level, player, stack, state);
    }

    private void updateBlockEntityTag(class_2338 pos, class_1937 level, class_1799 stack) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StorageBlockEntity) {
            StorageBlockEntity blockEntity = (StorageBlockEntity)class_25862;
            this.helper.transferToBlockEntity(stack, blockEntity);
        } else {
            LOGGER.warn("Storage could not be set, block entity does not exist yet at {}", (Object)pos);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, context, tooltip, flag);
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getClientStorageRepository();
        this.helper.appendToTooltip(stack, storageRepository, tooltip, flag, this::formatAmount, this.getCapacity());
    }

    @Nullable
    protected abstract Long getCapacity();

    protected abstract String formatAmount(long var1);

    protected abstract SerializableStorage createStorage(StorageRepository var1);

    protected abstract class_1799 createPrimaryDisassemblyByproduct(int var1);

    @Nullable
    protected abstract class_1799 createSecondaryDisassemblyByproduct(int var1);
}

