/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.storage;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public abstract class AbstractStorageContainerItem
extends class_1792
implements StorageContainerItem {
    protected final StorageContainerItemHelper helper;

    protected AbstractStorageContainerItem(class_1792.class_1793 properties, StorageContainerItemHelper helper) {
        super(properties);
        this.helper = helper;
    }

    @Override
    public Optional<SerializableStorage> resolve(StorageRepository storageRepository, class_1799 stack) {
        return this.helper.resolveStorage(storageRepository, stack);
    }

    @Override
    public Optional<StorageInfo> getInfo(StorageRepository storageRepository, class_1799 stack) {
        return this.helper.getInfo(storageRepository, stack);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1799 primaryByproduct = this.createPrimaryDisassemblyByproduct(stack.method_7947());
        class_1799 secondaryByproduct = this.createSecondaryDisassemblyByproduct(stack.method_7947());
        return this.helper.tryDisassembly(level, player, stack, primaryByproduct, secondaryByproduct);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, level, entity, slot, selected);
        this.helper.transferStorageIfNecessary(stack, level, entity, this::createStorage);
        this.helper.loadStorageIfNecessary(stack, level, entity, this::createStorage);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, context, tooltip, flag);
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getClientStorageRepository();
        this.helper.appendToTooltip(stack, storageRepository, tooltip, flag, this::formatAmount, this.getCapacity());
    }

    @Nullable
    protected abstract Long getCapacity();

    protected abstract String formatAmount(long var1);

    protected abstract SerializableStorage createStorage(StorageRepository var1);

    protected abstract class_1799 createPrimaryDisassemblyByproduct(int var1);

    @Nullable
    protected abstract class_1799 createSecondaryDisassemblyByproduct(int var1);
}

