/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.autocrafting.PatternResolver;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

class CraftingPatternClientTooltipComponent
implements class_5684 {
    private static final long CYCLE_MS = 1000L;
    private static final int ARROW_SPACING = 8;
    private static final class_2960 LARGE_SLOT = IdentifierUtil.createIdentifier("large_slot");
    private static final int LARGE_SLOT_WIDTH = 26;
    private static final int LARGE_SLOT_HEIGHT = 26;
    private final int width;
    private final int height;
    private final PatternResolver.ResolvedCraftingPattern pattern;
    @Nullable
    private final class_1799 outputStack;
    @Nullable
    private final class_2561 outputText;
    private long cycleStart = 0L;
    private int currentCycle = 0;

    CraftingPatternClientTooltipComponent(int width, int height, PatternResolver.ResolvedCraftingPattern pattern) {
        ItemResource itemResource;
        this.width = width;
        this.height = height;
        this.pattern = pattern;
        ResourceKey resourceKey = pattern.output().resource();
        ItemResource outputResource = resourceKey instanceof ItemResource ? (itemResource = (ItemResource)resourceKey) : null;
        this.outputStack = outputResource != null ? outputResource.toItemStack(pattern.output().amount()) : null;
        this.outputText = outputResource != null ? class_2561.method_43470((String)String.format("%dx ", pattern.output().amount())).method_10852(outputResource.toItemStack().method_7964()).method_27692(class_124.field_1080) : null;
    }

    public int method_32661() {
        return 11 + this.height * 18 + 3;
    }

    public int method_32664(class_327 font) {
        return Math.max(this.outputText != null ? font.method_27525((class_5348)this.outputText) : 0, this.width * 18 + 8 + 22 + 8 + 26);
    }

    public void method_32666(class_327 font, int x, int y, class_332 graphics) {
        long now = System.currentTimeMillis();
        if (this.cycleStart == 0L) {
            this.cycleStart = now;
        }
        if (now - this.cycleStart >= 1000L) {
            ++this.currentCycle;
            this.cycleStart = now;
        }
        if (this.outputText != null) {
            graphics.method_27535(font, this.outputText, x, y, 0xAAAAAA);
        }
        this.renderInputSlots(x, y + 9 + 2, graphics);
        this.renderArrow(x, y + 9 + 2, graphics);
        this.renderResultSlot(font, x, y + 9 + 2, graphics);
    }

    private void renderInputSlots(int x, int y, class_332 graphics) {
        for (int sx = 0; sx < this.width; ++sx) {
            for (int sy = 0; sy < this.height; ++sy) {
                this.renderInputSlot(x, y, graphics, sx, sy);
            }
        }
    }

    private void renderInputSlot(int x, int y, class_332 graphics, int sx, int sy) {
        graphics.method_52706(Sprites.SLOT, x + sx * 18, y + sy * 18, 18, 18);
        int index = sy * this.width + sx;
        List<ResourceKey> inputs = this.pattern.inputs().get(index);
        if (inputs.isEmpty()) {
            return;
        }
        int idx = this.currentCycle % inputs.size();
        ResourceKey resource = inputs.get(idx);
        RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).render(resource, graphics, x + sx * 18 + 1, y + sy * 18 + 1);
    }

    private void renderArrow(int x, int y, class_332 graphics) {
        graphics.method_52706(Sprites.LIGHT_ARROW, x + this.width * 18 + 8, y + this.height * 18 / 2 - 7, 22, 15);
    }

    private void renderResultSlot(class_327 font, int x, int y, class_332 graphics) {
        int slotX = x + this.width * 18 + 8 + 22 + 8;
        int slotY = y + this.height * 18 / 2 - 13;
        graphics.method_52706(LARGE_SLOT, slotX, slotY, 26, 26);
        if (this.outputStack != null) {
            int stackX = slotX + 5;
            int stackY = slotY + 5;
            graphics.method_51427(this.outputStack, stackX, stackY);
            graphics.method_51431(font, this.outputStack, stackX, stackY);
        }
    }
}

