/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternResolver;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5632;

public class PatternItem
extends class_1792
implements PatternProviderItem {
    private static final Map<UUID, PatternResolver.ResolvedCraftingPattern> CRAFTING_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedCraftingPattern>();
    private static final Map<UUID, PatternResolver.ResolvedProcessingPattern> PROCESSING_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedProcessingPattern>();
    private static final Map<UUID, PatternResolver.ResolvedSmithingTablePattern> SMITHING_TABLE_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedSmithingTablePattern>();
    private static final Map<UUID, PatternResolver.ResolvedStonecutterPattern> STONE_CUTTER_PATTERN_CACHE = new HashMap<UUID, PatternResolver.ResolvedStonecutterPattern>();
    private static final class_2561 HELP = IdentifierUtil.createTranslation("item", "pattern.help");
    private static final class_5250 FUZZY_MODE = IdentifierUtil.createTranslation("item", "pattern.fuzzy_mode").method_27692(class_124.field_1054);
    private final PatternResolver resolver = new PatternResolver();

    public PatternItem() {
        super(new class_1792.class_1793());
    }

    public String method_7866(class_1799 stack) {
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (state != null) {
            return IdentifierUtil.createTranslationKey("misc", "pattern." + state.type().method_15434());
        }
        return super.method_7866(stack);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> lines, class_1836 tooltipFlag) {
        super.method_7851(stack, context, lines, tooltipFlag);
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return;
        }
        CraftingPatternState craftingState = (CraftingPatternState)stack.method_57824(DataComponents.INSTANCE.getCraftingPatternState());
        if (craftingState != null && craftingState.fuzzyMode()) {
            lines.add((class_2561)FUZZY_MODE);
        }
    }

    public boolean hasMapping(class_1799 stack) {
        return stack.method_57826(DataComponents.INSTANCE.getPatternState());
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return Optional.of(new HelpTooltipComponent(HELP));
        }
        class_1937 level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return Optional.empty();
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> {
                CraftingPatternState craftingState = (CraftingPatternState)stack.method_57824(DataComponents.INSTANCE.getCraftingPatternState());
                if (craftingState == null) {
                    yield Optional.empty();
                }
                yield this.getCachedCraftingPattern(state, stack, level).map(pattern -> new CraftingPatternTooltipComponent(state.id(), (PatternResolver.ResolvedCraftingPattern)pattern, craftingState.input().comp_2795().method_59991(), craftingState.input().comp_2795().method_59992()));
            }
            case PatternType.PROCESSING -> {
                ProcessingPatternState processingState = (ProcessingPatternState)stack.method_57824(DataComponents.INSTANCE.getProcessingPatternState());
                if (processingState == null) {
                    yield Optional.empty();
                }
                yield Optional.of(new ProcessingPatternTooltipComponent(state.id(), processingState));
            }
            case PatternType.STONECUTTER -> this.getCachedStonecutterPattern(state, stack, level).map(pattern -> new StonecutterPatternTooltipComponent(state.id(), (PatternResolver.ResolvedStonecutterPattern)pattern));
            case PatternType.SMITHING_TABLE -> this.getCachedSmithingTablePattern(state, stack, level).map(pattern -> new SmithingTablePatternTooltipComponent(state.id(), (PatternResolver.ResolvedSmithingTablePattern)pattern));
        };
    }

    @Override
    @Nullable
    public UUID getId(class_1799 stack) {
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return null;
        }
        return state.id();
    }

    @Override
    public Optional<Pattern> getPattern(class_1799 stack, class_1937 level) {
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return Optional.empty();
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> this.resolver.getCraftingPattern(stack, level, state).map(PatternResolver.ResolvedCraftingPattern::pattern);
            case PatternType.PROCESSING -> this.resolver.getProcessingPattern(state, stack).map(PatternResolver.ResolvedProcessingPattern::pattern);
            case PatternType.STONECUTTER -> this.resolver.getStonecutterPattern(stack, level, state).map(PatternResolver.ResolvedStonecutterPattern::pattern);
            case PatternType.SMITHING_TABLE -> this.resolver.getSmithingTablePattern(state, stack, level).map(PatternResolver.ResolvedSmithingTablePattern::pattern);
        };
    }

    @Override
    public Optional<class_1799> getOutput(class_1799 stack, class_1937 level) {
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return Optional.empty();
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> this.getCachedCraftingPattern(state, stack, level).map(PatternResolver.ResolvedCraftingPattern::output).map(ResourceAmount::resource).filter(ItemResource.class::isInstance).map(ItemResource.class::cast).map(ItemResource::toItemStack);
            case PatternType.PROCESSING -> this.getCachedProcessingPattern(state, stack).map(PatternResolver.ResolvedProcessingPattern::pattern).filter(pattern -> pattern.layout().outputs().size() == 1).map(pattern -> pattern.layout().outputs().getFirst().resource()).filter(ItemResource.class::isInstance).map(ItemResource.class::cast).map(ItemResource::toItemStack);
            case PatternType.STONECUTTER -> this.getCachedStonecutterPattern(state, stack, level).map(PatternResolver.ResolvedStonecutterPattern::output).map(ItemResource::toItemStack);
            case PatternType.SMITHING_TABLE -> this.getCachedSmithingTablePattern(state, stack, level).map(PatternResolver.ResolvedSmithingTablePattern::output).map(ItemResource::toItemStack);
        };
    }

    private Optional<PatternResolver.ResolvedCraftingPattern> getCachedCraftingPattern(PatternState state, class_1799 stack, class_1937 level) {
        PatternResolver.ResolvedCraftingPattern pattern = CRAFTING_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getCraftingPattern(stack, level, state).map(resolved -> {
                CRAFTING_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedCraftingPattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    private Optional<PatternResolver.ResolvedSmithingTablePattern> getCachedSmithingTablePattern(PatternState state, class_1799 stack, class_1937 level) {
        PatternResolver.ResolvedSmithingTablePattern pattern = SMITHING_TABLE_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getSmithingTablePattern(state, stack, level).map(resolved -> {
                SMITHING_TABLE_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedSmithingTablePattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    private Optional<PatternResolver.ResolvedStonecutterPattern> getCachedStonecutterPattern(PatternState state, class_1799 stack, class_1937 level) {
        PatternResolver.ResolvedStonecutterPattern pattern = STONE_CUTTER_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getStonecutterPattern(stack, level, state).map(resolved -> {
                STONE_CUTTER_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedStonecutterPattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    private Optional<PatternResolver.ResolvedProcessingPattern> getCachedProcessingPattern(PatternState state, class_1799 stack) {
        PatternResolver.ResolvedProcessingPattern pattern = PROCESSING_PATTERN_CACHE.get(state.id());
        if (pattern == null) {
            return this.resolver.getProcessingPattern(state, stack).map(resolved -> {
                PROCESSING_PATTERN_CACHE.put(state.id(), (PatternResolver.ResolvedProcessingPattern)resolved);
                return resolved;
            });
        }
        return Optional.of(pattern);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!level.method_8608() && player.method_18276()) {
            return new class_1271(class_1269.field_21466, (Object)new class_1799((class_1935)Items.INSTANCE.getPattern(), stack.method_7947()));
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    public record ProcessingPatternTooltipComponent(UUID id, ProcessingPatternState state) implements class_5632
    {
    }

    public record SmithingTablePatternTooltipComponent(UUID id, PatternResolver.ResolvedSmithingTablePattern pattern) implements class_5632
    {
    }

    public record StonecutterPatternTooltipComponent(UUID id, PatternResolver.ResolvedStonecutterPattern pattern) implements class_5632
    {
    }

    public record CraftingPatternTooltipComponent(UUID id, PatternResolver.ResolvedCraftingPattern pattern, int width, int height) implements class_5632
    {
    }
}

