/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.SmithingTablePatternState;
import com.refinedmods.refinedstorage.common.autocrafting.StonecutterPatternState;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.class_9697;

public class PatternResolver {
    PatternResolver() {
    }

    Optional<ResolvedCraftingPattern> getCraftingPattern(class_1799 stack, class_1937 level, PatternState patternState) {
        CraftingPatternState craftingState = (CraftingPatternState)stack.method_57824(DataComponents.INSTANCE.getCraftingPatternState());
        if (craftingState == null) {
            return Optional.empty();
        }
        return this.getCraftingPattern(level, patternState, craftingState);
    }

    private Optional<ResolvedCraftingPattern> getCraftingPattern(class_1937 level, PatternState patternState, CraftingPatternState state) {
        RecipeMatrixContainer craftingMatrix = this.getFilledCraftingMatrix(state);
        class_9694.class_9765 positionedCraftingInput = craftingMatrix.method_60501();
        class_9694 craftingInput = positionedCraftingInput.comp_2795();
        return level.method_8433().method_8132(class_3956.field_17545, (class_9695)craftingInput, level).map(class_8786::comp_1933).map(recipe -> this.toCraftingPattern(level, (class_3955)recipe, craftingInput, state, patternState));
    }

    private RecipeMatrixContainer getFilledCraftingMatrix(CraftingPatternState state) {
        class_9694.class_9765 positionedInput = state.input();
        class_9694 input = positionedInput.comp_2795();
        RecipeMatrixContainer craftingMatrix = new RecipeMatrixContainer(null, input.method_59991(), input.method_59992());
        for (int i = 0; i < input.method_59983(); ++i) {
            craftingMatrix.method_5447(i, input.method_59984(i));
        }
        return craftingMatrix;
    }

    private ResolvedCraftingPattern toCraftingPattern(class_1937 level, class_3955 recipe, class_9694 craftingInput, CraftingPatternState state, PatternState patternState) {
        List<List<ResourceKey>> inputs = this.getInputs(recipe, state);
        ResourceAmount output = this.getOutput(level, recipe, craftingInput);
        List<ResourceAmount> byproducts = this.getByproducts(recipe, craftingInput);
        return new ResolvedCraftingPattern(patternState.id(), inputs, output, byproducts);
    }

    private List<List<ResourceKey>> getInputs(class_3955 recipe, CraftingPatternState state) {
        ArrayList<List<ResourceKey>> inputs = new ArrayList<List<ResourceKey>>();
        for (int i = 0; i < state.input().comp_2795().method_59983(); ++i) {
            class_1799 input = state.input().comp_2795().method_59984(i);
            if (input.method_7960()) {
                inputs.add(Collections.emptyList());
                continue;
            }
            if (state.fuzzyMode()) {
                inputs.add(this.getFuzzyInput(recipe, state, i, input));
                continue;
            }
            inputs.add(List.of(ItemResource.ofItemStack(input)));
        }
        return inputs;
    }

    private List<ResourceKey> getFuzzyInput(class_3955 recipe, CraftingPatternState state, int index, class_1799 input) {
        int ingredientIndex;
        int width = state.input().comp_2795().method_59991();
        boolean mirror = this.isMirror((List<class_1856>)recipe.method_8117(), state.input().comp_2795(), width);
        int col = index % width;
        int row = index / width;
        int n = ingredientIndex = mirror ? width - 1 - col + row * width : index;
        if (ingredientIndex >= 0 && ingredientIndex < recipe.method_8117().size()) {
            class_1799[] ingredients = ((class_1856)recipe.method_8117().get(ingredientIndex)).method_8105();
            return Arrays.stream(ingredients).map(item -> ItemResource.ofItemStack(item)).toList();
        }
        return List.of(ItemResource.ofItemStack(input));
    }

    private boolean isMirror(List<class_1856> ingredients, class_9694 craftingInput, int width) {
        for (int i = 0; i < craftingInput.method_59983(); ++i) {
            class_1799 input = craftingInput.method_59984(i);
            if (input.method_7960()) continue;
            int row = i / width;
            int col = i % width;
            if (ingredients.get(row * width + col).method_8093(input)) {
                return false;
            }
            if (!ingredients.get(row * width + (width - 1 - col)).method_8093(input)) continue;
            return true;
        }
        return false;
    }

    private ResourceAmount getOutput(class_1937 level, class_3955 recipe, class_9694 craftingInput) {
        class_1799 outputStack = recipe.method_8116((class_9695)craftingInput, (class_7225.class_7874)level.method_30349());
        return new ResourceAmount(ItemResource.ofItemStack(outputStack), outputStack.method_7947());
    }

    private List<ResourceAmount> getByproducts(class_3955 recipe, class_9694 craftingInput) {
        return recipe.method_8111((class_9695)craftingInput).stream().filter(byproduct -> !byproduct.method_7960()).map(byproduct -> new ResourceAmount(ItemResource.ofItemStack(byproduct), byproduct.method_7947())).toList();
    }

    Optional<ResolvedProcessingPattern> getProcessingPattern(PatternState patternState, class_1799 stack) {
        ProcessingPatternState state = (ProcessingPatternState)stack.method_57824(DataComponents.INSTANCE.getProcessingPatternState());
        if (state == null || state.getIngredients().isEmpty() || state.getFlatOutputs().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ResolvedProcessingPattern(patternState.id(), state.getIngredients(), state.getFlatOutputs()));
    }

    Optional<ResolvedStonecutterPattern> getStonecutterPattern(class_1799 stack, class_1937 level, PatternState patternState) {
        StonecutterPatternState state = (StonecutterPatternState)stack.method_57824(DataComponents.INSTANCE.getStonecutterPatternState());
        if (state == null) {
            return Optional.empty();
        }
        return this.getStonecutterPattern(level, patternState, state);
    }

    private Optional<ResolvedStonecutterPattern> getStonecutterPattern(class_1937 level, PatternState patternState, StonecutterPatternState state) {
        class_9696 input = new class_9696(state.input().toItemStack());
        class_1799 selectedOutput = state.selectedOutput().toItemStack();
        List recipes = level.method_8433().method_17877(class_3956.field_17641, (class_9695)input, level);
        for (class_8786 recipe : recipes) {
            class_1799 output = ((class_3975)recipe.comp_1933()).method_59998(input, (class_7225.class_7874)level.method_30349());
            if (!class_1799.method_31577((class_1799)output, (class_1799)selectedOutput)) continue;
            return Optional.of(new ResolvedStonecutterPattern(patternState.id(), state.input(), ItemResource.ofItemStack(output)));
        }
        return Optional.empty();
    }

    Optional<ResolvedSmithingTablePattern> getSmithingTablePattern(PatternState patternState, class_1799 stack, class_1937 level) {
        SmithingTablePatternState state = (SmithingTablePatternState)stack.method_57824(DataComponents.INSTANCE.getSmithingTablePatternState());
        if (state == null) {
            return Optional.empty();
        }
        return this.getSmithingTablePattern(level, patternState, state);
    }

    private Optional<ResolvedSmithingTablePattern> getSmithingTablePattern(class_1937 level, PatternState patternState, SmithingTablePatternState state) {
        class_9697 input = new class_9697(state.template().toItemStack(), state.base().toItemStack(), state.addition().toItemStack());
        return level.method_8433().method_8132(class_3956.field_25388, (class_9695)input, level).map(recipe -> new ResolvedSmithingTablePattern(patternState.id(), state.template(), state.base(), state.addition(), ItemResource.ofItemStack(((class_8059)recipe.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)level.method_30349()))));
    }

    public record ResolvedCraftingPattern(List<List<ResourceKey>> inputs, ResourceAmount output, Pattern pattern) {
        ResolvedCraftingPattern(UUID id, List<List<ResourceKey>> inputs, ResourceAmount output, List<ResourceAmount> byproducts) {
            this(inputs, output, new Pattern(id, PatternLayout.internal(inputs.stream().filter(i -> !i.isEmpty()).map(i -> new Ingredient(1L, (List<ResourceKey>)i)).toList(), List.of(output), byproducts)));
        }
    }

    public record ResolvedProcessingPattern(Pattern pattern) {
        ResolvedProcessingPattern(UUID id, List<Ingredient> ingredients, List<ResourceAmount> outputs) {
            this(new Pattern(id, PatternLayout.external(ingredients, outputs)));
        }
    }

    public record ResolvedStonecutterPattern(ItemResource input, ItemResource output, Pattern pattern) {
        ResolvedStonecutterPattern(UUID id, ItemResource input, ItemResource output) {
            this(input, output, new Pattern(id, PatternLayout.internal(List.of(new Ingredient(1L, List.of(input))), List.of(new ResourceAmount(output, 1L)), List.of())));
        }
    }

    public record ResolvedSmithingTablePattern(ItemResource template, ItemResource base, ItemResource addition, ItemResource output, Pattern pattern) {
        ResolvedSmithingTablePattern(UUID id, ItemResource template, ItemResource base, ItemResource addition, ItemResource output) {
            this(template, base, addition, output, new Pattern(id, PatternLayout.internal(List.of(ResolvedSmithingTablePattern.single(template), ResolvedSmithingTablePattern.single(base), ResolvedSmithingTablePattern.single(addition)), List.of(new ResourceAmount(output, 1L)), List.of())));
        }

        private static Ingredient single(ResourceKey input) {
            return new Ingredient(1L, List.of(input));
        }
    }
}

