/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.ExternalPatternSinkKeyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderListener;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterConnectionStrategy;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterParentContainer;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockModeSettings;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.TaskSnapshotPersistence;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutocrafterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<PatternProviderNetworkNode>
implements ExtendedMenuProvider<AutocrafterData>,
BlockEntityWithDrops,
PatternInventory.Listener,
StepBehavior,
ExternalPatternSinkKeyProvider,
PatternProviderExternalPatternSink,
PatternProviderListener {
    static final int PATTERNS = 9;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutocrafterBlockEntity.class);
    private static final int MAX_CHAINED_AUTOCRAFTERS = 8;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_PATTERNS = "patterns";
    private static final String TAG_LOCK_MODE = "lm";
    private static final String TAG_PRIORITY = "pri";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER = "vaum";
    private static final String TAG_LOCKED = "locked";
    private static final String TAG_WAS_POWERED = "wp";
    private final PatternInventory patternContainer = new PatternInventory(9, () -> ((AutocrafterBlockEntity)this).method_10997());
    private final UpgradeContainer upgradeContainer;
    private LockMode lockMode = LockMode.NEVER;
    private boolean visibleToTheAutocrafterManager = true;
    private int ticks;
    private int steps = AutocrafterBlockEntity.getSteps(0);
    private int tickRate = AutocrafterBlockEntity.getTickRate(0);
    @Nullable
    private PlatformPatternProviderExternalPatternSink sink;
    @Nullable
    private ExternalPatternSinkKey sinkKey;
    private boolean wasPowered;
    private boolean locked;

    public AutocrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getAutocrafter(), pos, state, new PatternProviderNetworkNode(Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage(), 9));
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((PatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            int amountOfSpeedUpgrades = c.getAmount(Items.INSTANCE.getSpeedUpgrade());
            this.tickRate = AutocrafterBlockEntity.getTickRate(amountOfSpeedUpgrades);
            this.steps = AutocrafterBlockEntity.getSteps(amountOfSpeedUpgrades);
            this.method_5431();
        });
        this.patternContainer.method_5489(container -> {
            long upgradeEnergyUsage = this.upgradeContainer.getEnergyUsage();
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((PatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            this.method_5431();
        });
        this.patternContainer.setListener(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setStepBehavior(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setSinkKeyProvider(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setSink(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setListener(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).onAddedIntoContainer(new AutocrafterParentContainer(this));
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(PatternProviderNetworkNode networkNode) {
        return new AutocrafterNetworkNodeContainer(this, networkNode, "main", new AutocrafterConnectionStrategy(() -> ((AutocrafterBlockEntity)this).method_11010(), this.method_11016()));
    }

    FilteredContainer getPatternContainer() {
        return this.patternContainer;
    }

    UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    private boolean isPartOfChain() {
        return this.getChainingRoot() != this;
    }

    private boolean isHeadOfChain() {
        if (this.field_11863 == null || this.isPartOfChain()) {
            return false;
        }
        for (class_2350 direction : class_2350.values()) {
            AutocrafterBlockEntity neighborAutocrafter;
            class_2350 neighborDirection;
            class_2586 neighbor;
            class_2338 pos = this.method_11016().method_10093(direction);
            if (!this.field_11863.method_8477(pos) || !((neighbor = this.field_11863.method_8321(pos)) instanceof AutocrafterBlockEntity) || (neighborDirection = AbstractDirectionalBlock.tryExtractDirection((neighborAutocrafter = (AutocrafterBlockEntity)neighbor).method_11010())) != direction.method_10153()) continue;
            return true;
        }
        return false;
    }

    private AutocrafterBlockEntity getChainingRoot() {
        return this.getChainingRoot(0, this);
    }

    private AutocrafterBlockEntity getChainingRoot(int depth, AutocrafterBlockEntity origin) {
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection(this.method_11010());
        if (this.field_11863 == null || direction == null || depth >= 8) {
            return origin;
        }
        class_2586 neighbor = this.getConnectedMachine();
        if (!(neighbor instanceof AutocrafterBlockEntity)) {
            return this;
        }
        AutocrafterBlockEntity neighborCrafter = (AutocrafterBlockEntity)neighbor;
        return neighborCrafter.getChainingRoot(depth + 1, origin);
    }

    @Nullable
    private class_2586 getConnectedMachine() {
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection(this.method_11010());
        if (this.field_11863 == null || direction == null) {
            return null;
        }
        class_2338 neighborPos = this.method_11016().method_10093(direction);
        if (!this.field_11863.method_8477(neighborPos)) {
            return null;
        }
        return this.field_11863.method_8321(neighborPos);
    }

    public class_2561 method_5477() {
        AutocrafterBlockEntity root = this.getChainingRoot();
        if (root == this) {
            return this.doGetName();
        }
        return root.method_5477();
    }

    private class_2561 doGetName() {
        class_2561 customName = this.method_5797();
        if (customName != null) {
            return customName;
        }
        class_2586 connectedMachine = this.getConnectedMachine();
        if (connectedMachine instanceof class_1275) {
            class_1275 nameable = (class_1275)connectedMachine;
            if (!(connectedMachine instanceof AutocrafterBlockEntity)) {
                return nameable.method_5477();
            }
        }
        if (connectedMachine != null) {
            return connectedMachine.method_11010().method_26204().method_9518();
        }
        return ContentNames.AUTOCRAFTER;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new AutocrafterContainerMenu(syncId, inventory, this);
    }

    @Override
    public AutocrafterData getMenuData() {
        return new AutocrafterData(this.isPartOfChain(), this.isHeadOfChain(), this.locked);
    }

    @Override
    public class_9142<class_9129, AutocrafterData> getMenuCodec() {
        return AutocrafterData.STREAM_CODEC;
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_PATTERNS, (class_2520)ContainerUtil.write((class_1263)this.patternContainer, provider));
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
        tag.method_10556(TAG_LOCKED, this.locked);
        tag.method_10556(TAG_WAS_POWERED, this.wasPowered);
        class_2499 tasks = new class_2499();
        for (Task task : ((PatternProviderNetworkNode)this.mainNetworkNode).getTasks()) {
            if (!(task instanceof TaskImpl)) continue;
            TaskImpl taskImpl = (TaskImpl)task;
            try {
                tasks.add((Object)TaskSnapshotPersistence.encodeSnapshot(taskImpl.createSnapshot()));
            }
            catch (Exception e) {
                LOGGER.error("Error while saving task {} {}", new Object[]{task.getResource(), task.getAmount(), e});
            }
        }
        tag.method_10566(TAG_TASKS, (class_2520)tasks);
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569(TAG_LOCK_MODE, LockModeSettings.getLockMode(this.lockMode));
        tag.method_10569(TAG_PRIORITY, ((PatternProviderNetworkNode)this.mainNetworkNode).getPriority());
        tag.method_10556(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, this.visibleToTheAutocrafterManager);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_PATTERNS)) {
            ContainerUtil.read(tag.method_10562(TAG_PATTERNS), (class_1263)this.patternContainer, provider);
        }
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        if (tag.method_10545(TAG_TASKS)) {
            class_2499 tasks = tag.method_10554(TAG_TASKS, 10);
            for (int i = 0; i < tasks.size(); ++i) {
                class_2487 taskTag = tasks.method_10602(i);
                try {
                    TaskSnapshot snapshot = TaskSnapshotPersistence.decodeSnapshot(taskTag);
                    ((PatternProviderNetworkNode)this.mainNetworkNode).addTask(new TaskImpl(snapshot));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error while loading task, skipping", (Throwable)e);
                }
            }
        }
        if (tag.method_10545(TAG_LOCKED)) {
            this.locked = tag.method_10577(TAG_LOCKED);
        }
        if (tag.method_10545(TAG_WAS_POWERED)) {
            this.wasPowered = tag.method_10577(TAG_WAS_POWERED);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545(TAG_LOCK_MODE)) {
            this.lockMode = LockModeSettings.getLockMode(tag.method_10550(TAG_LOCK_MODE));
        }
        if (tag.method_10545(TAG_PRIORITY)) {
            ((PatternProviderNetworkNode)this.mainNetworkNode).setPriority(tag.method_10550(TAG_PRIORITY));
        }
        if (tag.method_10545(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)) {
            this.visibleToTheAutocrafterManager = tag.method_10577(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER);
        }
    }

    @Override
    protected boolean hasRedstoneMode() {
        return false;
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    public class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        drops.addAll(this.upgradeContainer.getDrops());
        for (int i = 0; i < this.patternContainer.method_5439(); ++i) {
            drops.add((Object)this.patternContainer.method_5438(i));
        }
        return drops;
    }

    void setCustomName(String name) {
        if (this.isPartOfChain()) {
            return;
        }
        this.setCustomName((class_2561)(name.trim().isBlank() ? null : class_2561.method_43470((String)name)));
        this.method_5431();
    }

    LockMode getLockMode() {
        return this.lockMode;
    }

    void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        this.locked = false;
        this.wasPowered = false;
        this.method_5431();
    }

    int getPriority() {
        return ((PatternProviderNetworkNode)this.mainNetworkNode).getPriority();
    }

    void setPriority(int priority) {
        ((PatternProviderNetworkNode)this.mainNetworkNode).setPriority(priority);
        this.method_5431();
    }

    boolean isVisibleToTheAutocrafterManager() {
        return this.visibleToTheAutocrafterManager;
    }

    void setVisibleToTheAutocrafterManager(boolean visibleToTheAutocrafterManager) {
        this.visibleToTheAutocrafterManager = visibleToTheAutocrafterManager;
        this.method_5431();
    }

    @Override
    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.method_8608()) {
            return;
        }
        for (int i = 0; i < this.patternContainer.method_5439(); ++i) {
            this.patternChanged(i);
        }
    }

    @Override
    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = this.field_11867.method_10093(direction);
        this.invalidateSinkKey();
        this.sink = RefinedStorageApi.INSTANCE.getPatternProviderExternalPatternSinkFactory().create(level, sourcePosition, incomingDirection);
    }

    @Override
    public void patternChanged(int slot) {
        if (this.field_11863 == null) {
            return;
        }
        Pattern pattern = RefinedStorageApi.INSTANCE.getPattern(this.patternContainer.method_5438(slot), this.field_11863).orElse(null);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setPattern(slot, pattern);
    }

    @Override
    public void doWork() {
        super.doWork();
        if (((PatternProviderNetworkNode)this.mainNetworkNode).isActive()) {
            ++this.ticks;
        }
        this.updateLocked();
    }

    private void updateLocked() {
        boolean newLocked = this.calculateLocked();
        if (newLocked != this.locked) {
            this.setLocked(newLocked);
        }
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
        this.method_5431();
    }

    boolean isLocked() {
        return this.locked;
    }

    private boolean calculateLocked() {
        if (this.field_11863 == null) {
            return false;
        }
        return switch (this.lockMode) {
            default -> throw new MatchException(null, null);
            case LockMode.NEVER -> false;
            case LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED -> this.isLockedInPulseMode();
            case LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY -> {
                if (this.sink != null && !this.sink.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED -> this.locked;
            case LockMode.LOCK_UNTIL_HIGH_REDSTONE_SIGNAL -> {
                if (!this.field_11863.method_49803(this.field_11867)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_LOW_REDSTONE_SIGNAL -> this.field_11863.method_49803(this.field_11867);
        };
    }

    private boolean isLockedInPulseMode() {
        if (this.field_11863 != null && this.field_11863.method_49803(this.field_11867)) {
            this.wasPowered = true;
            this.method_5431();
        } else if (this.wasPowered) {
            this.wasPowered = false;
            this.method_5431();
            return false;
        }
        return this.locked;
    }

    @Override
    public boolean canStep(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return false;
        }
        if (provider == this.mainNetworkNode) {
            return ((PatternProviderNetworkNode)this.mainNetworkNode).isActive() && this.ticks % this.tickRate == 0;
        }
        return provider.canStep(pattern);
    }

    @Override
    public int getSteps(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return 0;
        }
        if (provider == this.mainNetworkNode) {
            return this.steps;
        }
        return provider.getSteps(pattern);
    }

    private static int getSteps(int amountOfSpeedUpgrades) {
        return switch (amountOfSpeedUpgrades) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            default -> 1;
        };
    }

    private static int getTickRate(int amountOfSpeedUpgrades) {
        return switch (amountOfSpeedUpgrades) {
            case 0 -> 10;
            case 1 -> 8;
            case 2 -> 6;
            case 3 -> 4;
            case 4 -> 2;
            default -> 0;
        };
    }

    @Nullable
    private PatternProvider lookupProvider(Pattern pattern) {
        Network network = ((PatternProviderNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return null;
        }
        return network.getComponent(AutocraftingNetworkComponent.class).getProviderByPattern(pattern);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    @Nullable
    public ExternalPatternSinkKey getKey() {
        if (this.sinkKey == null) {
            this.tryUpdateSinkKey();
        }
        return this.sinkKey;
    }

    private void tryUpdateSinkKey() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection(this.method_11010());
        if (direction == null) {
            return;
        }
        AutocrafterBlockEntity root = this.getChainingRoot();
        class_2586 connectedMachine = root.getConnectedMachine();
        if (connectedMachine == null) {
            this.invalidateSinkKey();
            return;
        }
        class_2680 connectedMachineState = connectedMachine.method_11010();
        class_1657 fakePlayer = this.getFakePlayer(serverLevel);
        class_1799 connectedMachineStack = Platform.INSTANCE.getBlockAsItemStack(connectedMachineState.method_26204(), connectedMachineState, direction.method_10153(), (class_4538)serverLevel, connectedMachine.method_11016(), fakePlayer);
        this.sinkKey = new InWorldExternalPatternSinkKey(this.method_5477().getString(), connectedMachineStack);
    }

    private void invalidateSinkKey() {
        this.sinkKey = null;
    }

    @Override
    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        AutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            return root.accept(resources, action);
        }
        if (this.sink == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        if (this.locked) {
            return ExternalPatternSink.Result.LOCKED;
        }
        ExternalPatternSink.Result result = this.sink.accept(resources, action);
        this.updateLockedAfterAccept(action, result);
        return result;
    }

    private void updateLockedAfterAccept(Action action, ExternalPatternSink.Result result) {
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && this.lockMode == LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY) {
            this.updateLocked();
        }
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && (this.lockMode == LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED || this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED)) {
            this.setLocked(true);
        }
    }

    @Override
    public void receivedExternalIteration() {
        AutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            root.receivedExternalIteration();
            return;
        }
        if (this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED && this.locked) {
            this.setLocked(false);
        }
    }
}

