/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocrafter;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.PatternType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;

final class TaskSnapshotPersistence {
    private static final String AMOUNT = "amount";
    private static final String INPUTS = "inputs";
    private static final String ORIGINAL_ITERATIONS_REMAINING = "originalIterationsRemaining";
    private static final String ITERATIONS_REMAINING = "iterationsRemaining";
    private static final String EXPECTED_OUTPUTS = "expectedOutputs";
    private static final String ITERATIONS_RECEIVED = "iterationsReceived";
    private static final String ITERATIONS_TO_SEND_TO_SINK = "iterationsToSendToSink";
    private static final String INTERCEPTED_ANYTHING_SINCE_LAST_STEP = "interceptedAnythingSinceLastStep";
    private static final String LAST_SINK_RESULT = "lastSinkResult";
    private static final String LAST_SINK_RESULT_KEY_NAME = "lastSinkResultKeyName";
    private static final String LAST_SINK_RESULT_KEY_STACK = "lastSinkResultKeyStack";
    private static final String PATTERN_MAP_KEY = "k";
    private static final String PATTERN_MAP_VALUE = "v";
    private static final String SIMULATED_ITERATION_INPUTS = "simulatedIterationInputs";
    private static final String ORIGINAL_ITERATIONS_TO_SEND_TO_SINK = "originalIterationsToSendToSink";
    private static final String PATTERN_TYPE = "type";
    private static final String INGREDIENTS = "ingredients";
    private static final String OUTPUTS = "outputs";
    private static final String BYPRODUCTS = "byproducts";
    private static final String ID = "id";
    private static final String EXTERNAL_PATTERN = "externalPattern";
    private static final String INTERNAL_PATTERN = "internalPattern";
    private static final String INTERNAL = "internal";
    private static final String ROOT = "root";
    private static final String PATTERN = "pattern";
    private static final String RESOURCE = "resource";
    private static final String ACTOR = "actor";
    private static final String NOTIFY_ACTOR = "notifyActor";
    private static final String START_TIME = "startTime";
    private static final String INITIAL_REQUIREMENTS = "initialRequirements";
    private static final String INTERNAL_STORAGE = "internalStorage";
    private static final String CANCELLED = "cancelled";
    private static final String TASK_STATE = "state";
    private static final String COMPLETED_PATTERNS = "completedPatterns";
    private static final String PATTERNS = "patterns";

    private TaskSnapshotPersistence() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static class_2487 encodeSnapshot(TaskSnapshot snapshot) {
        class_2487 tag = new class_2487();
        tag.method_25927(ID, snapshot.id().id());
        class_2487 resourceTag = TaskSnapshotPersistence.encodeResource(snapshot.resource());
        tag.method_10566(RESOURCE, (class_2520)resourceTag);
        tag.method_10544(AMOUNT, snapshot.amount());
        Actor actor = snapshot.actor();
        if (actor instanceof PlayerActor) {
            String name;
            PlayerActor playerActor = (PlayerActor)actor;
            try {
                String string;
                name = string = playerActor.name();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            tag.method_10582(ACTOR, name);
        }
        tag.method_10556(NOTIFY_ACTOR, snapshot.notifyActor());
        tag.method_10544(START_TIME, snapshot.startTime());
        tag.method_10566(INITIAL_REQUIREMENTS, (class_2520)TaskSnapshotPersistence.encodeResourceList(snapshot.initialRequirements()));
        tag.method_10566(INTERNAL_STORAGE, (class_2520)TaskSnapshotPersistence.encodeResourceList(snapshot.internalStorage()));
        tag.method_10556(CANCELLED, snapshot.cancelled());
        tag.method_10582(TASK_STATE, snapshot.state().name());
        class_2499 completedPatterns = new class_2499();
        snapshot.completedPatterns().forEach(pattern -> completedPatterns.add((Object)TaskSnapshotPersistence.encodePatternSnapshot(pattern)));
        tag.method_10566(COMPLETED_PATTERNS, (class_2520)completedPatterns);
        tag.method_10566(PATTERNS, (class_2520)TaskSnapshotPersistence.encodePatternMap(snapshot.patterns()));
        return tag;
    }

    private static class_2499 encodeResourceList(ResourceList list) {
        class_2499 listTag = new class_2499();
        list.getAll().forEach(resource -> {
            class_2487 entryTag = TaskSnapshotPersistence.encodeResource(resource);
            entryTag.method_10544(AMOUNT, list.get((ResourceKey)resource));
            listTag.add((Object)entryTag);
        });
        return listTag;
    }

    private static class_2487 encodePattern(Pattern pattern) {
        class_2487 tag = new class_2487();
        tag.method_25927(ID, pattern.id());
        class_2499 ingredients = new class_2499();
        for (Ingredient ingredient : pattern.layout().ingredients()) {
            ingredients.add((Object)TaskSnapshotPersistence.encodeIngredient(ingredient));
        }
        tag.method_10566(INGREDIENTS, (class_2520)ingredients);
        class_2499 outputs = new class_2499();
        for (ResourceAmount output : pattern.layout().outputs()) {
            outputs.add((Object)((class_2520)ResourceCodecs.AMOUNT_CODEC.encode((Object)output, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).getOrThrow()));
        }
        tag.method_10566(OUTPUTS, (class_2520)outputs);
        class_2499 class_24992 = new class_2499();
        for (ResourceAmount byproduct : pattern.layout().byproducts()) {
            class_24992.add((Object)((class_2520)ResourceCodecs.AMOUNT_CODEC.encode((Object)byproduct, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).getOrThrow()));
        }
        tag.method_10566(BYPRODUCTS, (class_2520)class_24992);
        tag.method_10582(PATTERN_TYPE, pattern.layout().type().name());
        return tag;
    }

    private static class_2487 encodePatternSnapshot(TaskSnapshot.PatternSnapshot snapshot) {
        class_2487 tag = new class_2487();
        tag.method_10556(ROOT, snapshot.root());
        tag.method_10566(PATTERN, (class_2520)TaskSnapshotPersistence.encodePattern(snapshot.pattern()));
        tag.method_10566(INGREDIENTS, (class_2520)TaskSnapshotPersistence.encodeIngredientMap(snapshot.ingredients()));
        boolean internal = snapshot.internalPattern() != null;
        tag.method_10556(INTERNAL, internal);
        if (snapshot.internalPattern() != null) {
            tag.method_10566(INTERNAL_PATTERN, (class_2520)TaskSnapshotPersistence.encodeInternalPattern(snapshot.internalPattern()));
        } else if (snapshot.externalPattern() != null) {
            tag.method_10566(EXTERNAL_PATTERN, (class_2520)TaskSnapshotPersistence.encodeExternalPattern(snapshot.externalPattern()));
        }
        return tag;
    }

    private static class_2499 encodePatternMap(Map<Pattern, TaskSnapshot.PatternSnapshot> patterns) {
        class_2499 patternMap = new class_2499();
        for (Map.Entry<Pattern, TaskSnapshot.PatternSnapshot> pattern : patterns.entrySet()) {
            class_2487 patternTag = new class_2487();
            patternTag.method_10566(PATTERN_MAP_KEY, (class_2520)TaskSnapshotPersistence.encodePattern(pattern.getKey()));
            patternTag.method_10566(PATTERN_MAP_VALUE, (class_2520)TaskSnapshotPersistence.encodePatternSnapshot(pattern.getValue()));
            patternMap.add((Object)patternTag);
        }
        return patternMap;
    }

    private static class_2487 encodeInternalPattern(TaskSnapshot.InternalPatternSnapshot internalPattern) {
        class_2487 tag = new class_2487();
        tag.method_10544(ORIGINAL_ITERATIONS_REMAINING, internalPattern.originalIterationsRemaining());
        tag.method_10544(ITERATIONS_REMAINING, internalPattern.iterationsRemaining());
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static class_2487 encodeExternalPattern(TaskSnapshot.ExternalPatternSnapshot externalPattern) {
        String name;
        String string;
        ExternalPatternSinkKey lastSinkResultKey;
        class_2487 tag = new class_2487();
        tag.method_10566(EXPECTED_OUTPUTS, (class_2520)TaskSnapshotPersistence.encodeResourceList(externalPattern.expectedOutputs()));
        tag.method_10566(SIMULATED_ITERATION_INPUTS, (class_2520)TaskSnapshotPersistence.encodeResourceList(externalPattern.simulatedIterationInputs()));
        tag.method_10544(ORIGINAL_ITERATIONS_TO_SEND_TO_SINK, externalPattern.originalIterationsToSendToSink());
        tag.method_10544(ITERATIONS_TO_SEND_TO_SINK, externalPattern.iterationsToSendToSink());
        tag.method_10544(ITERATIONS_RECEIVED, externalPattern.iterationsReceived());
        tag.method_10556(INTERCEPTED_ANYTHING_SINCE_LAST_STEP, externalPattern.interceptedAnythingSinceLastStep());
        if (externalPattern.lastSinkResult() != null) {
            tag.method_10582(LAST_SINK_RESULT, externalPattern.lastSinkResult().name());
        }
        if (!((lastSinkResultKey = externalPattern.lastSinkResultKey()) instanceof InWorldExternalPatternSinkKey)) return tag;
        InWorldExternalPatternSinkKey inWorldExternalPatternSinkKey = (InWorldExternalPatternSinkKey)lastSinkResultKey;
        try {
            name = string = inWorldExternalPatternSinkKey.name();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String stack = string = inWorldExternalPatternSinkKey.stack();
        tag.method_10582(LAST_SINK_RESULT_KEY_NAME, name);
        tag.method_10566(LAST_SINK_RESULT_KEY_STACK, (class_2520)class_1799.field_24671.encode((Object)stack, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).getOrThrow());
        return tag;
    }

    private static class_2499 encodeIngredientMap(Map<Integer, Map<ResourceKey, Long>> ingredients) {
        class_2499 ingredientMap = new class_2499();
        for (Map.Entry<Integer, Map<ResourceKey, Long>> ingredient : ingredients.entrySet()) {
            class_2487 ingredientTag = new class_2487();
            ingredientTag.method_10569("i", ingredient.getKey().intValue());
            ingredientTag.method_10566(PATTERN_MAP_VALUE, (class_2520)TaskSnapshotPersistence.encodeIngredientResources(ingredient));
            ingredientMap.add((Object)ingredientTag);
        }
        return ingredientMap;
    }

    private static class_2499 encodeIngredientResources(Map.Entry<Integer, Map<ResourceKey, Long>> ingredient) {
        class_2499 ingredientResources = new class_2499();
        for (Map.Entry<ResourceKey, Long> resourceAndAmount : ingredient.getValue().entrySet()) {
            class_2487 tag = TaskSnapshotPersistence.encodeResource(resourceAndAmount.getKey());
            tag.method_10544(AMOUNT, resourceAndAmount.getValue().longValue());
            ingredientResources.add((Object)tag);
        }
        return ingredientResources;
    }

    private static class_2487 encodeResource(ResourceKey resource) {
        return (class_2487)ResourceCodecs.CODEC.encode((Object)((PlatformResourceKey)resource), (DynamicOps)class_2509.field_11560, (Object)new class_2487()).getOrThrow();
    }

    private static class_2487 encodeIngredient(Ingredient ingredient) {
        class_2487 ingredientTag = new class_2487();
        ingredientTag.method_10544(AMOUNT, ingredient.amount());
        class_2499 inputsTag = new class_2499();
        for (ResourceKey input : ingredient.inputs()) {
            inputsTag.add((Object)TaskSnapshotPersistence.encodeResource(input));
        }
        ingredientTag.method_10566(INPUTS, (class_2520)inputsTag);
        return ingredientTag;
    }

    static TaskSnapshot decodeSnapshot(class_2487 tag) {
        UUID id = tag.method_25926(ID);
        ResourceKey resource = TaskSnapshotPersistence.decodeResource(tag.method_10562(RESOURCE));
        long amount = tag.method_10537(AMOUNT);
        Actor actor = tag.method_10573(ACTOR, 8) ? new PlayerActor(tag.method_10558(ACTOR)) : Actor.EMPTY;
        boolean notifyActor = tag.method_10577(NOTIFY_ACTOR);
        long startTime = tag.method_10537(START_TIME);
        ResourceList initialRequirements = TaskSnapshotPersistence.decodeResourceList(tag.method_10554(INITIAL_REQUIREMENTS, 10));
        ResourceList internalStorage = TaskSnapshotPersistence.decodeResourceList(tag.method_10554(INTERNAL_STORAGE, 10));
        boolean cancelled = tag.method_10577(CANCELLED);
        TaskState state = TaskState.valueOf(tag.method_10558(TASK_STATE));
        ArrayList<TaskSnapshot.PatternSnapshot> completedPatterns = new ArrayList<TaskSnapshot.PatternSnapshot>();
        for (class_2520 completedTag : tag.method_10554(COMPLETED_PATTERNS, 10)) {
            completedPatterns.add(TaskSnapshotPersistence.decodePatternSnapshot((class_2487)completedTag));
        }
        Map<Pattern, TaskSnapshot.PatternSnapshot> patterns = TaskSnapshotPersistence.decodePatternMap(tag.method_10554(PATTERNS, 10));
        return new TaskSnapshot(new TaskId(id), resource, amount, actor, notifyActor, startTime, patterns, completedPatterns, initialRequirements, internalStorage, state, cancelled);
    }

    private static ResourceList decodeResourceList(class_2499 listTag) {
        MutableResourceListImpl resourceList = MutableResourceListImpl.create();
        for (class_2520 tag : listTag) {
            class_2487 entryTag = (class_2487)tag;
            ResourceKey resource = TaskSnapshotPersistence.decodeResource(entryTag);
            long amount = entryTag.method_10537(AMOUNT);
            resourceList.add(resource, amount);
        }
        return resourceList;
    }

    private static ResourceKey decodeResource(class_2487 resourceTag) {
        return (ResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)resourceTag).result().orElseThrow();
    }

    private static TaskSnapshot.PatternSnapshot decodePatternSnapshot(class_2487 tag) {
        boolean root = tag.method_10577(ROOT);
        Pattern pattern = TaskSnapshotPersistence.decodePattern(tag.method_10562(PATTERN));
        Map<Integer, Map<ResourceKey, Long>> ingredients = TaskSnapshotPersistence.decodeIngredientMap(tag.method_10554(INGREDIENTS, 10));
        if (tag.method_10577(INTERNAL)) {
            TaskSnapshot.InternalPatternSnapshot internalPattern = TaskSnapshotPersistence.decodeInternalPattern(tag.method_10562(INTERNAL_PATTERN));
            return new TaskSnapshot.PatternSnapshot(root, pattern, ingredients, internalPattern, null);
        }
        TaskSnapshot.ExternalPatternSnapshot externalPattern = TaskSnapshotPersistence.decodeExternalPattern(tag.method_10562(EXTERNAL_PATTERN));
        return new TaskSnapshot.PatternSnapshot(root, pattern, ingredients, null, externalPattern);
    }

    private static Pattern decodePattern(class_2487 tag) {
        UUID id = tag.method_25926(ID);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (Object ingredientTag : tag.method_10554(INGREDIENTS, 10)) {
            ingredients.add(TaskSnapshotPersistence.decodeIngredient((class_2487)ingredientTag));
        }
        ArrayList<ResourceAmount> outputs = new ArrayList<ResourceAmount>();
        for (Object outputTag : tag.method_10554(OUTPUTS, 10)) {
            outputs.add((ResourceAmount)ResourceCodecs.AMOUNT_CODEC.parse((DynamicOps)class_2509.field_11560, outputTag).result().orElseThrow());
        }
        ArrayList<ResourceAmount> byproducts = new ArrayList<ResourceAmount>();
        for (class_2520 byproductTag : tag.method_10554(BYPRODUCTS, 10)) {
            byproducts.add((ResourceAmount)ResourceCodecs.AMOUNT_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)byproductTag).result().orElseThrow());
        }
        PatternType type = PatternType.valueOf(tag.method_10558(PATTERN_TYPE));
        return new Pattern(id, new PatternLayout(ingredients, outputs, byproducts, type));
    }

    private static Ingredient decodeIngredient(class_2487 tag) {
        long amount = tag.method_10537(AMOUNT);
        ArrayList<ResourceKey> inputs = new ArrayList<ResourceKey>();
        for (class_2520 inputTag : tag.method_10554(INPUTS, 10)) {
            inputs.add(TaskSnapshotPersistence.decodeResource((class_2487)inputTag));
        }
        return new Ingredient(amount, inputs);
    }

    private static TaskSnapshot.InternalPatternSnapshot decodeInternalPattern(class_2487 tag) {
        long originalIterationsRemaining = tag.method_10537(ORIGINAL_ITERATIONS_REMAINING);
        long iterationsRemaining = tag.method_10537(ITERATIONS_REMAINING);
        return new TaskSnapshot.InternalPatternSnapshot(originalIterationsRemaining, iterationsRemaining);
    }

    private static TaskSnapshot.ExternalPatternSnapshot decodeExternalPattern(class_2487 tag) {
        ResourceList expectedOutputs = TaskSnapshotPersistence.decodeResourceList(tag.method_10554(EXPECTED_OUTPUTS, 10));
        ResourceList simulatedIterationInputs = TaskSnapshotPersistence.decodeResourceList(tag.method_10554(SIMULATED_ITERATION_INPUTS, 10));
        long originalIterationsToSendToSink = tag.method_10537(ORIGINAL_ITERATIONS_TO_SEND_TO_SINK);
        long iterationsToSendToSink = tag.method_10537(ITERATIONS_TO_SEND_TO_SINK);
        long iterationsReceived = tag.method_10537(ITERATIONS_RECEIVED);
        boolean interceptedAnythingSinceLastStep = tag.method_10577(INTERCEPTED_ANYTHING_SINCE_LAST_STEP);
        ExternalPatternSink.Result lastSinkResult = tag.method_10573(LAST_SINK_RESULT, 8) ? ExternalPatternSink.Result.valueOf(tag.method_10558(LAST_SINK_RESULT)) : null;
        InWorldExternalPatternSinkKey lastSinkResultKey = tag.method_10573(LAST_SINK_RESULT_KEY_NAME, 8) ? TaskSnapshotPersistence.decodeSinkResultKey(tag) : null;
        return new TaskSnapshot.ExternalPatternSnapshot(expectedOutputs, simulatedIterationInputs, originalIterationsToSendToSink, iterationsToSendToSink, iterationsReceived, interceptedAnythingSinceLastStep, lastSinkResult, lastSinkResultKey);
    }

    private static InWorldExternalPatternSinkKey decodeSinkResultKey(class_2487 tag) {
        return new InWorldExternalPatternSinkKey(tag.method_10558(LAST_SINK_RESULT_KEY_NAME), (class_1799)class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562(LAST_SINK_RESULT_KEY_STACK)).result().orElseThrow());
    }

    private static Map<Pattern, TaskSnapshot.PatternSnapshot> decodePatternMap(class_2499 patternMapTag) {
        LinkedHashMap<Pattern, TaskSnapshot.PatternSnapshot> patternMap = new LinkedHashMap<Pattern, TaskSnapshot.PatternSnapshot>();
        for (class_2520 tag : patternMapTag) {
            class_2487 entry = (class_2487)tag;
            Pattern key = TaskSnapshotPersistence.decodePattern(entry.method_10562(PATTERN_MAP_KEY));
            TaskSnapshot.PatternSnapshot value = TaskSnapshotPersistence.decodePatternSnapshot(entry.method_10562(PATTERN_MAP_VALUE));
            patternMap.put(key, value);
        }
        return patternMap;
    }

    private static Map<Integer, Map<ResourceKey, Long>> decodeIngredientMap(class_2499 ingredientMapTag) {
        LinkedHashMap<Integer, Map<ResourceKey, Long>> ingredients = new LinkedHashMap<Integer, Map<ResourceKey, Long>>();
        for (class_2520 tag : ingredientMapTag) {
            class_2487 entry = (class_2487)tag;
            int index = entry.method_10550("i");
            Map<ResourceKey, Long> resources = TaskSnapshotPersistence.decodeIngredientResources(entry.method_10554(PATTERN_MAP_VALUE, 10));
            ingredients.put(index, resources);
        }
        return ingredients;
    }

    private static Map<ResourceKey, Long> decodeIngredientResources(class_2499 ingredientResources) {
        LinkedHashMap<ResourceKey, Long> resources = new LinkedHashMap<ResourceKey, Long>();
        for (class_2520 rawTag : ingredientResources) {
            class_2487 tag = (class_2487)rawTag;
            ResourceKey resource = TaskSnapshotPersistence.decodeResource(tag);
            long amount = tag.method_10537(AMOUNT);
            resources.put(resource, amount);
        }
        return resources;
    }
}

