/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.Autocrafter;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerData;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerWatcher;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class AutocrafterManagerBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<AutocrafterManagerData> {
    private final Set<AutocrafterManagerWatcher> watchers = new HashSet<AutocrafterManagerWatcher>();

    public AutocrafterManagerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getAutocrafterManager(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getAutocrafterManager().getEnergyUsage()));
    }

    void addWatcher(AutocrafterManagerWatcher watcher) {
        this.watchers.add(watcher);
    }

    void removeWatcher(AutocrafterManagerWatcher watcher) {
        this.watchers.remove(watcher);
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.watchers.forEach(watcher -> watcher.activeChanged(newActive));
    }

    public class_2561 method_5477() {
        return ContentNames.AUTOCRAFTER_MANAGER;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    public AutocrafterManagerData getMenuData() {
        return new AutocrafterManagerData(this.getGroups().stream().map(AutocrafterManagerData.Group::of).toList(), ((SimpleNetworkNode)this.mainNetworkNode).isActive());
    }

    @Override
    public class_9142<class_9129, AutocrafterManagerData> getMenuCodec() {
        return AutocrafterManagerData.STREAM_CODEC;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new AutocrafterManagerContainerMenu(syncId, inventory, this, this.getGroups());
    }

    private Stream<Autocrafter> getAutocrafters() {
        Network mainNetwork = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (mainNetwork == null) {
            return Stream.empty();
        }
        return mainNetwork.getComponent(GraphNetworkComponent.class).getContainers(Autocrafter.class).stream().sorted(Comparator.comparing(Autocrafter::getLocalPosition));
    }

    private List<Group> getGroups() {
        return this.getAutocrafters().collect(Collectors.groupingBy(a -> a.getAutocrafterName().getString())).entrySet().stream().map(entry -> new Group((String)entry.getKey(), ((List)entry.getValue()).stream().sorted(Comparator.comparing(Autocrafter::getLocalPosition)).map(SubGroup::of).toList())).sorted(Comparator.comparing(group -> group.name)).toList();
    }

    record Group(String name, List<SubGroup> subGroups) {
    }

    record SubGroup(class_1263 container, boolean visibleToTheAutocrafterManager, boolean full) {
        private static SubGroup of(Autocrafter autocrafter) {
            class_1263 container = autocrafter.getPatternContainer();
            boolean full = SubGroup.isFull(container);
            return new SubGroup(container, autocrafter.isVisibleToTheAutocrafterManager(), full);
        }

        private static boolean isFull(class_1263 container) {
            for (int i = 0; i < container.method_5439(); ++i) {
                if (!container.method_5438(i).method_7960()) continue;
                return false;
            }
            return true;
        }
    }
}

