/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSearchMode;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.SearchModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.ViewTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.widget.AutoSelectedSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;

public class AutocrafterManagerScreen
extends AbstractStretchingScreen<AutocrafterManagerContainerMenu>
implements PatternOutputRenderingScreen {
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafter_manager.png");
    private static final List<String> SEARCH_FIELD_HISTORY = new ArrayList<String>();
    private static final class_2960 AUTOCRAFTER_NAME = IdentifierUtil.createIdentifier("autocrafter_manager/autocrafter_name");
    private static final int COLUMNS = 9;
    private static final int INACTIVE_COLOR = -10790053;
    private static final class_5250 HELP_ALL = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.all.help");
    private static final class_5250 HELP_PATTERN_INPUTS = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.pattern_inputs.help");
    private static final class_5250 HELP_PATTERN_OUTPUTS = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.pattern_outputs.help");
    private static final class_5250 HELP_AUTOCRAFTER_NAMES = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.autocrafter_names.help");
    @Nullable
    private SearchFieldWidget searchField;

    public AutocrafterManagerScreen(AutocrafterManagerContainerMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, new TextMarquee(title, 70));
        this.field_25270 = 75;
        this.field_2792 = 193;
        this.field_2779 = 176;
    }

    @Override
    protected void init(int rows) {
        super.init(rows);
        ((AutocrafterManagerContainerMenu)this.method_17577()).setListener(() -> {
            this.resize();
            this.updateScrollbar();
            this.scrollbarChanged(rows);
        });
        if (this.searchField == null) {
            this.searchField = new SearchFieldWidget(this.field_22793, this.field_2776 + 94 + 1, this.field_2800 + 6 + 1, 67, new History(SEARCH_FIELD_HISTORY));
        } else {
            this.searchField.method_46421(this.field_2776 + 94 + 1);
            this.searchField.method_46419(this.field_2800 + 6 + 1);
        }
        this.updateScrollbar();
        this.method_25429((class_364)this.searchField);
        this.searchField.method_1863(value -> ((AutocrafterManagerContainerMenu)this.method_17577()).setQuery((String)value));
        this.method_37063((class_364)new SearchIconWidget(this.field_2776 + 79, this.field_2800 + 5, () -> this.getSearchModeHelp().method_27661().method_27692(class_124.field_1080), this.searchField));
        this.addSideButton(new RedstoneModeSideButtonWidget(((AutocrafterManagerContainerMenu)this.method_17577()).getProperty(PropertyTypes.REDSTONE_MODE)));
        this.addSideButton(new ViewTypeSideButtonWidget((AutocrafterManagerContainerMenu)this.method_17577()));
        this.addSideButton(new SearchModeSideButtonWidget((AutocrafterManagerContainerMenu)this.method_17577(), this::getSearchModeHelp));
        this.addSideButton(new AutoSelectedSideButtonWidget(this.searchField));
    }

    private class_2561 getSearchModeHelp() {
        return switch (((AutocrafterManagerContainerMenu)this.field_2797).getSearchMode()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerSearchMode.ALL -> HELP_ALL;
            case AutocrafterManagerSearchMode.PATTERN_INPUTS -> HELP_PATTERN_INPUTS;
            case AutocrafterManagerSearchMode.PATTERN_OUTPUTS -> HELP_PATTERN_OUTPUTS;
            case AutocrafterManagerSearchMode.AUTOCRAFTER_NAMES -> HELP_AUTOCRAFTER_NAMES;
        };
    }

    private void updateScrollbar() {
        int totalRows = ((AutocrafterManagerContainerMenu)this.field_2797).getGroups().stream().map(group -> group.isVisible() ? group.getVisibleRows() + 1 : 0).reduce(0, Integer::sum);
        this.updateScrollbar(totalRows);
    }

    @Override
    protected void scrollbarChanged(int rows) {
        super.scrollbarChanged(rows);
        int scrollbarOffset = this.getScrollbarOffset();
        for (int i = 0; i < ((AutocrafterManagerContainerMenu)this.field_2797).getAutocrafterSlots().size(); ++i) {
            AutocrafterManagerSlot slot = ((AutocrafterManagerContainerMenu)this.field_2797).getAutocrafterSlots().get(i);
            Platform.INSTANCE.setSlotY(slot, slot.getOriginalY() - scrollbarOffset);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.searchField.method_25394(graphics, 0, 0, 0.0f);
        }
    }

    public boolean method_25400(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.method_25400(unknown1, unknown2) || super.method_25400(unknown1, unknown2);
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.method_25404(key, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    @Override
    protected void renderRows(class_332 graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        if (!((AutocrafterManagerContainerMenu)this.field_2797).isActive()) {
            graphics.method_51739(class_1921.method_51785(), x + 7 + 1, y + 19 + 1, x + 7 + 162 - 1, y + 19 + 1 + 18 * rows - 2, -10790053);
            return;
        }
        this.renderGroups(graphics, x, y, topHeight, rows);
        this.renderSlotContents(graphics, mouseX, mouseY, y, topHeight, rows);
    }

    private void renderGroups(class_332 graphics, int x, int y, int topHeight, int rows) {
        int rowX = x + 7;
        int rowY = y + topHeight - this.getScrollbarOffset();
        for (AutocrafterManagerContainerMenu.ViewGroup group : ((AutocrafterManagerContainerMenu)this.field_2797).getGroups()) {
            if (!group.isVisible()) continue;
            if (!AutocrafterManagerScreen.isOutOfFrame(y, topHeight, rows, rowY)) {
                graphics.method_52706(AUTOCRAFTER_NAME, rowX, rowY, 162, 18);
                graphics.method_51433(this.field_22793, group.getName(), rowX + 4, rowY + 6, 0x404040, false);
            }
            AutocrafterManagerScreen.renderGroup(graphics, y, topHeight, rows, group, rowX, rowY);
            rowY += (group.getVisibleRows() + 1) * 18;
        }
    }

    private static void renderGroup(class_332 graphics, int y, int topHeight, int rows, AutocrafterManagerContainerMenu.ViewGroup group, int rowX, int rowY) {
        int j = 0;
        for (AutocrafterManagerContainerMenu.SubViewGroup subGroup : group.getSubViewGroups()) {
            for (int i = 0; i < subGroup.getVisibleSlots(); ++i) {
                int slotX = rowX + j % 9 * 18;
                int slotY = rowY + 18 + j / 9 * 18;
                if (!AutocrafterManagerScreen.isOutOfFrame(y, topHeight, rows, slotY)) {
                    graphics.method_52706(Sprites.SLOT, slotX, slotY, 18, 18);
                }
                ++j;
            }
        }
    }

    private void renderSlotContents(class_332 graphics, int mouseX, int mouseY, int y, int topHeight, int rows) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        for (class_1735 class_17352 : ((AutocrafterManagerContainerMenu)this.field_2797).getAutocrafterSlots()) {
            boolean hovering;
            if (AutocrafterManagerScreen.isOutOfFrame(y, topHeight, rows, this.field_2800 + class_17352.field_7872)) continue;
            super.method_2385(graphics, class_17352);
            boolean bl = hovering = mouseX >= class_17352.field_7873 + this.field_2776 && mouseX < class_17352.field_7873 + this.field_2776 + 16 && mouseY >= class_17352.field_7872 + this.field_2800 && mouseY < class_17352.field_7872 + this.field_2800 + 16;
            if (!class_17352.method_7682() || !hovering) continue;
            AutocrafterManagerScreen.method_33285((class_332)graphics, (int)class_17352.field_7873, (int)class_17352.field_7872, (int)0);
        }
        graphics.method_51448().method_22909();
    }

    protected void method_2385(class_332 guiGraphics, class_1735 slot) {
        if (slot instanceof AutocrafterManagerSlot) {
            return;
        }
        super.method_2385(guiGraphics, slot);
    }

    private static boolean isOutOfFrame(int y, int topHeight, int rows, int rowY) {
        return rowY < y + topHeight - 18 || rowY > y + topHeight + 18 * rows;
    }

    @Override
    protected void renderStretchingBackground(class_332 graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.method_25302(this.getTexture(), x, y + 18 * row, 0, textureY, this.field_2792, 18);
        }
    }

    @Override
    protected int getBottomHeight() {
        return 99;
    }

    @Override
    protected int getBottomV() {
        return 73;
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    public boolean canDisplayOutput(class_1799 stack) {
        return ((AutocrafterManagerContainerMenu)this.method_17577()).containsPattern(stack);
    }
}

