/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitor;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorData;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorListener;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorWatcher;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingTaskButton;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class AbstractAutocraftingMonitorContainerMenu
extends AbstractBaseContainerMenu
implements TaskStatusListener,
AutocraftingMonitorWatcher,
AutocraftingTaskButton.StateProvider {
    private final Map<TaskId, TaskStatus> statusByTaskId;
    private final List<TaskStatus.TaskInfo> tasks;
    private final List<TaskStatus.TaskInfo> tasksView;
    @Nullable
    private final AutocraftingMonitor autocraftingMonitor;
    private final class_1657 player;
    @Nullable
    private AutocraftingMonitorListener listener;
    @Nullable
    private TaskId currentTaskId;
    private boolean active;

    protected AbstractAutocraftingMonitorContainerMenu(class_3917<?> menuType, int syncId, class_1661 playerInventory, AutocraftingMonitorData data) {
        super(menuType, syncId);
        this.statusByTaskId = data.statuses().stream().collect(Collectors.toMap(s -> s.info().id(), s -> s));
        this.tasks = data.statuses().stream().map(TaskStatus::info).collect(Collectors.toList());
        this.tasksView = Collections.unmodifiableList(this.tasks);
        this.currentTaskId = data.statuses().isEmpty() ? null : data.statuses().getFirst().info().id();
        this.autocraftingMonitor = null;
        this.active = data.active();
        this.player = playerInventory.field_7546;
    }

    AbstractAutocraftingMonitorContainerMenu(class_3917<?> menuType, int syncId, class_1657 player, AutocraftingMonitor autocraftingMonitor) {
        super(menuType, syncId);
        this.statusByTaskId = Collections.emptyMap();
        this.tasks = Collections.emptyList();
        this.tasksView = Collections.emptyList();
        this.currentTaskId = null;
        this.autocraftingMonitor = autocraftingMonitor;
        this.player = player;
        this.autocraftingMonitor.addListener(this);
        this.autocraftingMonitor.addWatcher(this);
    }

    public void method_7595(class_1657 removedPlayer) {
        super.method_7595(removedPlayer);
        if (this.autocraftingMonitor != null) {
            this.autocraftingMonitor.removeListener(this);
            this.autocraftingMonitor.removeWatcher(this);
        }
    }

    void setListener(@Nullable AutocraftingMonitorListener listener) {
        this.listener = listener;
    }

    List<TaskStatus.Item> getCurrentItems() {
        TaskStatus status = this.statusByTaskId.get(this.currentTaskId);
        if (status == null) {
            return Collections.emptyList();
        }
        return status.items();
    }

    List<TaskStatus.TaskInfo> getTasksView() {
        return this.tasksView;
    }

    @Override
    public double getPercentageCompleted(TaskId taskId) {
        TaskStatus status = this.statusByTaskId.get(taskId);
        return status == null ? 0.0 : status.percentageCompleted();
    }

    @Override
    @Nullable
    public TaskState getState(TaskId taskId) {
        TaskStatus status = this.statusByTaskId.get(taskId);
        return status == null ? null : status.state();
    }

    void setCurrentTaskId(@Nullable TaskId taskId) {
        this.currentTaskId = taskId;
        this.loadCurrentTask();
    }

    void loadCurrentTask() {
        if (this.listener != null) {
            this.listener.currentTaskChanged(this.currentTaskId == null ? null : this.statusByTaskId.get(this.currentTaskId));
        }
    }

    @Override
    public void taskStatusChanged(TaskStatus status) {
        class_1657 class_16572;
        if (this.autocraftingMonitor != null && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            S2CPackets.sendAutocraftingMonitorTaskStatusChanged(serverPlayer, status);
            return;
        }
        this.statusByTaskId.put(status.info().id(), status);
    }

    @Override
    public void taskRemoved(TaskId id) {
        class_1657 class_16572;
        if (this.autocraftingMonitor != null && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            S2CPackets.sendAutocraftingMonitorTaskRemoved(serverPlayer, id);
            return;
        }
        this.statusByTaskId.remove(id);
        this.tasks.removeIf(task -> task.id().equals(id));
        if (this.listener != null) {
            this.listener.taskRemoved(id);
        }
        if (id.equals(this.currentTaskId)) {
            this.currentTaskId = this.tasks.isEmpty() ? null : this.tasks.getFirst().id();
            this.loadCurrentTask();
        }
    }

    @Override
    public void taskAdded(TaskStatus status) {
        class_1657 class_16572;
        if (this.autocraftingMonitor != null && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            S2CPackets.sendAutocraftingMonitorTaskAdded(serverPlayer, status);
            return;
        }
        this.statusByTaskId.put(status.info().id(), status);
        this.tasks.add(status.info());
        if (this.listener != null) {
            this.listener.taskAdded(status);
        }
        if (this.currentTaskId == null) {
            this.currentTaskId = status.info().id();
            this.loadCurrentTask();
        }
    }

    public void cancelTask(TaskId taskId) {
        if (this.autocraftingMonitor != null) {
            this.autocraftingMonitor.cancel(taskId);
        }
    }

    void cancelCurrentTask() {
        if (this.currentTaskId != null) {
            C2SPackets.sendAutocraftingMonitorCancel(this.currentTaskId);
        }
    }

    public void cancelAllTasks() {
        if (this.autocraftingMonitor != null) {
            this.autocraftingMonitor.cancelAll();
        } else {
            C2SPackets.sendAutocraftingMonitorCancelAll();
        }
    }

    @Override
    public void activeChanged(boolean newActive) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            S2CPackets.sendAutocraftingMonitorActive(serverPlayer, newActive);
        } else {
            this.active = newActive;
            this.loadCurrentTask();
        }
    }

    boolean isActive() {
        return this.active;
    }
}

