/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitor;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorData;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorWatcher;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class AutocraftingMonitorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<AutocraftingMonitorData>,
AutocraftingMonitor {
    private final Set<AutocraftingMonitorWatcher> watchers = new HashSet<AutocraftingMonitorWatcher>();

    public AutocraftingMonitorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getAutocraftingMonitor(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getAutocraftingMonitor().getEnergyUsage()));
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.watchers.forEach(watcher -> watcher.activeChanged(newActive));
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.AUTOCRAFTING_MONITOR);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    public AutocraftingMonitorData getMenuData() {
        return new AutocraftingMonitorData(this.getStatuses(), this.isAutocraftingMonitorActive());
    }

    @Override
    public class_9142<class_9129, AutocraftingMonitorData> getMenuCodec() {
        return AutocraftingMonitorData.STREAM_CODEC;
    }

    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new AutocraftingMonitorContainerMenu(syncId, player, this);
    }

    private Optional<AutocraftingNetworkComponent> getAutocrafting() {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return Optional.empty();
        }
        return Optional.of(network.getComponent(AutocraftingNetworkComponent.class));
    }

    @Override
    public List<TaskStatus> getStatuses() {
        return this.getAutocrafting().map(TaskStatusProvider::getStatuses).orElse(Collections.emptyList());
    }

    @Override
    public void addListener(TaskStatusListener listener) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.addListener(listener));
    }

    @Override
    public void removeListener(TaskStatusListener listener) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.removeListener(listener));
    }

    @Override
    public void cancel(TaskId taskId) {
        this.getAutocrafting().ifPresent(autocrafting -> autocrafting.cancel(taskId));
    }

    @Override
    public void cancelAll() {
        this.getAutocrafting().ifPresent(TaskStatusProvider::cancelAll);
    }

    @Override
    public void addWatcher(AutocraftingMonitorWatcher watcher) {
        this.watchers.add(watcher);
    }

    @Override
    public void removeWatcher(AutocraftingMonitorWatcher watcher) {
        this.watchers.remove(watcher);
    }

    @Override
    public boolean isAutocraftingMonitorActive() {
        return ((SimpleNetworkNode)this.mainNetworkNode).isActive();
    }
}

