/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

class AutocraftingMonitorItemTooltip
implements class_5684 {
    private static final int SPACING = 2;
    private static final class_5250 MACHINE_DOES_NOT_ACCEPT_RESOURCE = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.machine_does_not_accept_resource").method_27692(class_124.field_1061);
    private static final class_5250 NO_MACHINE_FOUND = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.no_machine_found").method_27692(class_124.field_1061);
    private static final class_5250 AUTOCRAFTER_IS_LOCKED = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.autocrafter_is_locked").method_27692(class_124.field_1061);
    private final TaskStatus.Item item;
    private final ResourceRendering rendering;

    AutocraftingMonitorItemTooltip(TaskStatus.Item item) {
        this.item = item;
        this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
    }

    public void method_32666(class_327 font, int x, int y, class_332 graphics) {
        ExternalPatternSinkKey externalPatternSinkKey;
        int yy = y;
        graphics.method_27535(font, this.rendering.getDisplayName(this.item.resource()), x, yy, 0xFFFFFF);
        yy += 11;
        if (this.item.type() != TaskStatus.ItemType.NORMAL) {
            graphics.method_27535(font, this.getErrorTooltip(this.item.type()), x, yy, 0xAAAAAA);
            yy += 11;
        }
        if ((externalPatternSinkKey = this.item.sinkKey()) instanceof InWorldExternalPatternSinkKey) {
            String name;
            String string;
            InWorldExternalPatternSinkKey inWorldExternalPatternSinkKey = (InWorldExternalPatternSinkKey)externalPatternSinkKey;
            try {
                name = string = inWorldExternalPatternSinkKey.name();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            String stack = string = inWorldExternalPatternSinkKey.stack();
            graphics.method_51427((class_1799)stack, x, yy);
            graphics.method_25303(font, name, x + 18 + 2, yy + 4, 0xAAAAAA);
        }
    }

    public int method_32661() {
        return 11 + (this.item.type() != TaskStatus.ItemType.NORMAL ? 11 : 0) + (this.item.sinkKey() != null ? 18 : 0);
    }

    public int method_32664(class_327 font) {
        int n;
        int resourceWidth = font.method_27525((class_5348)this.rendering.getDisplayName(this.item.resource()));
        int errorWidth = this.item.type() != TaskStatus.ItemType.NORMAL ? font.method_27525((class_5348)this.getErrorTooltip(this.item.type())) : 0;
        ExternalPatternSinkKey externalPatternSinkKey = this.item.sinkKey();
        if (externalPatternSinkKey instanceof InWorldExternalPatternSinkKey) {
            InWorldExternalPatternSinkKey sinkKey = (InWorldExternalPatternSinkKey)externalPatternSinkKey;
            n = 20 + font.method_1727(sinkKey.name());
        } else {
            n = 0;
        }
        int sinkWidth = n;
        return Math.max(resourceWidth, Math.max(errorWidth, sinkWidth));
    }

    private class_2561 getErrorTooltip(TaskStatus.ItemType type) {
        return switch (type) {
            case TaskStatus.ItemType.REJECTED -> MACHINE_DOES_NOT_ACCEPT_RESOURCE;
            case TaskStatus.ItemType.NONE_FOUND -> NO_MACHINE_FOUND;
            case TaskStatus.ItemType.LOCKED -> AUTOCRAFTER_IS_LOCKED;
            default -> class_2561.method_43473();
        };
    }
}

