/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AbstractAutocraftingMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorItemTooltip;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorListener;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingTaskButton;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;

public class AutocraftingMonitorScreen
extends AbstractBaseScreen<AbstractAutocraftingMonitorContainerMenu>
implements AutocraftingMonitorListener {
    static final int TASK_BUTTON_HEIGHT = 24;
    static final int TASK_BUTTON_WIDTH = 64;
    private static final int ROWS_VISIBLE = 6;
    private static final int COLUMNS = 3;
    private static final int ITEMS_AREA_HEIGHT = 179;
    private static final int ITEM_COLOR = -2368549;
    private static final int PROCESSING_COLOR = -2494985;
    private static final int SCHEDULED_COLOR = -1514038;
    private static final int CRAFTING_COLOR = -5383226;
    private static final int ROW_HEIGHT = 30;
    private static final int ROW_WIDTH = 221;
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafting_monitor.png");
    private static final class_2960 ROW = IdentifierUtil.createIdentifier("autocrafting_monitor/row");
    private static final class_2960 TASKS = IdentifierUtil.createIdentifier("autocrafting_monitor/tasks");
    private static final class_5250 CANCEL = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.cancel");
    private static final class_5250 CANCEL_ALL = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.cancel_all");
    private static final int TASKS_WIDTH = 91;
    private static final int TASKS_HEIGHT = 183;
    private static final int TASKS_INNER_WIDTH = 64;
    private static final int TASKS_INNER_HEIGHT = 168;
    private static final int TASKS_VISIBLE = 7;
    @Nullable
    private ScrollbarWidget taskItemsScrollbar;
    @Nullable
    private ScrollbarWidget taskButtonsScrollbar;
    @Nullable
    private class_4185 cancelButton;
    @Nullable
    private class_4185 cancelAllButton;
    private final List<AutocraftingTaskButton> taskButtons = new ArrayList<AutocraftingTaskButton>();

    public AutocraftingMonitorScreen(AbstractAutocraftingMonitorContainerMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.field_2792 = 254;
        this.field_2779 = 231;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.taskItemsScrollbar = new ScrollbarWidget(this.field_2776 + 235, this.field_2800 + 20, ScrollbarWidget.Type.NORMAL, 179);
        this.taskItemsScrollbar.setEnabled(false);
        this.initTaskButtons();
        ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).setListener(this);
        this.getExclusionZones().add(new class_768(this.field_2776 - 91 + 4, this.field_2800, 91, 183));
        int cancelButtonsY = this.field_2800 + 204;
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL, button -> ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).cancelCurrentTask()).method_46433(this.field_2776 + 7, cancelButtonsY).method_46437(this.field_22793.method_27525((class_5348)CANCEL) + 14, 20).method_46431());
        this.cancelButton.field_22763 = false;
        this.cancelAllButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL_ALL, button -> ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).cancelAllTasks()).method_46433(this.cancelButton.method_46426() + this.cancelButton.method_25368() + 4, cancelButtonsY).method_46437(this.field_22793.method_27525((class_5348)CANCEL_ALL) + 14, 20).method_46431());
        this.cancelAllButton.field_22763 = false;
        ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).loadCurrentTask();
        if (((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).hasProperty(PropertyTypes.REDSTONE_MODE)) {
            this.addSideButton(new RedstoneModeSideButtonWidget(((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).getProperty(PropertyTypes.REDSTONE_MODE)));
        }
    }

    @Override
    protected int getSideButtonX() {
        return this.field_2776 + this.field_2792 + 2;
    }

    private void initTaskButtons() {
        this.taskButtons.clear();
        this.taskButtonsScrollbar = new ScrollbarWidget(this.field_2776 - 17 + 4, this.getTaskButtonsInnerY(), ScrollbarWidget.Type.NORMAL, 168);
        this.taskButtonsScrollbar.setListener(value -> {
            int scrollOffset = this.taskButtonsScrollbar.isSmoothScrolling() ? (int)this.taskButtonsScrollbar.getOffset() : (int)this.taskButtonsScrollbar.getOffset() * 24;
            for (int i = 0; i < this.taskButtons.size(); ++i) {
                AutocraftingTaskButton taskButton = this.taskButtons.get(i);
                int y = this.getTaskButtonY(i) - scrollOffset;
                taskButton.method_46419(y);
                taskButton.field_22764 = this.isTaskButtonVisible(y);
            }
        });
        this.updateTaskButtonsScrollbar();
        for (int i = 0; i < ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).getTasksView().size(); ++i) {
            TaskStatus.TaskInfo taskId = ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).getTasksView().get(i);
            int buttonY = this.getTaskButtonY(i);
            AutocraftingTaskButton button = new AutocraftingTaskButton(this.getTaskButtonsInnerX(), buttonY, taskId, ((AbstractAutocraftingMonitorContainerMenu)this.field_2797)::setCurrentTaskId, (AutocraftingTaskButton.StateProvider)this.field_2797);
            button.field_22764 = this.isTaskButtonVisible(buttonY);
            this.taskButtons.add((AutocraftingTaskButton)this.method_25429((class_364)button));
        }
    }

    private boolean isTaskButtonVisible(int y) {
        if (!((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive()) {
            return false;
        }
        int innerY = this.getTaskButtonsInnerY();
        return y >= innerY - 24 && y <= innerY + 168;
    }

    private int getTaskButtonY(int i) {
        return this.getTaskButtonsInnerY() + i * 24;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.taskItemsScrollbar != null) {
            this.taskItemsScrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.taskButtonsScrollbar != null) {
            this.taskButtonsScrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        super.method_2389(graphics, delta, mouseX, mouseY);
        graphics.method_52706(TASKS, this.field_2776 - 91 + 4, this.field_2800, 91, 183);
        List<TaskStatus.Item> items = ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).getCurrentItems();
        if (items.isEmpty() || this.taskItemsScrollbar == null || !((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive()) {
            return;
        }
        int x = this.field_2776 + 8;
        int y = this.field_2800 + 20;
        graphics.method_44379(x, y, x + 221, y + 179);
        int rows = Math.ceilDiv(items.size(), 3);
        for (int i = 0; i < rows; ++i) {
            int scrollOffset = this.taskItemsScrollbar.isSmoothScrolling() ? (int)this.taskItemsScrollbar.getOffset() : (int)this.taskItemsScrollbar.getOffset() * 30;
            int yy = y + i * 30 - scrollOffset;
            this.renderRow(graphics, x, yy, i, items, mouseX, mouseY);
        }
        graphics.method_44380();
        int tasksInnerX = this.getTaskButtonsInnerX();
        int tasksInnerY = this.getTaskButtonsInnerY();
        graphics.method_44379(tasksInnerX, tasksInnerY, tasksInnerX + 64, tasksInnerY + 168);
        for (AutocraftingTaskButton taskButton : this.taskButtons) {
            taskButton.method_25394(graphics, mouseX, mouseY, delta);
        }
        graphics.method_44380();
    }

    private void renderRow(class_332 graphics, int x, int y, int i, List<TaskStatus.Item> items, double mouseX, double mouseY) {
        if (y <= this.field_2800 + 20 - 30 || y > this.field_2800 + 20 + 179) {
            return;
        }
        graphics.method_52706(ROW, x, y, 221, 30);
        for (int column = i * 3; column < Math.min(i * 3 + 3, items.size()); ++column) {
            TaskStatus.Item item = items.get(column);
            int xx = x + column % 3 * 74;
            this.renderItem(graphics, xx, y, item, mouseX, mouseY);
        }
    }

    private static int getItemColor(TaskStatus.Item item, boolean hovering) {
        return hovering ? MathUtil.darkenARGB(AutocraftingMonitorScreen.getItemColor(item), 0.1) : AutocraftingMonitorScreen.getItemColor(item);
    }

    private static int getItemColor(TaskStatus.Item item) {
        if (item.processing() > 0L) {
            return -2494985;
        }
        if (item.scheduled() > 0L) {
            return -1514038;
        }
        if (item.crafting() > 0L) {
            return -5383226;
        }
        return -2368549;
    }

    private void renderItem(class_332 graphics, int x, int y, TaskStatus.Item item, double mouseX, double mouseY) {
        boolean hovering = this.method_2378(x - this.field_2776, y - this.field_2800, 73, 29, mouseX, mouseY);
        int color = AutocraftingMonitorScreen.getItemColor(item, hovering);
        if (color != -2368549) {
            graphics.method_25294(x, y, x + 73, y + 29, color);
        }
        if (item.type() != TaskStatus.ItemType.NORMAL) {
            AutocraftingMonitorScreen.renderItemErrorIcon(graphics, x, y);
        }
        int xx = x + 2;
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
        int yy = y + 7;
        rendering.render(item.resource(), graphics, xx, yy);
        if (this.method_2378(x - this.field_2776, y - this.field_2800, 73, 29, mouseX, mouseY) && this.isHoveringOverItems(mouseX, mouseY)) {
            this.setDeferredTooltip(List.of(new AutocraftingMonitorItemTooltip(item)));
        }
        if (!SmallText.isSmall()) {
            yy -= 2;
        }
        this.renderItemText(graphics, item, rendering, xx += 19, yy);
    }

    private static void renderItemErrorIcon(class_332 graphics, int x, int y) {
        graphics.method_52706(Sprites.ERROR, x + 73 - 12 - 3, y + 29 - 12 - 3, 12, 12);
    }

    private void renderItemText(class_332 graphics, TaskStatus.Item item, ResourceRendering rendering, int x, int y) {
        int yy = y;
        if (item.extracting() > 0L) {
            this.renderItemText(graphics, "extracting", rendering, x, yy, item.extracting());
            yy += 7;
        }
        if (item.stored() > 0L) {
            this.renderItemText(graphics, "stored", rendering, x, yy, item.stored());
            yy += 7;
        }
        if (item.processing() > 0L) {
            this.renderItemText(graphics, "processing", rendering, x, yy, item.processing());
            yy += 7;
        }
        if (item.scheduled() > 0L) {
            this.renderItemText(graphics, "scheduled", rendering, x, yy, item.scheduled());
            yy += 7;
        }
        if (item.crafting() > 0L) {
            this.renderItemText(graphics, "crafting", rendering, x, yy, item.crafting());
        }
    }

    private void renderItemText(class_332 graphics, String type, ResourceRendering rendering, int x, int y, long amount) {
        SmallText.render(graphics, this.field_22793, IdentifierUtil.createTranslation("gui", "autocrafting_monitor." + type, rendering.formatAmount(amount, true)).method_30937(), x, y, 0x404040, false, 0.5f);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        if (this.taskItemsScrollbar != null && this.taskItemsScrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (this.taskButtonsScrollbar != null && this.taskButtonsScrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    public void method_16014(double mx, double my) {
        if (this.taskItemsScrollbar != null) {
            this.taskItemsScrollbar.method_16014(mx, my);
        }
        if (this.taskButtonsScrollbar != null) {
            this.taskButtonsScrollbar.method_16014(mx, my);
        }
        super.method_16014(mx, my);
    }

    public boolean method_25406(double mx, double my, int button) {
        if (this.taskItemsScrollbar != null && this.taskItemsScrollbar.method_25406(mx, my, button)) {
            return true;
        }
        if (this.taskButtonsScrollbar != null && this.taskButtonsScrollbar.method_25406(mx, my, button)) {
            return true;
        }
        return super.method_25406(mx, my, button);
    }

    public boolean method_25401(double x, double y, double z, double delta) {
        boolean didTaskItemsScrollbar = this.taskItemsScrollbar != null && this.isHoveringOverItems(x, y) && this.taskItemsScrollbar.method_25401(x, y, z, delta);
        boolean didTaskButtonsScrollbar = !didTaskItemsScrollbar && this.taskButtonsScrollbar != null && this.isHoveringOverTaskButtons(x, y) && this.taskButtonsScrollbar.method_25401(x, y, z, delta);
        return didTaskItemsScrollbar || didTaskButtonsScrollbar || super.method_25401(x, y, z, delta);
    }

    private boolean isHoveringOverItems(double x, double y) {
        return this.method_2378(8, 20, 221, 179, x, y);
    }

    private boolean isHoveringOverTaskButtons(double x, double y) {
        int tasksInnerX = this.getTaskButtonsInnerX() - 1;
        int tasksInnerY = this.getTaskButtonsInnerY() - 1;
        return this.method_2378(tasksInnerX - this.field_2776, tasksInnerY - this.field_2800, 80, 170, x, y);
    }

    private int getTaskButtonsInnerY() {
        return this.field_2800 + 8;
    }

    private int getTaskButtonsInnerX() {
        return this.field_2776 - 83 + 4;
    }

    @Override
    public void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    public void currentTaskChanged(@Nullable TaskStatus taskStatus) {
        this.updateTaskItemsScrollbar(taskStatus);
        this.updateTaskButtonsScrollbar();
        if (this.cancelButton != null) {
            boolean bl = this.cancelButton.field_22763 = ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive() && taskStatus != null;
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.field_22763 = ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive() && !((AbstractAutocraftingMonitorContainerMenu)this.field_2797).getTasksView().isEmpty();
        }
        for (AutocraftingTaskButton taskButton : this.taskButtons) {
            taskButton.field_22763 = taskStatus == null || !taskButton.getTaskId().equals(taskStatus.info().id());
            taskButton.field_22764 = ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive();
        }
    }

    private void updateTaskButtonsScrollbar() {
        if (this.taskButtonsScrollbar == null) {
            return;
        }
        int totalTaskButtons = ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive() ? ((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).getTasksView().size() - 7 : 0;
        int maxOffset = this.taskButtonsScrollbar.isSmoothScrolling() ? totalTaskButtons * 24 : totalTaskButtons;
        this.taskButtonsScrollbar.setEnabled(maxOffset > 0);
        this.taskButtonsScrollbar.setMaxOffset(maxOffset);
    }

    private void updateTaskItemsScrollbar(@Nullable TaskStatus taskStatus) {
        if (this.taskItemsScrollbar == null) {
            return;
        }
        if (taskStatus == null || !((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).isActive()) {
            this.taskItemsScrollbar.setEnabled(false);
            this.taskItemsScrollbar.setMaxOffset(0.0);
            return;
        }
        int items = taskStatus.items().size();
        int rows = Math.ceilDiv(items, 3) - 6;
        this.taskItemsScrollbar.setMaxOffset(this.taskItemsScrollbar.isSmoothScrolling() ? (double)(rows * 30) : (double)rows);
        this.taskItemsScrollbar.setEnabled(rows > 0);
    }

    @Override
    public void taskAdded(TaskStatus taskStatus) {
        this.updateTaskButtonsScrollbar();
        int buttonY = this.getTaskButtonY(((AbstractAutocraftingMonitorContainerMenu)this.method_17577()).getTasksView().size() - 1);
        AutocraftingTaskButton button = new AutocraftingTaskButton(this.getTaskButtonsInnerX(), buttonY, taskStatus.info(), ((AbstractAutocraftingMonitorContainerMenu)this.field_2797)::setCurrentTaskId, (AutocraftingTaskButton.StateProvider)this.field_2797);
        button.field_22764 = this.isTaskButtonVisible(buttonY);
        this.taskButtons.add((AutocraftingTaskButton)this.method_25429((class_364)button));
    }

    @Override
    public void taskRemoved(TaskId taskId) {
        this.updateTaskButtonsScrollbar();
        this.taskButtons.stream().filter(b -> b.getTaskId().equals(taskId)).findFirst().ifPresent(button -> {
            this.method_37066((class_364)button);
            this.taskButtons.remove(button);
        });
        for (int i = 0; i < this.taskButtons.size(); ++i) {
            AutocraftingTaskButton button2 = this.taskButtons.get(i);
            button2.method_46419(this.getTaskButtonY(i));
            button2.field_22764 = this.isTaskButtonVisible(button2.method_46427());
        }
    }
}

