/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

class AutocraftingTaskButton
extends class_4264 {
    private final TaskStatus.TaskInfo task;
    private final TextMarquee text;
    private final Consumer<TaskId> onPress;
    private final StateProvider stateProvider;

    AutocraftingTaskButton(int x, int y, TaskStatus.TaskInfo task, Consumer<TaskId> onPress, StateProvider stateProvider) {
        super(x, y, 64, 24, (class_2561)class_2561.method_43473());
        this.task = task;
        ResourceKey resource = task.resource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.text = new TextMarquee(rendering.getDisplayName(resource), 36, 0xFFFFFF, true, true);
        this.onPress = onPress;
        this.stateProvider = stateProvider;
    }

    TaskId getTaskId() {
        return this.task.id();
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(graphics, mouseX, mouseY, partialTick);
        this.renderResourceIcon(graphics);
        int yOffset = SmallText.isSmall() ? 5 : 3;
        int textX = this.method_46426() + 3 + 16 + 3;
        int textY = this.method_46427() + yOffset;
        this.text.render(graphics, textX, textY, class_310.method_1551().field_1772, this.field_22762);
        int ySpacing = SmallText.isSmall() ? 7 : 8;
        long percentageCompleted = Math.round(this.stateProvider.getPercentageCompleted(this.task.id()) * 100.0);
        SmallText.render(graphics, class_310.method_1551().field_1772, percentageCompleted + "%", textX, textY + ySpacing, 0xFFFFFF, true, 0.5f);
        this.updateTooltip();
    }

    private void renderResourceIcon(class_332 graphics) {
        ResourceKey resource = this.task.resource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        int resourceX = this.method_46426() + 3;
        int resourceY = this.method_46427() + 4;
        rendering.render(resource, graphics, resourceX, resourceY);
        ResourceSlotRendering.renderAmount(graphics, resourceX, resourceY, this.task.amount(), rendering);
    }

    private void updateTooltip() {
        if (this.field_22762) {
            String runningTime = this.getRunningTimeText();
            class_5250 runningTimeText = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.running_time", runningTime);
            TaskState state = this.stateProvider.getState(this.task.id());
            if (state == null) {
                this.method_47400(class_7919.method_47407((class_2561)runningTimeText));
                return;
            }
            class_5250 stateText = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.state." + state.toString().toLowerCase(Locale.ROOT));
            this.method_47400(class_7919.method_47407((class_2561)stateText.method_27693("\n").method_10852((class_2561)runningTimeText.method_27692(class_124.field_1080))));
        } else {
            this.method_47400(null);
        }
    }

    private String getRunningTimeText() {
        int totalSecs = (int)(System.currentTimeMillis() - this.task.startTime()) / 1000;
        int hours = totalSecs / 3600;
        int minutes = totalSecs % 3600 / 60;
        int seconds = totalSecs % 60;
        String runningTime = hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
        return runningTime;
    }

    public void method_25306() {
        this.onPress.accept(this.task.id());
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    static interface StateProvider {
        public double getPercentageCompleted(TaskId var1);

        @Nullable
        public TaskState getState(TaskId var1);
    }
}

