/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativeSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2960;

class Alternative {
    private static final long EXPAND_COLLAPSE_DELAY = 10L;
    private final class_2960 id;
    private final String translationKey;
    private final List<PlatformResourceKey> resources;
    private final List<AlternativeSlot> mainSlots = new ArrayList<AlternativeSlot>();
    private final List<AlternativeSlot> overflowSlots = new ArrayList<AlternativeSlot>();
    private boolean visible = true;
    private double expandPct;
    private int expandCollapseElapsed;
    @Nullable
    private ExpandCollapse expandCollapse;

    Alternative(class_2960 id, String translationKey, List<PlatformResourceKey> resources) {
        this.id = id;
        this.translationKey = translationKey;
        this.resources = resources;
    }

    List<AlternativeSlot> getMainSlots() {
        return this.mainSlots;
    }

    List<AlternativeSlot> getOverflowSlots() {
        return this.overflowSlots;
    }

    class_2960 getId() {
        return this.id;
    }

    String getTranslationKey() {
        return this.translationKey;
    }

    List<PlatformResourceKey> getResources() {
        return this.resources;
    }

    double getExpandPct() {
        return this.expandPct;
    }

    boolean expandOrCollapse() {
        if (this.expandCollapse != null) {
            this.expandCollapse = this.expandCollapse == ExpandCollapse.EXPAND ? ExpandCollapse.COLLAPSE : ExpandCollapse.EXPAND;
            this.expandCollapseElapsed = (int)(10L - (long)this.expandCollapseElapsed);
            return this.expandCollapse == ExpandCollapse.EXPAND;
        }
        this.expandCollapse = this.expandPct > 0.0 ? ExpandCollapse.COLLAPSE : ExpandCollapse.EXPAND;
        return this.expandCollapse == ExpandCollapse.EXPAND;
    }

    void update() {
        if (this.expandCollapse == null) {
            return;
        }
        ++this.expandCollapseElapsed;
        if (this.expandCollapse == ExpandCollapse.EXPAND) {
            this.expandPct = (double)this.expandCollapseElapsed / 10.0;
            if (this.expandPct >= 1.0) {
                this.stopExpandCollapse();
            }
        } else {
            this.expandPct = 1.0 - (double)this.expandCollapseElapsed / 10.0;
            if (this.expandPct <= 0.0) {
                this.stopExpandCollapse();
            }
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean visible) {
        this.visible = visible;
    }

    private void stopExpandCollapse() {
        this.expandPct = this.expandCollapse == ExpandCollapse.EXPAND ? 1.0 : 0.0;
        this.expandCollapseElapsed = 0;
        this.expandCollapse = null;
    }

    private static enum ExpandCollapse {
        EXPAND,
        COLLAPSE;

    }
}

