/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.Alternative;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativeSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

class AlternativeContainerMenu
extends AbstractResourceContainerMenu {
    private final List<Alternative> alternatives;
    private final ResourceSlot amountSlot;

    AlternativeContainerMenu(ResourceSlot amountSlot) {
        super(null, 0);
        this.amountSlot = amountSlot.forAmountScreen(127, 48);
        List tags = amountSlot.getResource() == null ? Collections.emptyList() : amountSlot.getResource().getTags();
        this.alternatives = tags.stream().map(tag -> new Alternative(tag.key().comp_327(), IdentifierUtil.getTagTranslationKey(tag.key()), tag.resources())).toList();
        this.method_7621(this.amountSlot);
        this.addAlternativeSlots();
    }

    void filter(String query) {
        String normalizedQuery = query.trim().toLowerCase(Locale.ROOT);
        this.alternatives.forEach(alternative -> {
            boolean titleMatch = class_1074.method_4663((String)alternative.getTranslationKey()) && class_1074.method_4662((String)alternative.getTranslationKey(), (Object[])new Object[0]).trim().toLowerCase(Locale.ROOT).contains(normalizedQuery);
            boolean idMatch = alternative.getId().toString().trim().toLowerCase(Locale.ROOT).contains(normalizedQuery);
            alternative.setVisible(titleMatch || idMatch);
        });
    }

    private void addAlternativeSlots() {
        int x = 8;
        for (int i = 0; i < this.alternatives.size(); ++i) {
            int y = 122 + i * 36;
            Alternative alternative = this.alternatives.get(i);
            ResourceContainer resources = ResourceContainerImpl.createForFilter(alternative.getResources().size());
            for (int j = 0; j < resources.size(); ++j) {
                resources.set(j, new ResourceAmount(alternative.getResources().get(j), 1L));
                int row = j / 9;
                int col = j % 9;
                int slotX = 10 + col * 18;
                int slotY = y + 18 + row * 18 + 1;
                AlternativeSlot resourceSlot = new AlternativeSlot(resources, j, slotX, slotY);
                if (j < 9) {
                    alternative.getMainSlots().add(resourceSlot);
                } else {
                    alternative.getOverflowSlots().add(resourceSlot);
                }
                this.method_7621(resourceSlot);
            }
        }
    }

    ResourceSlot getAmountSlot() {
        return this.amountSlot;
    }

    List<Alternative> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    void sendAllowedAlternatives(Set<Alternative> allowedAlternatives) {
        C2SPackets.sendPatternGridAllowedAlternativesChange(this.amountSlot.method_34266(), allowedAlternatives.stream().map(Alternative::getId).collect(Collectors.toSet()));
    }
}

