/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.Alternative;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativeContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativeSlot;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.joml.Vector3f;

public class AlternativesScreen
extends AbstractAmountScreen<AlternativeContainerMenu, Double> {
    static final int ALTERNATIVE_ROW_HEIGHT = 18;
    static final int ALTERNATIVE_HEIGHT = 36;
    static final int RESOURCES_PER_ROW = 9;
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/alternatives.png");
    private static final class_5250 TITLE = IdentifierUtil.createTranslation("gui", "configure_amount");
    private static final class_5250 ALTERNATIVES = IdentifierUtil.createTranslation("gui", "pattern_grid.alternatives");
    private static final class_5250 EXPAND = IdentifierUtil.createTranslation("gui", "pattern_grid.alternatives.expand");
    private static final class_2561 SEARCH_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.alternatives.search_help").method_27692(class_124.field_1080);
    private static final class_8666 EXPAND_SPRITES = new class_8666(IdentifierUtil.createIdentifier("widget/expand"), IdentifierUtil.createIdentifier("widget/expand_disabled"), IdentifierUtil.createIdentifier("widget/expand_focused"), IdentifierUtil.createIdentifier("widget/expand_disabled"));
    private static final class_8666 COLLAPSE_SPRITES = new class_8666(IdentifierUtil.createIdentifier("widget/collapse"), IdentifierUtil.createIdentifier("widget/collapse_focused"));
    private static final int ALTERNATIVES_DISPLAYED = 2;
    private static final int ROWS_PER_ALTERNATIVE = 2;
    private static final int INSET_WIDTH = 164;
    private static final int INSET_HEIGHT = 72;
    private final ResourceSlot slot;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private class_342 searchField;
    private final List<CheckboxWidget> alternativeCheckboxes = new ArrayList<CheckboxWidget>();
    private final List<class_4185> expandButtons = new ArrayList<class_4185>();
    private final Set<class_2960> initialAllowedAlternativeIds;

    AlternativesScreen(class_437 parent, class_1661 playerInventory, Set<class_2960> allowedAlternativeIds, ResourceSlot slot) {
        super(new AlternativeContainerMenu(slot), parent, playerInventory, (class_2561)TITLE, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(slot.getDisplayAmount()).withIncrementsTop(1, 10, 64).withIncrementsTopStartPosition(new Vector3f(49.0f, 20.0f, 0.0f)).withIncrementsBottom(-1, -10, -64).withIncrementsBottomStartPosition(new Vector3f(49.0f, 71.0f, 0.0f)).withAmountFieldPosition(new Vector3f(47.0f, 51.0f, 0.0f)).withActionButtonsStartPosition(new Vector3f(7.0f, 199.0f, 0.0f)).withHorizontalActionButtons(true).withMinAmount(() -> slot.getResource() != null ? slot.getResource().getResourceType().getDisplayAmount(1L) : 1.0).withMaxAmount(slot.getMaxAmountWhenModifying()).withResetAmount(1.0).build(), DoubleAmountOperations.INSTANCE);
        this.slot = slot;
        this.field_2792 = 193;
        this.field_2779 = 226;
        this.initialAllowedAlternativeIds = allowedAlternativeIds;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.alternativeCheckboxes.clear();
        this.expandButtons.clear();
        int x = this.getInsetX();
        for (int i = 0; i < ((AlternativeContainerMenu)this.method_17577()).getAlternatives().size(); ++i) {
            this.addWidgetsForAlternative(i, x);
        }
        this.scrollbar = new ScrollbarWidget(this.field_2776 + 173, this.field_2800 + 122, ScrollbarWidget.Type.NORMAL, 72);
        int overflowingAlternatives = ((AlternativeContainerMenu)this.method_17577()).getAlternatives().size() - 2;
        int maxOffset = this.scrollbar.isSmoothScrolling() ? overflowingAlternatives * 36 : overflowingAlternatives * 2;
        this.scrollbar.setMaxOffset(maxOffset);
        this.scrollbar.setEnabled(maxOffset > 0);
        this.scrollbar.setListener(value -> this.updateWidgets());
        this.method_25429((class_364)this.scrollbar);
        Objects.requireNonNull(this.field_22793);
        this.searchField = new class_342(this.field_22793, this.field_2776 + 24, this.field_2800 + 109, 156, 9, (class_2561)class_2561.method_43473());
        this.searchField.method_1858(false);
        this.searchField.method_1862(true);
        this.searchField.method_1856(true);
        this.searchField.method_25365(false);
        this.searchField.method_1863(query -> ((AlternativeContainerMenu)this.method_17577()).filter((String)query));
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)new SearchIconWidget(this.field_2776 + 7, this.field_2800 + 107, () -> SEARCH_HELP, this.searchField));
    }

    private int getInsetY() {
        return this.field_2800 + 122;
    }

    private int getInsetX() {
        return this.field_2776 + 8;
    }

    private int getAlternativeY(int idx) {
        return this.getInsetY() + 36 * idx;
    }

    private void addWidgetsForAlternative(int idx, int x) {
        Alternative alternative = ((AlternativeContainerMenu)this.method_17577()).getAlternatives().get(idx);
        int y = this.getAlternativeY(idx);
        boolean hasTranslation = class_1074.method_4663((String)alternative.getTranslationKey());
        class_5250 id = class_2561.method_43470((String)alternative.getId().toString());
        CheckboxWidget alternativeCheckbox = new CheckboxWidget(x + 2, y + 9 - 4, 141, (class_2561)(hasTranslation ? class_2561.method_43471((String)alternative.getTranslationKey()) : id), this.field_22793, this.initialAllowedAlternativeIds.contains(alternative.getId()), CheckboxWidget.Size.SMALL);
        if (hasTranslation) {
            alternativeCheckbox.method_47400(class_7919.method_47407((class_2561)id));
        }
        this.alternativeCheckboxes.add((CheckboxWidget)this.method_25429((class_364)alternativeCheckbox));
        CustomButton expandButton = new CustomButton(x + 164 - 16 - 1, y + 1, 16, 16, EXPAND_SPRITES, btn -> {
            boolean expanding = alternative.expandOrCollapse();
            btn.setSprites(expanding ? COLLAPSE_SPRITES : EXPAND_SPRITES);
        }, (class_2561)EXPAND);
        expandButton.field_22763 = alternative.getResources().size() > 9;
        this.expandButtons.add((class_4185)this.method_25429((class_364)expandButton));
    }

    protected void method_37432() {
        super.method_37432();
        ((AlternativeContainerMenu)this.method_17577()).getAlternatives().forEach(Alternative::update);
        this.updateWidgets();
    }

    private void updateWidgets() {
        ScrollbarWidget theScrollbar = this.scrollbar;
        if (theScrollbar == null) {
            return;
        }
        double totalHeight = 0.0;
        int totalRows = 0;
        int scrollbarOffset = (int)theScrollbar.getOffset();
        int y = this.getAlternativeY(0) - (theScrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18);
        for (int i = 0; i < ((AlternativeContainerMenu)this.method_17577()).getAlternatives().size(); ++i) {
            Alternative alternative = ((AlternativeContainerMenu)this.method_17577()).getAlternatives().get(i);
            CheckboxWidget alternativeCheckbox = this.alternativeCheckboxes.get(i);
            class_4185 expandButton = this.expandButtons.get(i);
            if (!alternative.isVisible()) {
                alternativeCheckbox.field_22764 = false;
                expandButton.field_22764 = false;
                this.updateAlternativeSlots(alternative.getMainSlots(), y, 0, false);
                this.updateAlternativeSlots(alternative.getOverflowSlots(), y, 1, false);
                continue;
            }
            totalRows += 2;
            int overflowRows = AlternativesScreen.getOverflowRows(alternative);
            totalRows += (int)((double)overflowRows * alternative.getExpandPct());
            int height = 36 + (int)((double)(overflowRows * 18) * alternative.getExpandPct());
            this.updateAlternativeCheckbox(alternativeCheckbox, y);
            this.updateExpandButton(expandButton, y);
            this.updateAlternativeSlots(alternative.getMainSlots(), y, 0, true);
            this.updateAlternativeSlots(alternative.getOverflowSlots(), y, 1, alternative.getExpandPct() > 0.0);
            totalHeight += (double)height;
            y += height;
        }
        double maxOffset = theScrollbar.isSmoothScrolling() ? totalHeight - 72.0 : (double)(totalRows - 4);
        theScrollbar.setMaxOffset(maxOffset);
        theScrollbar.setEnabled(maxOffset > 0.0);
    }

    private void updateAlternativeCheckbox(CheckboxWidget alternativeCheckbox, int y) {
        alternativeCheckbox.method_46419(y + 9 - 4);
        alternativeCheckbox.field_22764 = alternativeCheckbox.method_46427() >= this.getInsetY() - alternativeCheckbox.method_25364() && alternativeCheckbox.method_46427() < this.getInsetY() + 72;
    }

    private void updateExpandButton(class_4185 expandButton, int y) {
        expandButton.method_46419(y + 1);
        expandButton.field_22764 = expandButton.method_46427() >= this.getInsetY() - expandButton.method_25364() && expandButton.method_46427() < this.getInsetY() + 72;
    }

    private void updateAlternativeSlots(List<AlternativeSlot> slots, int y, int rowOffset, boolean visible) {
        for (int i = 0; i < slots.size(); ++i) {
            int row = i / 9 + rowOffset;
            AlternativeSlot resourceSlot = slots.get(i);
            Platform.INSTANCE.setSlotY(resourceSlot, y + 18 + row * 18 + 1 - this.field_2800);
            resourceSlot.setActive(resourceSlot.field_7872 + this.field_2800 >= this.getInsetY() - 18 && resourceSlot.field_7872 + this.field_2800 < this.getInsetY() + 72 && visible);
        }
    }

    private static int getOverflowRows(Alternative alternative) {
        return Math.ceilDiv(alternative.getResources().size() - 9, 9);
    }

    @Override
    protected void renderResourceSlots(class_332 graphics) {
        ResourceSlotRendering.render(graphics, ((AlternativeContainerMenu)this.method_17577()).getAmountSlot(), this.field_2776, this.field_2800);
    }

    @Override
    protected boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        int insetContentX = this.getInsetX();
        int insetContentY = this.getInsetY();
        return mouseX >= (double)insetContentX && mouseX < (double)(insetContentX + 164) && mouseY >= (double)insetContentY && mouseY < (double)(insetContentY + 72);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        super.method_2389(graphics, delta, mouseX, mouseY);
        int x = this.getInsetX();
        int y = this.getInsetY();
        graphics.method_44379(x, y, x + 164, y + 72);
        int currentY = y - (this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0) * (this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? 1 : 18);
        for (int i = 0; i < ((AlternativeContainerMenu)this.method_17577()).getAlternatives().size(); ++i) {
            currentY += this.renderAlternativeBackground(graphics, mouseX, mouseY, i, y, x, currentY);
        }
        this.renderAlternativeMainSlots(graphics, mouseX, mouseY);
        this.alternativeCheckboxes.forEach(c -> c.method_25394(graphics, mouseX, mouseY, delta));
        this.expandButtons.forEach(c -> c.method_25394(graphics, mouseX, mouseY, delta));
        graphics.method_44380();
    }

    private int renderAlternativeBackground(class_332 graphics, int mouseX, int mouseY, int i, int startY, int x, int y) {
        boolean backgroundVisible;
        Alternative alternative = ((AlternativeContainerMenu)this.method_17577()).getAlternatives().get(i);
        if (!alternative.isVisible()) {
            return 0;
        }
        int height = 36 + (int)((double)(AlternativesScreen.getOverflowRows(alternative) * 18) * alternative.getExpandPct());
        boolean bl = backgroundVisible = y >= startY - height && y < startY + 72;
        if (i % 2 == 0 && backgroundVisible) {
            graphics.method_51737(x, y, x + 164, y + height, 0, -3750202);
        }
        int mainSlotsY = y + 18;
        this.renderMainSlotsBackground(graphics, startY, x, mainSlotsY, alternative);
        int overflowSlotsY = y + 36;
        return 36 + this.renderOverflowSlotsBackground(graphics, mouseX, mouseY, startY, x, overflowSlotsY, alternative);
    }

    private void renderMainSlotsBackground(class_332 graphics, int startY, int x, int y, Alternative alternative) {
        if (y >= startY - 18 && y < startY + 72) {
            for (int col = 0; col < Math.min(alternative.getResources().size(), 9); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.method_52706(Sprites.SLOT, slotX, y, 18, 18);
            }
        }
    }

    private int renderOverflowSlotsBackground(class_332 graphics, int mouseX, int mouseY, int startY, int x, int y, Alternative alternative) {
        int rows = AlternativesScreen.getOverflowRows(alternative);
        int height = (int)((double)(rows * 18) * alternative.getExpandPct());
        if (height == 0) {
            return 0;
        }
        graphics.method_44379(x, y, x + 162, y + height);
        for (int row = 0; row < rows; ++row) {
            int idx;
            boolean visible;
            int rowY = y + 18 * row;
            boolean bl = visible = rowY >= startY - 18 && rowY < startY + 72;
            if (!visible) continue;
            for (int col = 0; col < 9 && (idx = 9 + row * 9 + col) < alternative.getResources().size(); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.method_52706(Sprites.SLOT, slotX, rowY, 18, 18);
            }
        }
        this.renderSlots(alternative.getOverflowSlots(), graphics, mouseX, mouseY);
        graphics.method_44380();
        return height;
    }

    private void renderAlternativeMainSlots(class_332 graphics, int mouseX, int mouseY) {
        for (Alternative alternative : ((AlternativeContainerMenu)this.method_17577()).getAlternatives()) {
            this.renderSlots(alternative.getMainSlots(), graphics, mouseX, mouseY);
        }
    }

    private void renderSlots(List<AlternativeSlot> slots, class_332 graphics, int mouseX, int mouseY) {
        for (ResourceSlot resourceSlot : slots) {
            if (!resourceSlot.method_7682()) continue;
            ResourceSlotRendering.render(graphics, resourceSlot, this.field_2776, this.field_2800);
            if (!this.method_2378(resourceSlot.field_7873, resourceSlot.field_7872, 16, 16, mouseX, mouseY) || !this.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY)) continue;
            AlternativesScreen.method_33285((class_332)graphics, (int)(this.field_2776 + resourceSlot.field_7873), (int)(this.field_2800 + resourceSlot.field_7872), (int)0);
        }
    }

    @Override
    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        graphics.method_51439(this.field_22793, (class_2561)ALTERNATIVES, 7, 96, 0x404040, false);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    public void method_16014(double mx, double my) {
        if (this.scrollbar != null) {
            this.scrollbar.method_16014(mx, my);
        }
        super.method_16014(mx, my);
    }

    public boolean method_25406(double mx, double my, int button) {
        return this.scrollbar != null && this.scrollbar.method_25406(mx, my, button) || super.method_25406(mx, my, button);
    }

    @Override
    public boolean method_25401(double x, double y, double z, double delta) {
        boolean didScrollbar = this.isOverAlternativesArea(x, y) && this.scrollbar != null && this.scrollbar.method_25401(x, y, z, delta);
        return didScrollbar || super.method_25401(x, y, z, delta);
    }

    @Override
    public boolean method_25400(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.method_25400(unknown1, unknown2) || super.method_25400(unknown1, unknown2);
    }

    @Override
    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (this.tryClose(key)) {
            return true;
        }
        if (this.searchField != null && (this.searchField.method_25404(key, scanCode, modifiers) || this.searchField.method_20315())) {
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    private boolean isOverAlternativesArea(double x, double y) {
        return x >= (double)(this.field_2776 + 7) && x < (double)(this.field_2776 + 7 + 179) && y >= (double)(this.field_2800 + 121) && y < (double)(this.field_2800 + 121 + 74);
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    protected boolean confirm(Double amount) {
        this.slot.changeAmountOnClient(amount);
        HashSet<Alternative> allowedAlternatives = new HashSet<Alternative>();
        for (int i = 0; i < this.alternativeCheckboxes.size(); ++i) {
            if (!this.alternativeCheckboxes.get(i).isSelected()) continue;
            allowedAlternatives.add(((AlternativeContainerMenu)this.method_17577()).getAlternatives().get(i));
        }
        ((AlternativeContainerMenu)this.method_17577()).sendAllowedAlternatives(allowedAlternatives);
        return true;
    }

    @Override
    protected void reset() {
        super.reset();
        this.alternativeCheckboxes.forEach(c -> c.setSelected(false));
    }
}

