/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;

class CraftingPatternGridRenderer
implements PatternGridRenderer {
    private static final class_2960 CRAFTING = IdentifierUtil.createIdentifier("pattern_grid/crafting");
    private static final class_5250 FUZZY_MODE = IdentifierUtil.createTranslation("gui", "pattern_grid.fuzzy_mode");
    private static final class_5250 FUZZY_MODE_ON_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.fuzzy_mode.on.help");
    private static final class_5250 FUZZY_MODE_OFF_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.fuzzy_mode.off.help");
    @Nullable
    private CheckboxWidget fuzzyModeCheckbox;
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int x;
    private final int y;

    CraftingPatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.x = x;
        this.y = y;
    }

    @Override
    public void addWidgets(Consumer<class_339> widgets, Consumer<class_339> renderables) {
        this.fuzzyModeCheckbox = this.createFuzzyModeCheckbox();
        renderables.accept((class_339)this.fuzzyModeCheckbox);
    }

    private CheckboxWidget createFuzzyModeCheckbox() {
        CheckboxWidget checkbox = new CheckboxWidget(this.x + 4, this.y + 4 + 54 + 4 - 2, (class_2561)FUZZY_MODE, class_310.method_1551().field_1772, this.menu.isFuzzyMode(), CheckboxWidget.Size.SMALL);
        checkbox.setOnPressed((c, selected) -> this.menu.setFuzzyMode(selected));
        checkbox.setHelpTooltip(CraftingPatternGridRenderer.getFuzzyModeTooltip(this.menu.isFuzzyMode()));
        checkbox.field_22764 = this.isFuzzyModeCheckboxVisible();
        return checkbox;
    }

    private static class_2561 getFuzzyModeTooltip(boolean fuzzyMode) {
        return fuzzyMode ? FUZZY_MODE_ON_HELP : FUZZY_MODE_OFF_HELP;
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 68;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 4;
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        if (this.fuzzyModeCheckbox != null) {
            this.fuzzyModeCheckbox.field_22764 = this.isFuzzyModeCheckboxVisible();
        }
    }

    private boolean isFuzzyModeCheckboxVisible() {
        return this.menu.getPatternType() == PatternType.CRAFTING;
    }

    @Override
    public void fuzzyModeChanged(boolean newFuzzyMode) {
        if (this.fuzzyModeCheckbox == null) {
            return;
        }
        this.fuzzyModeCheckbox.setSelected(newFuzzyMode);
        this.fuzzyModeCheckbox.setHelpTooltip(CraftingPatternGridRenderer.getFuzzyModeTooltip(newFuzzyMode));
    }

    @Override
    public void renderBackground(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.method_52706(CRAFTING, this.x + 4, this.y + 4, 130, 54);
    }
}

