/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.SmithingTablePatternState;
import com.refinedmods.refinedstorage.common.autocrafting.StonecutterPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridData;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternOutputContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternTypeSettings;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingInputData;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.StonecutterInputContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.grid.AbstractGridBlockEntity;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.RecipeMatrix;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.ResourceSorters;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import net.minecraft.class_9694;
import net.minecraft.class_9696;
import net.minecraft.class_9697;

public class PatternGridBlockEntity
extends AbstractGridBlockEntity
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<PatternGridData> {
    private static final String TAG_CRAFTING_INPUT = "crafting_input";
    private static final String TAG_PATTERN_INPUT = "pattern_input";
    private static final String TAG_PATTERN_OUTPUT = "pattern_output";
    private static final String TAG_PROCESSING_INPUT = "processing_input";
    private static final String TAG_PROCESSING_OUTPUT = "processing_output";
    private static final String TAG_FUZZY_MODE = "fuzzy_mode";
    private static final String TAG_PATTERN_TYPE = "processing";
    private static final String TAG_STONECUTTER_INPUT = "stonecutter_input";
    private static final String TAG_STONECUTTER_SELECTED_RECIPE = "stonecutter_selected_recipe";
    private static final String TAG_SMITHING_INPUT = "smithing_input";
    private final RecipeMatrix<class_3955, class_9694> craftingRecipe = RecipeMatrix.crafting(() -> ((PatternGridBlockEntity)this).method_5431(), () -> ((PatternGridBlockEntity)this).method_10997());
    private final ProcessingMatrixInputResourceContainer processingInput = PatternGridBlockEntity.createProcessingMatrixInputContainer();
    private final ResourceContainer processingOutput = PatternGridBlockEntity.createProcessingMatrixOutputContainer();
    private final FilteredContainer patternInput = new FilteredContainer(1, PatternGridBlockEntity::isValidPattern);
    private final FilteredContainer patternOutput = new PatternOutputContainer();
    private final StonecutterInputContainer stonecutterInput = new StonecutterInputContainer(() -> ((PatternGridBlockEntity)this).method_10997());
    private final RecipeMatrix<class_8059, class_9697> smithingTableRecipe = RecipeMatrix.smithingTable(() -> ((PatternGridBlockEntity)this).method_5431(), () -> ((PatternGridBlockEntity)this).method_10997());
    private boolean fuzzyMode;
    private PatternType patternType = PatternType.CRAFTING;

    public PatternGridBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getPatternGrid(), pos, state, Platform.INSTANCE.getConfig().getPatternGrid().getEnergyUsage());
        this.patternInput.method_5489(container -> this.method_5431());
        this.patternOutput.method_5489(container -> this.method_5431());
        this.processingInput.setListener(() -> ((PatternGridBlockEntity)this).method_5431());
        this.processingOutput.setListener(() -> ((PatternGridBlockEntity)this).method_5431());
        this.stonecutterInput.method_5489(container -> this.method_5431());
    }

    RecipeMatrixContainer getCraftingMatrix() {
        return this.craftingRecipe.getMatrix();
    }

    class_1731 getCraftingResult() {
        return this.craftingRecipe.getResult();
    }

    ProcessingMatrixInputResourceContainer getProcessingInput() {
        return this.processingInput;
    }

    ResourceContainer getProcessingOutput() {
        return this.processingOutput;
    }

    public FilteredContainer getPatternInput() {
        return this.patternInput;
    }

    FilteredContainer getPatternOutput() {
        return this.patternOutput;
    }

    StonecutterInputContainer getStonecutterInput() {
        return this.stonecutterInput;
    }

    int getStonecutterSelectedRecipe() {
        return this.stonecutterInput.getSelectedRecipe();
    }

    void setStonecutterSelectedRecipe(int index) {
        this.stonecutterInput.setSelectedRecipe(index);
        this.method_5431();
    }

    RecipeMatrixContainer getSmithingTableMatrix() {
        return this.smithingTableRecipe.getMatrix();
    }

    class_1731 getSmithingTableResult() {
        return this.smithingTableRecipe.getResult();
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_PATTERN_INPUT, (class_2520)ContainerUtil.write((class_1263)this.patternInput, provider));
        tag.method_10566(TAG_PATTERN_OUTPUT, (class_2520)ContainerUtil.write((class_1263)this.patternOutput, provider));
        tag.method_10556(TAG_FUZZY_MODE, this.fuzzyMode);
        tag.method_10569(TAG_PATTERN_TYPE, PatternTypeSettings.getPatternType(this.patternType));
        tag.method_10566(TAG_PROCESSING_INPUT, (class_2520)this.processingInput.toTag(provider));
        tag.method_10566(TAG_PROCESSING_OUTPUT, (class_2520)this.processingOutput.toTag(provider));
        tag.method_10566(TAG_STONECUTTER_INPUT, (class_2520)ContainerUtil.write((class_1263)this.stonecutterInput, provider));
        tag.method_10569(TAG_STONECUTTER_SELECTED_RECIPE, this.stonecutterInput.getSelectedRecipe());
        tag.method_10566(TAG_SMITHING_INPUT, (class_2520)this.smithingTableRecipe.writeToTag(provider));
        tag.method_10566(TAG_CRAFTING_INPUT, (class_2520)this.craftingRecipe.writeToTag(provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10545(TAG_PATTERN_INPUT)) {
            ContainerUtil.read(tag.method_10562(TAG_PATTERN_INPUT), (class_1263)this.patternInput, provider);
        }
        if (tag.method_10545(TAG_PATTERN_OUTPUT)) {
            ContainerUtil.read(tag.method_10562(TAG_PATTERN_OUTPUT), (class_1263)this.patternOutput, provider);
        }
        this.fuzzyMode = tag.method_10577(TAG_FUZZY_MODE);
        this.patternType = PatternTypeSettings.getPatternType(tag.method_10550(TAG_PATTERN_TYPE));
        if (tag.method_10545(TAG_PROCESSING_INPUT)) {
            this.processingInput.fromTag(tag.method_10562(TAG_PROCESSING_INPUT), provider);
        }
        if (tag.method_10545(TAG_PROCESSING_OUTPUT)) {
            this.processingOutput.fromTag(tag.method_10562(TAG_PROCESSING_OUTPUT), provider);
        }
        if (tag.method_10545(TAG_STONECUTTER_INPUT)) {
            ContainerUtil.read(tag.method_10562(TAG_STONECUTTER_INPUT), (class_1263)this.stonecutterInput, provider);
        }
        this.stonecutterInput.setSelectedRecipe(tag.method_10550(TAG_STONECUTTER_SELECTED_RECIPE));
        if (tag.method_10545(TAG_SMITHING_INPUT)) {
            this.smithingTableRecipe.readFromTag(tag.method_10562(TAG_SMITHING_INPUT), provider);
        }
        if (tag.method_10545(TAG_CRAFTING_INPUT)) {
            this.craftingRecipe.readFromTag(tag.method_10562(TAG_CRAFTING_INPUT), provider);
        }
    }

    @Override
    public void method_31662(class_1937 level) {
        super.method_31662(level);
        this.craftingRecipe.updateResult(level);
        this.stonecutterInput.updateRecipes(level);
        this.smithingTableRecipe.updateResult(level);
    }

    boolean isFuzzyMode() {
        return this.fuzzyMode;
    }

    PatternType getPatternType() {
        return this.patternType;
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.fuzzyMode = fuzzyMode;
        this.method_5431();
    }

    void setPatternType(PatternType patternType) {
        this.patternType = patternType;
        this.method_5431();
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.PATTERN_GRID);
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new PatternGridContainerMenu(syncId, inventory, this);
    }

    @Override
    public PatternGridData getMenuData() {
        return new PatternGridData(GridData.of(this), this.patternType, ProcessingInputData.of(this.processingInput), ResourceContainerData.of(this.processingOutput), this.stonecutterInput.getSelectedRecipe());
    }

    @Override
    public class_9142<class_9129, PatternGridData> getMenuCodec() {
        return PatternGridData.STREAM_CODEC;
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        drops.add((Object)this.patternInput.method_5438(0));
        drops.add((Object)this.patternOutput.method_5438(0));
        return drops;
    }

    void clear() {
        if (this.field_11863 == null) {
            return;
        }
        switch (this.patternType) {
            case CRAFTING: {
                this.craftingRecipe.clear(this.field_11863);
                break;
            }
            case PROCESSING: {
                this.clearProcessing();
                break;
            }
            case STONECUTTER: {
                this.stonecutterInput.method_5448();
                break;
            }
            case SMITHING_TABLE: {
                this.smithingTableRecipe.clear(this.field_11863);
            }
        }
        this.method_5431();
    }

    private void clearProcessing() {
        this.processingInput.clear();
        this.processingOutput.clear();
    }

    void createPattern() {
        class_1799 result;
        if (this.field_11863 == null || !this.isPatternAvailable()) {
            return;
        }
        switch (this.patternType) {
            default: {
                throw new MatchException(null, null);
            }
            case CRAFTING: {
                class_1799 class_17992 = this.createCraftingPattern();
                break;
            }
            case PROCESSING: {
                class_1799 class_17992 = this.createProcessingPattern();
                break;
            }
            case STONECUTTER: {
                class_1799 class_17992 = this.createStonecutterPattern();
                break;
            }
            case SMITHING_TABLE: {
                class_1799 class_17992 = result = this.createSmithingTablePattern();
            }
        }
        if (result != null) {
            boolean shouldExtractInputPattern = this.patternOutput.method_5438(0).method_7960();
            if (shouldExtractInputPattern) {
                this.patternInput.method_5434(0, 1);
            }
            this.patternOutput.method_5447(0, result);
        }
    }

    @Nullable
    private class_1799 createCraftingPattern() {
        if (!this.craftingRecipe.hasResult()) {
            return null;
        }
        class_1799 result = PatternGridBlockEntity.createPatternStack(PatternType.CRAFTING);
        CraftingPatternState state = new CraftingPatternState(this.fuzzyMode, this.getCraftingMatrix().method_60501());
        result.method_57379(DataComponents.INSTANCE.getCraftingPatternState(), (Object)state);
        return result;
    }

    @Nullable
    private class_1799 createProcessingPattern() {
        if (this.processingInput.isEmpty() || this.processingOutput.isEmpty()) {
            return null;
        }
        class_1799 result = PatternGridBlockEntity.createPatternStack(PatternType.PROCESSING);
        ArrayList<Optional<ProcessingPatternState.ProcessingIngredient>> ingredients = new ArrayList<Optional<ProcessingPatternState.ProcessingIngredient>>();
        for (int i = 0; i < this.processingInput.size(); ++i) {
            ingredients.add(this.processingInput.getIngredient(i));
        }
        ArrayList<Optional<ResourceAmount>> outputs = new ArrayList<Optional<ResourceAmount>>();
        for (int i = 0; i < this.processingOutput.size(); ++i) {
            outputs.add(Optional.ofNullable(this.processingOutput.get(i)));
        }
        ProcessingPatternState patternProcessingState = new ProcessingPatternState(ingredients, outputs);
        result.method_57379(DataComponents.INSTANCE.getProcessingPatternState(), (Object)patternProcessingState);
        return result;
    }

    @Nullable
    private class_1799 createStonecutterPattern() {
        if (this.stonecutterInput.method_5438(0).method_7960() || !this.stonecutterInput.hasSelectedRecipe() || this.field_11863 == null) {
            return null;
        }
        class_1799 input = this.stonecutterInput.method_5438(0);
        List<class_8786<class_3975>> recipes = this.stonecutterInput.getRecipes();
        int selectedRecipe = this.stonecutterInput.getSelectedRecipe();
        if (selectedRecipe < 0 || selectedRecipe >= recipes.size()) {
            return null;
        }
        class_1799 selectedOutput = ((class_3975)recipes.get(selectedRecipe).comp_1933()).method_59998(new class_9696(input), (class_7225.class_7874)this.field_11863.method_30349());
        if (selectedOutput.method_7960()) {
            return null;
        }
        class_1799 result = PatternGridBlockEntity.createPatternStack(PatternType.STONECUTTER);
        StonecutterPatternState state = new StonecutterPatternState(ItemResource.ofItemStack(input), ItemResource.ofItemStack(selectedOutput));
        result.method_57379(DataComponents.INSTANCE.getStonecutterPatternState(), (Object)state);
        return result;
    }

    @Nullable
    private class_1799 createSmithingTablePattern() {
        if (!this.smithingTableRecipe.hasResult()) {
            return null;
        }
        class_1799 result = PatternGridBlockEntity.createPatternStack(PatternType.SMITHING_TABLE);
        SmithingTablePatternState state = new SmithingTablePatternState(ItemResource.ofItemStack(this.smithingTableRecipe.getMatrix().method_5438(0)), ItemResource.ofItemStack(this.smithingTableRecipe.getMatrix().method_5438(1)), ItemResource.ofItemStack(this.smithingTableRecipe.getMatrix().method_5438(2)));
        result.method_57379(DataComponents.INSTANCE.getSmithingTablePatternState(), (Object)state);
        return result;
    }

    public static class_1799 createPatternStack(PatternType patternType) {
        class_1799 result = new class_1799((class_1935)Items.INSTANCE.getPattern());
        PatternState patternState = new PatternState(UUID.randomUUID(), patternType);
        result.method_57379(DataComponents.INSTANCE.getPatternState(), (Object)patternState);
        return result;
    }

    void copyPattern(class_1799 stack) {
        PatternState patternState = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        if (patternState == null) {
            return;
        }
        this.patternType = patternState.type();
        switch (patternState.type()) {
            case CRAFTING: {
                CraftingPatternState state = (CraftingPatternState)stack.method_57824(DataComponents.INSTANCE.getCraftingPatternState());
                if (state == null) break;
                this.copyCraftingPattern(state);
                break;
            }
            case PROCESSING: {
                ProcessingPatternState state = (ProcessingPatternState)stack.method_57824(DataComponents.INSTANCE.getProcessingPatternState());
                if (state == null) break;
                this.copyProcessingPattern(state);
                break;
            }
            case STONECUTTER: {
                StonecutterPatternState state = (StonecutterPatternState)stack.method_57824(DataComponents.INSTANCE.getStonecutterPatternState());
                if (state == null) break;
                this.copyStonecutterPattern(state);
                break;
            }
            case SMITHING_TABLE: {
                SmithingTablePatternState state = (SmithingTablePatternState)stack.method_57824(DataComponents.INSTANCE.getSmithingTablePatternState());
                if (state == null) break;
                this.copySmithingTablePattern(state);
            }
        }
        this.method_5431();
    }

    private void copyCraftingPattern(CraftingPatternState state) {
        this.fuzzyMode = state.fuzzyMode();
        this.craftingRecipe.getMatrix().method_5448();
        class_9694.class_9765 positionedInput = state.input();
        int left = positionedInput.comp_2796();
        int top = positionedInput.comp_2797();
        class_9694 input = positionedInput.comp_2795();
        for (int x = 0; x < input.method_59991(); ++x) {
            for (int y = 0; y < input.method_59992(); ++y) {
                int matrixIndex = x + left + (y + top) * this.craftingRecipe.getMatrix().method_17398();
                int recipeIndex = x + y * input.method_59991();
                class_1799 stack = input.method_59984(recipeIndex);
                this.craftingRecipe.getMatrix().method_5447(matrixIndex, stack);
            }
        }
        if (this.field_11863 != null) {
            this.craftingRecipe.updateResult(this.field_11863);
        }
    }

    private void copyProcessingPattern(ProcessingPatternState state) {
        int ii;
        int i;
        this.clearProcessing();
        for (i = 0; i < state.ingredients().size(); ++i) {
            ii = i;
            state.ingredients().get(i).ifPresent(processingIngredient -> this.processingInput.set(ii, (ProcessingPatternState.ProcessingIngredient)processingIngredient));
        }
        for (i = 0; i < state.outputs().size(); ++i) {
            ii = i;
            state.outputs().get(i).ifPresent(amount -> this.processingOutput.set(ii, (ResourceAmount)amount));
        }
    }

    private void copyStonecutterPattern(StonecutterPatternState state) {
        ItemResource input = state.input();
        ItemResource selectedOutput = state.selectedOutput();
        this.setStonecutterInputAndSelectedRecipe(input.toItemStack(), selectedOutput.toItemStack());
    }

    private void setStonecutterInputAndSelectedRecipe(class_1799 input, class_1799 selectedOutput) {
        if (this.field_11863 == null) {
            return;
        }
        this.stonecutterInput.method_5448();
        this.stonecutterInput.setSelectedRecipe(-1);
        this.stonecutterInput.method_5447(0, input);
        for (int i = 0; i < this.stonecutterInput.getRecipes().size(); ++i) {
            class_1799 result = ((class_3975)this.stonecutterInput.getRecipes().get(i).comp_1933()).method_59998(new class_9696(input), (class_7225.class_7874)this.field_11863.method_30349());
            if (!class_1799.method_31577((class_1799)result, (class_1799)selectedOutput)) continue;
            this.stonecutterInput.setSelectedRecipe(i);
            return;
        }
    }

    private void copySmithingTablePattern(SmithingTablePatternState state) {
        ItemResource template = state.template();
        ItemResource base = state.base();
        ItemResource addition = state.addition();
        this.setSmithingTableInput(template.toItemStack(), base.toItemStack(), addition.toItemStack());
    }

    private void setSmithingTableInput(class_1799 template, class_1799 base, class_1799 addition) {
        this.smithingTableRecipe.getMatrix().method_5448();
        this.smithingTableRecipe.getMatrix().method_5447(0, template);
        this.smithingTableRecipe.getMatrix().method_5447(1, base);
        this.smithingTableRecipe.getMatrix().method_5447(2, addition);
        if (this.field_11863 != null) {
            this.smithingTableRecipe.updateResult(this.field_11863);
        }
    }

    private boolean isPatternAvailable() {
        return !this.patternInput.method_5438(0).method_7960() || !this.patternOutput.method_5438(0).method_7960();
    }

    void transferCraftingRecipe(class_1657 player, List<List<ItemResource>> recipe) {
        Comparator<ResourceKey> sorter = ResourceSorters.create(((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? (RootStorage)((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(StorageNetworkComponent.class) : null, ((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? ((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(AutocraftingNetworkComponent.class).getPatterns() : Collections.emptySet(), player.method_31548(), r -> r);
        this.getCraftingMatrix().method_5448();
        for (int i = 0; i < this.getCraftingMatrix().method_5439() && i < recipe.size(); ++i) {
            List<ItemResource> possibilities = recipe.get(i);
            if (possibilities.isEmpty()) continue;
            possibilities.sort(sorter);
            this.getCraftingMatrix().method_5447(i, possibilities.getFirst().toItemStack());
        }
        this.setPatternType(PatternType.CRAFTING);
    }

    void transferProcessingRecipe(class_1657 player, List<List<ResourceAmount>> inputs, List<List<ResourceAmount>> outputs) {
        Comparator<ResourceAmount> sorter = ResourceSorters.create(((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? (RootStorage)((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(StorageNetworkComponent.class) : null, ((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? ((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(AutocraftingNetworkComponent.class).getPatterns() : Collections.emptySet(), player.method_31548(), ResourceAmount::resource);
        this.getProcessingInput().clear();
        this.transferProcessingRecipe(inputs, this.getProcessingInput(), sorter);
        this.getProcessingOutput().clear();
        this.transferProcessingRecipe(outputs, this.getProcessingOutput(), sorter);
        this.setPatternType(PatternType.PROCESSING);
    }

    private void transferProcessingRecipe(List<List<ResourceAmount>> recipe, ResourceContainer container, Comparator<ResourceAmount> sorter) {
        for (int i = 0; i < container.size() && i < recipe.size(); ++i) {
            List<ResourceAmount> possibilities = recipe.get(i);
            if (possibilities.isEmpty()) continue;
            possibilities.sort(sorter);
            container.set(i, possibilities.getFirst());
        }
    }

    void transferStonecutterRecipe(ItemResource input, ItemResource selectedOutput) {
        this.setStonecutterInputAndSelectedRecipe(input.toItemStack(), selectedOutput.toItemStack());
        this.setPatternType(PatternType.STONECUTTER);
    }

    void transferSmithingTableRecipe(class_1657 player, List<ItemResource> templates, List<ItemResource> bases, List<ItemResource> additions) {
        if (templates.isEmpty() || bases.isEmpty() || additions.isEmpty()) {
            return;
        }
        Comparator<ItemResource> sorter = ResourceSorters.create(((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? (RootStorage)((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(StorageNetworkComponent.class) : null, ((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? ((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(AutocraftingNetworkComponent.class).getPatterns() : Collections.emptySet(), player.method_31548(), r -> r);
        templates.sort(sorter);
        bases.sort(sorter);
        additions.sort(sorter);
        ItemResource template = templates.getFirst();
        ItemResource base = bases.getFirst();
        ItemResource addition = additions.getFirst();
        this.setSmithingTableInput(template.toItemStack(), base.toItemStack(), addition.toItemStack());
        this.setPatternType(PatternType.SMITHING_TABLE);
    }

    static boolean isValidPattern(class_1799 stack) {
        return stack.method_7909() instanceof PatternItem;
    }

    static ProcessingMatrixInputResourceContainer createProcessingMatrixInputContainer() {
        return new ProcessingMatrixInputResourceContainer(81, PatternGridBlockEntity::getProcessingPatternLimit, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ProcessingMatrixInputResourceContainer createProcessingMatrixInputContainer(ProcessingInputData data) {
        ProcessingMatrixInputResourceContainer filterContainer = PatternGridBlockEntity.createProcessingMatrixInputContainer();
        ResourceContainerImpl.setResourceContainerData(data.resourceContainerData().resources(), filterContainer);
        for (int i = 0; i < data.allowedTagIds().size(); ++i) {
            filterContainer.setAllowedTagIds(i, data.allowedTagIds().get(i));
        }
        return filterContainer;
    }

    static ResourceContainer createProcessingMatrixOutputContainer() {
        return new ResourceContainerImpl(81, PatternGridBlockEntity::getProcessingPatternLimit, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ResourceContainer createProcessingMatrixOutputContainer(ResourceContainerData data) {
        ResourceContainer filterContainer = PatternGridBlockEntity.createProcessingMatrixOutputContainer();
        ResourceContainerImpl.setResourceContainerData(data.resources(), filterContainer);
        return filterContainer;
    }

    private static long getProcessingPatternLimit(ResourceKey resource) {
        long l;
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            l = platformResource.getProcessingPatternLimit();
        } else {
            l = 1L;
        }
        return l;
    }
}

