/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridData;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridPropertyTypes;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternOutputContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixResourceSlot;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.StonecutterInputContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.FilterSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_8052;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import org.apache.commons.lang3.tuple.Pair;
import org.apiguardian.api.API;

public class PatternGridContainerMenu
extends AbstractGridContainerMenu {
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_PATTERN_INPUT_SLOT = 81;
    private static final int SPACING_BETWEEN_PATTERN_INPUT_AND_PATTERN_OUTPUT_SLOTS = 36;
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_FIRST_CRAFTING_MATRIX_SLOT = 85;
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_FIRST_PROCESSING_MATRIX_SLOT = 76;
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_STONECUTTER_SLOT = 63;
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_SMITHING_TABLE_SLOTS = 63;
    private static final int INDIVIDUAL_PROCESSING_MATRIX_SIZE = 54;
    private final class_1263 patternInput;
    private final class_1263 patternOutput;
    private final class_1263 craftingMatrix;
    private final class_1263 craftingResult;
    private final ProcessingMatrixInputResourceContainer processingInput;
    private final ResourceContainer processingOutput;
    private final StonecutterInputContainer stonecutterInput;
    private final class_1263 smithingTableMatrix;
    private final class_1263 smithingTableResult;
    private final List<class_8786<class_8059>> smithingTableRecipes;
    @Nullable
    private PatternGridListener listener;
    @Nullable
    private PatternGridBlockEntity patternGrid;
    @Nullable
    private class_1735 patternOutputSlot;

    public PatternGridContainerMenu(int syncId, class_1661 playerInventory, PatternGridData patternGridData) {
        super(Menus.INSTANCE.getPatternGrid(), syncId, playerInventory, patternGridData.gridData());
        this.patternInput = new FilteredContainer(1, PatternGridBlockEntity::isValidPattern);
        this.patternOutput = new PatternOutputContainer();
        this.processingInput = PatternGridBlockEntity.createProcessingMatrixInputContainer(patternGridData.processingInputData());
        this.processingOutput = PatternGridBlockEntity.createProcessingMatrixOutputContainer(patternGridData.processingOutputData());
        this.craftingMatrix = new RecipeMatrixContainer(null, 3, 3);
        this.craftingResult = new class_1731();
        this.stonecutterInput = new StonecutterInputContainer(() -> ((class_1657)playerInventory.field_7546).method_37908());
        this.smithingTableMatrix = new RecipeMatrixContainer(null, 3, 1);
        this.smithingTableResult = new class_1731();
        this.smithingTableRecipes = playerInventory.field_7546.method_37908().method_8433().method_30027(class_3956.field_25388);
        this.resized(0, 0, 0);
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.registerProperty(new ClientProperty<PatternType>(PatternGridPropertyTypes.PATTERN_TYPE, patternGridData.patternType()){

            @Override
            protected void onChangedOnClient(PatternType newValue) {
                super.onChangedOnClient(newValue);
                if (PatternGridContainerMenu.this.listener != null) {
                    PatternGridContainerMenu.this.listener.patternTypeChanged(newValue);
                }
            }
        });
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, Boolean.valueOf(false)){

            @Override
            protected void onChangedOnClient(Boolean newValue) {
                super.onChangedOnClient(newValue);
                if (PatternGridContainerMenu.this.listener != null) {
                    PatternGridContainerMenu.this.listener.fuzzyModeChanged(newValue);
                }
            }
        });
        this.registerProperty(new ClientProperty<Integer>(PatternGridPropertyTypes.STONECUTTER_SELECTED_RECIPE, patternGridData.stonecutterSelectedRecipe()));
    }

    PatternGridContainerMenu(int syncId, class_1661 playerInventory, PatternGridBlockEntity grid) {
        super(Menus.INSTANCE.getPatternGrid(), syncId, playerInventory, grid);
        this.patternInput = grid.getPatternInput();
        this.patternOutput = grid.getPatternOutput();
        this.craftingMatrix = grid.getCraftingMatrix();
        this.craftingResult = grid.getCraftingResult();
        this.stonecutterInput = grid.getStonecutterInput();
        this.processingInput = grid.getProcessingInput();
        this.processingOutput = grid.getProcessingOutput();
        this.smithingTableMatrix = grid.getSmithingTableMatrix();
        this.smithingTableResult = grid.getSmithingTableResult();
        this.smithingTableRecipes = playerInventory.field_7546.method_37908().method_8433().method_30027(class_3956.field_25388);
        this.patternGrid = grid;
        this.resized(0, 0, 0);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, grid::getRedstoneMode, grid::setRedstoneMode));
        this.registerProperty(new ServerProperty<PatternType>(PatternGridPropertyTypes.PATTERN_TYPE, grid::getPatternType, grid::setPatternType));
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, grid::isFuzzyMode, grid::setFuzzyMode));
        this.registerProperty(new ServerProperty<Integer>(PatternGridPropertyTypes.STONECUTTER_SELECTED_RECIPE, grid::getStonecutterSelectedRecipe, grid::setStonecutterSelectedRecipe));
    }

    void setListener(PatternGridListener listener) {
        this.listener = listener;
    }

    PatternType getPatternType() {
        return this.getProperty(PatternGridPropertyTypes.PATTERN_TYPE).getValue();
    }

    void setPatternType(PatternType patternType) {
        this.getProperty(PatternGridPropertyTypes.PATTERN_TYPE).setValue(patternType);
    }

    boolean isFuzzyMode() {
        return Boolean.TRUE.equals(this.getProperty(PropertyTypes.FUZZY_MODE).getValue());
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.getProperty(PropertyTypes.FUZZY_MODE).setValue(fuzzyMode);
    }

    boolean canCreatePattern() {
        if (this.patternInput.method_5438(0).method_7960() && this.patternOutput.method_5438(0).method_7960()) {
            return false;
        }
        return switch (this.getPatternType()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> {
                if (!this.craftingResult.method_5438(0).method_7960()) {
                    yield true;
                }
                yield false;
            }
            case PatternType.PROCESSING -> {
                if (!this.processingInput.isEmpty() && !this.processingOutput.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case PatternType.STONECUTTER -> {
                if (!this.stonecutterInput.method_5438(0).method_7960() && this.getStonecutterSelectedRecipe() >= 0) {
                    yield true;
                }
                yield false;
            }
            case PatternType.SMITHING_TABLE -> !this.smithingTableResult.method_5438(0).method_7960();
        };
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        super.resized(playerInventoryY, topYStart, topYEnd);
        this.transferManager.clear();
        this.addSmithingTableSlots(playerInventoryY);
        this.addPatternSlots(playerInventoryY);
        this.addCraftingMatrixSlots(playerInventoryY);
        this.addProcessingMatrixSlots(playerInventoryY);
        this.addStonecutterSlots(playerInventoryY);
    }

    int getFirstSmithingTableSlotIndex() {
        return 36;
    }

    private void addPatternSlots(int playerInventoryY) {
        this.method_7621(new ValidatedSlot(this.patternInput, 0, 152, playerInventoryY - 81, PatternGridBlockEntity::isValidPattern));
        this.patternOutputSlot = this.method_7621(new ValidatedSlot(this.patternOutput, 0, 152, playerInventoryY - 81 + 36, PatternGridBlockEntity::isValidPattern){

            @Override
            public boolean method_7680(class_1799 stack) {
                return PatternGridContainerMenu.this.patternOutput.method_5437(0, stack);
            }

            public void method_7673(class_1799 stack) {
                super.method_7673(stack);
                if (PatternGridContainerMenu.this.patternGrid != null && !stack.method_7960()) {
                    PatternGridContainerMenu.this.patternGrid.copyPattern(stack);
                }
            }
        });
        this.transferManager.addBiTransfer((class_1263)this.playerInventory, this.patternInput);
        this.transferManager.addTransfer(this.patternOutput, (class_1263)this.playerInventory);
    }

    public boolean isPatternInOutput(class_1799 stack) {
        return this.patternOutputSlot != null && this.patternOutputSlot.method_7677() == stack;
    }

    @Override
    @Nullable
    protected ResourceKey getResourceForAutocraftableHint(class_1735 slot) {
        boolean isResultItem;
        boolean isInputItem = slot.field_7871 == this.craftingMatrix || slot.field_7871 == this.stonecutterInput || slot.field_7871 == this.smithingTableMatrix;
        boolean bl = isResultItem = slot.field_7871 == this.craftingResult || slot.field_7871 == this.smithingTableResult;
        if (isInputItem || isResultItem) {
            return ItemResource.ofItemStack(slot.method_7677());
        }
        if (slot instanceof ProcessingMatrixResourceSlot) {
            ProcessingMatrixResourceSlot processingMatrixSlot = (ProcessingMatrixResourceSlot)slot;
            return processingMatrixSlot.getResource();
        }
        return super.getResourceForAutocraftableHint(slot);
    }

    @Override
    public boolean isLargeSlot(class_1735 slot) {
        return slot.field_7871 == this.craftingResult || super.isLargeSlot(slot);
    }

    private void addCraftingMatrixSlots(int playerInventoryY) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotX = 13 + x % 3 * 18;
                int slotY = playerInventoryY - 85 + y % 3 * 18;
                this.method_7621(new FilterSlot(this.craftingMatrix, x + y * 3, slotX, slotY){

                    public boolean method_7682() {
                        return PatternGridContainerMenu.this.getPatternType() == PatternType.CRAFTING;
                    }
                });
            }
        }
        this.method_7621(new DisabledSlot(this.craftingResult, 0, 121, playerInventoryY - 85 + 18){

            public boolean method_7682() {
                return PatternGridContainerMenu.this.getPatternType() == PatternType.CRAFTING;
            }
        });
    }

    private void addProcessingMatrixSlots(int playerInventoryY) {
        int y = playerInventoryY - 76;
        int startY = y - 18;
        int endY = y + 54;
        this.addProcessingMatrixSlots(13, y, startY, endY, this.processingInput, true);
        this.addProcessingMatrixSlots(69, y, startY, endY, this.processingOutput, false);
    }

    private void addProcessingMatrixSlots(int x, int y, int startY, int endY, ResourceContainer resourceContainer, boolean input) {
        int slotX = x;
        int slotY = y;
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.method_7621(new ProcessingMatrixResourceSlot(resourceContainer, i, slotX, slotY, input, this::getPatternType, (Pair<Integer, Integer>)Pair.of((Object)startY, (Object)endY)));
            if ((i + 1) % 3 == 0) {
                slotX = x;
                slotY += 18;
                continue;
            }
            slotX += 18;
        }
    }

    private void addStonecutterSlots(int playerInventoryY) {
        int slotY = playerInventoryY - 63;
        this.method_7621(new FilterSlot((class_1263)this.stonecutterInput, 0, 13, slotY){

            public boolean method_7682() {
                return PatternGridContainerMenu.this.getPatternType() == PatternType.STONECUTTER;
            }
        });
    }

    private void addSmithingTableSlots(int playerInventoryY) {
        int y = playerInventoryY - 63;
        for (int i = 0; i < 3; ++i) {
            final int ii = i;
            this.method_7621(new FilterSlot(this.smithingTableMatrix, i, 13 + i * 18, y){

                public boolean method_7682() {
                    return PatternGridContainerMenu.this.getPatternType() == PatternType.SMITHING_TABLE;
                }

                public boolean method_7680(class_1799 stack) {
                    return PatternGridContainerMenu.this.smithingTableRecipes.stream().anyMatch(recipe -> switch (ii) {
                        case 0 -> ((class_8059)recipe.comp_1933()).method_48453(stack);
                        case 1 -> ((class_8059)recipe.comp_1933()).method_48454(stack);
                        case 2 -> ((class_8059)recipe.comp_1933()).method_30029(stack);
                        default -> false;
                    });
                }
            });
        }
        this.method_7621(new DisabledSlot(this.smithingTableResult, 0, 93, y){

            public boolean method_7682() {
                return PatternGridContainerMenu.this.getPatternType() == PatternType.SMITHING_TABLE;
            }
        });
    }

    Optional<class_8052> getSmithingTableTemplateItem() {
        class_1792 item;
        class_1799 stack = this.method_7611(this.getFirstSmithingTableSlotIndex()).method_7677();
        if (!stack.method_7960() && (item = stack.method_7909()) instanceof class_8052) {
            class_8052 templateItem = (class_8052)item;
            return Optional.of(templateItem);
        }
        return Optional.empty();
    }

    List<class_8786<class_3975>> getStonecutterRecipes() {
        return this.stonecutterInput.getRecipes();
    }

    int getStonecutterSelectedRecipe() {
        return this.getProperty(PatternGridPropertyTypes.STONECUTTER_SELECTED_RECIPE).getValue();
    }

    void setStonecutterSelectedRecipe(int idx) {
        this.getProperty(PatternGridPropertyTypes.STONECUTTER_SELECTED_RECIPE).setValue(idx);
    }

    class_1799 getSmithingTableResult() {
        return this.smithingTableResult.method_5438(0);
    }

    public void clear() {
        if (this.patternGrid != null) {
            this.patternGrid.clear();
        }
    }

    void sendClear() {
        C2SPackets.sendPatternGridClear();
    }

    public void createPattern() {
        if (this.patternGrid != null) {
            this.patternGrid.createPattern();
        }
    }

    void sendCreatePattern() {
        C2SPackets.sendPatternGridCreatePattern();
    }

    @API(status=API.Status.INTERNAL)
    public void transferCraftingRecipe(List<List<ItemResource>> recipe) {
        if (this.patternGrid == null) {
            C2SPackets.sendPatternGridCraftingRecipeTransfer(recipe);
            return;
        }
        if (this.player != null) {
            this.patternGrid.transferCraftingRecipe(this.player, recipe);
        }
    }

    @API(status=API.Status.INTERNAL)
    public void transferProcessingRecipe(List<List<ResourceAmount>> inputs, List<List<ResourceAmount>> outputs) {
        if (this.patternGrid == null) {
            C2SPackets.sendPatternGridProcessingRecipeTransfer(inputs, outputs);
            return;
        }
        if (this.player != null) {
            this.patternGrid.transferProcessingRecipe(this.player, inputs, outputs);
        }
    }

    @API(status=API.Status.INTERNAL)
    public void transferStonecutterRecipe(ItemResource input, ItemResource selectedOutput) {
        if (this.patternGrid == null) {
            C2SPackets.sendPatternGridStonecutterRecipeTransfer(input, selectedOutput);
            return;
        }
        this.patternGrid.transferStonecutterRecipe(input, selectedOutput);
    }

    @API(status=API.Status.INTERNAL)
    public void transferSmithingTableRecipe(List<ItemResource> templates, List<ItemResource> bases, List<ItemResource> additions) {
        if (this.patternGrid == null) {
            C2SPackets.sendPatternGridSmithingTableRecipeTransfer(templates, bases, additions);
            return;
        }
        if (this.player != null) {
            this.patternGrid.transferSmithingTableRecipe(this.player, templates, bases, additions);
        }
    }

    public void handleAllowedAlternativesUpdate(int slotIndex, Set<class_2960> ids) {
        this.processingInput.setAllowedTagIds(slotIndex, ids);
    }

    Set<class_2960> getAllowedAlternatives(int containerSlot) {
        return this.processingInput.getAllowedTagIds(containerSlot);
    }

    static interface PatternGridListener {
        public void patternTypeChanged(PatternType var1);

        public void fuzzyModeChanged(boolean var1);
    }
}

