/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.mojang.datafixers.util.Pair;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativesScreen;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternTypeButton;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputClientTooltipComponent;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixResourceSlot;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_7919;
import net.minecraft.class_8666;

public class PatternGridScreen
extends AbstractGridScreen<PatternGridContainerMenu>
implements PatternGridContainerMenu.PatternGridListener,
PatternOutputRenderingScreen {
    static final int INSET_PADDING = 4;
    static final int INSET_WIDTH = 138;
    static final int INSET_HEIGHT = 71;
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/pattern_grid.png");
    private static final class_5250 CREATE_PATTERN = IdentifierUtil.createTranslation("gui", "pattern_grid.create_pattern");
    private static final class_5250 CLEAR = IdentifierUtil.createTranslation("gui", "pattern_grid.clear");
    private static final int CREATE_PATTERN_BUTTON_SIZE = 16;
    private static final class_8666 CREATE_PATTERN_BUTTON_SPRITES = new class_8666(IdentifierUtil.createIdentifier("widget/create_pattern"), IdentifierUtil.createIdentifier("widget/create_pattern_disabled"), IdentifierUtil.createIdentifier("widget/create_pattern_focused"), IdentifierUtil.createIdentifier("widget/create_pattern_disabled"));
    private static final class_8666 CLEAR_BUTTON_SPRITES = new class_8666(IdentifierUtil.createIdentifier("widget/clear"), IdentifierUtil.createIdentifier("widget/clear_disabled"), IdentifierUtil.createIdentifier("widget/clear_focused"), IdentifierUtil.createIdentifier("widget/clear_disabled"));
    @Nullable
    private class_4185 createPatternButton;
    @Nullable
    private class_4185 clearButton;
    @Nullable
    private PatternGridRenderer renderer;
    private final Map<PatternType, PatternTypeButton> patternTypeButtons = new EnumMap<PatternType, PatternTypeButton>(PatternType.class);
    private final class_1661 playerInventory;
    private final Map<Pair<PlatformResourceKey, Set<class_2960>>, ProcessingMatrixInputClientTooltipComponent> processingMatrixInputTooltipCache = new HashMap<Pair<PlatformResourceKey, Set<class_2960>>, ProcessingMatrixInputClientTooltipComponent>();
    private final Map<PatternType, PatternGridRenderer> renderers = new EnumMap<PatternType, PatternGridRenderer>(PatternType.class);

    public PatternGridScreen(PatternGridContainerMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title, 177);
        this.field_25270 = 153;
        this.field_2792 = 193;
        this.field_2779 = 249;
        this.playerInventory = inventory;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.initRenderers();
        this.createPatternButton = this.createCreatePatternButton(this.field_2776 + 152, this.field_2800 + this.field_2779 - this.bottomHeight + 32);
        this.method_37063((class_364)this.createPatternButton);
        this.addPatternTypeButtons(((PatternGridContainerMenu)this.method_17577()).getPatternType());
        this.clearButton = this.createClearButton();
        this.method_37063((class_364)this.clearButton);
        ((PatternGridContainerMenu)this.field_2797).setListener(this);
    }

    private void initRenderers() {
        for (PatternType type : PatternType.values()) {
            PatternGridRenderer typeRenderer = type.createRenderer((PatternGridContainerMenu)this.field_2797, this.field_2776, this.field_2800, this.getInsetX(), this.getInsetY());
            if (type == ((PatternGridContainerMenu)this.method_17577()).getPatternType()) {
                this.renderer = typeRenderer;
            }
            typeRenderer.addWidgets(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
            }, x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.renderers.put(type, typeRenderer);
        }
    }

    private CustomButton createCreatePatternButton(int x, int y) {
        CustomButton button = new CustomButton(x, y, 16, 16, CREATE_PATTERN_BUTTON_SPRITES, b -> ((PatternGridContainerMenu)this.method_17577()).sendCreatePattern(), (class_2561)CREATE_PATTERN);
        button.method_47400(class_7919.method_47407((class_2561)CREATE_PATTERN));
        button.field_22763 = ((PatternGridContainerMenu)this.method_17577()).canCreatePattern();
        return button;
    }

    private void addPatternTypeButtons(PatternType currentPatternType) {
        PatternType[] patternTypes = PatternType.values();
        for (int i = 0; i < patternTypes.length; ++i) {
            PatternType patternType = patternTypes[i];
            PatternTypeButton button = new PatternTypeButton(this.field_2776 + 172, this.field_2800 + this.field_2779 - this.bottomHeight + 4 + i * 19, btn -> ((PatternGridContainerMenu)this.method_17577()).setPatternType(patternType), patternType, patternType == currentPatternType);
            this.patternTypeButtons.put(patternType, button);
            this.method_37063((class_364)button);
        }
    }

    private CustomButton createClearButton() {
        CustomButton button = new CustomButton(Objects.requireNonNull(this.renderer).getClearButtonX(), Objects.requireNonNull(this.renderer).getClearButtonY(), 7, 7, CLEAR_BUTTON_SPRITES, b -> ((PatternGridContainerMenu)this.method_17577()).sendClear(), (class_2561)CLEAR);
        button.method_47400(class_7919.method_47407((class_2561)CLEAR));
        return button;
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (this.createPatternButton != null) {
            this.createPatternButton.field_22763 = ((PatternGridContainerMenu)this.method_17577()).canCreatePattern();
        }
        if (this.renderer != null) {
            this.renderer.tick();
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.renderer != null) {
            this.renderer.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(graphics, partialTicks, mouseX, mouseY);
        if (this.renderer != null) {
            this.renderer.renderBackground(graphics, partialTicks, mouseX, mouseY);
        }
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        super.method_2380(graphics, x, y);
        if (this.renderer != null) {
            this.renderer.renderTooltip(this.field_22793, this.field_2787, graphics, x, y);
        }
    }

    @Override
    protected void renderResourceSlots(class_332 graphics) {
    }

    @Override
    protected boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        return this.renderer != null && this.renderer.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY);
    }

    @Override
    protected void addResourceSlotTooltips(ResourceSlot resourceSlot, List<class_5684> tooltip) {
        ProcessingMatrixResourceSlot matrixSlot;
        if (resourceSlot instanceof ProcessingMatrixResourceSlot && (matrixSlot = (ProcessingMatrixResourceSlot)resourceSlot).isInput()) {
            Set<class_2960> allowedAlternatives = ((PatternGridContainerMenu)this.method_17577()).getAllowedAlternatives(matrixSlot.method_34266());
            if (matrixSlot.getResource() != null && !allowedAlternatives.isEmpty()) {
                Pair cacheKey = Pair.of((Object)matrixSlot.getResource(), allowedAlternatives);
                ProcessingMatrixInputClientTooltipComponent cached = this.processingMatrixInputTooltipCache.computeIfAbsent((Pair<PlatformResourceKey, Set<class_2960>>)cacheKey, k -> new ProcessingMatrixInputClientTooltipComponent((PlatformResourceKey)k.getFirst(), (Set)k.getSecond()));
                tooltip.add(cached);
            }
        }
        super.addResourceSlotTooltips(resourceSlot, tooltip);
    }

    @Override
    protected class_437 createResourceAmountScreen(ResourceSlot slot) {
        ProcessingMatrixResourceSlot matrixSlot;
        if (slot instanceof ProcessingMatrixResourceSlot && (matrixSlot = (ProcessingMatrixResourceSlot)slot).isInput()) {
            return new AlternativesScreen((class_437)this, this.playerInventory, ((PatternGridContainerMenu)this.method_17577()).getAllowedAlternatives(matrixSlot.method_34266()), slot);
        }
        return super.createResourceAmountScreen(slot);
    }

    @Override
    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        if (this.renderer != null) {
            this.renderer.renderLabels(graphics, this.field_22793, mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        boolean clickedInRecipe;
        boolean bl = clickedInRecipe = this.renderer != null && this.renderer.mouseClicked(mouseX, mouseY, clickedButton);
        if (clickedInRecipe) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    @Override
    public void method_16014(double mx, double my) {
        if (this.renderer != null) {
            this.renderer.mouseMoved(mx, my);
        }
        super.method_16014(mx, my);
    }

    @Override
    public boolean method_25406(double mx, double my, int button) {
        return this.renderer != null && this.renderer.mouseReleased(mx, my, button) || super.method_25406(mx, my, button);
    }

    @Override
    public boolean method_25401(double x, double y, double z, double delta) {
        return this.renderer != null && this.renderer.mouseScrolled(x, y, z, delta) || super.method_25401(x, y, z, delta);
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        this.patternTypeButtons.values().forEach(button -> button.setSelected(false));
        this.patternTypeButtons.get((Object)newPatternType).setSelected(true);
        if (this.renderer != null) {
            this.renderer.patternTypeChanged(newPatternType);
        }
        this.renderer = Objects.requireNonNull(this.renderers.get((Object)newPatternType));
        this.renderer.patternTypeChanged(newPatternType);
        if (this.clearButton != null) {
            this.clearButton.method_48229(this.renderer.getClearButtonX(), this.renderer.getClearButtonY());
        }
    }

    @Override
    public void fuzzyModeChanged(boolean newFuzzyMode) {
        if (this.renderer != null) {
            this.renderer.fuzzyModeChanged(newFuzzyMode);
        }
    }

    private int getInsetX() {
        return this.field_2776 + 8;
    }

    private int getInsetY() {
        return this.field_2800 + this.field_2779 - this.bottomHeight + 5;
    }

    @Override
    public boolean canDisplayOutput(class_1799 stack) {
        return ((PatternGridContainerMenu)this.method_17577()).isPatternInOutput(stack);
    }
}

