/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

class ProcessingMatrixInputClientTooltipComponent
implements class_5684 {
    private static final long CYCLE_MS = 1000L;
    private static final class_5250 ALLOWED_ALTERNATIVES = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.allowed_alternatives").method_27692(class_124.field_1054);
    private static final int PADDING = 2;
    private final List<ResourceTag> allowedAlternatives;
    private final int width;
    private final int height;
    private final List<class_2561> names;
    private long cycleStart = 0L;
    private int currentCycle = 0;

    ProcessingMatrixInputClientTooltipComponent(PlatformResourceKey resource, Set<class_2960> allowedAlternativeIds) {
        this.allowedAlternatives = resource.getTags().stream().filter(tag -> allowedAlternativeIds.contains(tag.key().comp_327())).toList();
        this.names = this.allowedAlternatives.stream().map(ProcessingMatrixInputClientTooltipComponent::getName).toList();
        int totalWidth = 0;
        for (class_2561 name : this.names) {
            totalWidth = Math.max(totalWidth, 20 + class_310.method_1551().field_1772.method_27525((class_5348)name));
        }
        this.width = totalWidth;
        this.height = 11 + 18 * this.allowedAlternatives.size() + 3;
    }

    public void method_32666(class_327 font, int x, int y, class_332 graphics) {
        long now = System.currentTimeMillis();
        if (this.cycleStart == 0L) {
            this.cycleStart = now;
        }
        if (now - this.cycleStart >= 1000L) {
            ++this.currentCycle;
            this.cycleStart = now;
        }
        graphics.method_27535(font, (class_2561)ALLOWED_ALTERNATIVES, x, y, 0xFFFFFF);
        for (int i = 0; i < this.allowedAlternatives.size(); ++i) {
            ResourceTag alternative = this.allowedAlternatives.get(i);
            PlatformResourceKey resource = alternative.resources().get(this.currentCycle % alternative.resources().size());
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
            rendering.render(resource, graphics, x, y + 9 + 2 + i * 18);
            graphics.method_27535(font, this.names.get(i), x + 18 + 2, y + 9 + 2 + i * 18 + 9 - 4, 0xAAAAAA);
        }
    }

    public int method_32661() {
        return this.height;
    }

    public int method_32664(class_327 font) {
        return this.width;
    }

    private static class_2561 getName(ResourceTag alternative) {
        String translationKey = IdentifierUtil.getTagTranslationKey(alternative.key());
        boolean hasTranslation = class_1074.method_4663((String)translationKey);
        return hasTranslation ? class_2561.method_43471((String)translationKey) : class_2561.method_43470((String)alternative.key().comp_327().toString());
    }
}

