/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToLongFunction;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

class ProcessingMatrixInputResourceContainer
extends ResourceContainerImpl {
    private static final String TAG_ALLOWED_TAG_IDS = "allowedTagIds";
    private static final String TAG_INDEX = "index";
    private static final String TAG_IDS = "ids";
    private final List<@NullableType Set<class_2960>> allowedTagIds;

    ProcessingMatrixInputResourceContainer(int size, ToLongFunction<ResourceKey> maxAmountProvider, ResourceFactory primaryResourceFactory, Set<ResourceFactory> alternativeResourceFactories) {
        super(size, maxAmountProvider, primaryResourceFactory, alternativeResourceFactories);
        this.allowedTagIds = new ArrayList<Set<class_2960>>(size);
        for (int i = 0; i < size; ++i) {
            this.allowedTagIds.add(null);
        }
    }

    void set(int index, ProcessingPatternState.ProcessingIngredient processingIngredient) {
        this.setSilently(index, processingIngredient.input());
        this.allowedTagIds.set(index, new HashSet<class_2960>(processingIngredient.allowedAlternativeIds()));
        this.changed();
    }

    Optional<ProcessingPatternState.ProcessingIngredient> getIngredient(int index) {
        return Optional.ofNullable(this.get(index)).map(input -> this.getIngredient(index, (ResourceAmount)input));
    }

    private ProcessingPatternState.ProcessingIngredient getIngredient(int index, ResourceAmount input) {
        ArrayList ids = this.allowedTagIds.get(index) == null ? Collections.emptyList() : new ArrayList(this.allowedTagIds.get(index));
        return new ProcessingPatternState.ProcessingIngredient(input, ids);
    }

    Set<class_2960> getAllowedTagIds(int index) {
        return Collections.unmodifiableSet(Objects.requireNonNullElse(this.allowedTagIds.get(index), Collections.emptySet()));
    }

    void setAllowedTagIds(int index, Set<class_2960> ids) {
        if (index < 0 || index >= this.allowedTagIds.size()) {
            return;
        }
        this.allowedTagIds.set(index, ids);
        this.changed();
    }

    @Override
    protected void setSilently(int index, ResourceAmount resourceAmount) {
        super.setSilently(index, resourceAmount);
        this.allowedTagIds.set(index, new HashSet());
    }

    @Override
    protected void removeSilently(int index) {
        super.removeSilently(index);
        this.allowedTagIds.set(index, null);
    }

    @Override
    public void fromTag(class_2487 tag, class_7225.class_7874 provider) {
        super.fromTag(tag, provider);
        if (!tag.method_10545(TAG_ALLOWED_TAG_IDS)) {
            return;
        }
        class_2499 allowedTagIdsTag = tag.method_10554(TAG_ALLOWED_TAG_IDS, 10);
        for (int i = 0; i < allowedTagIdsTag.size(); ++i) {
            class_2487 allowedTagEntry = allowedTagIdsTag.method_10602(i);
            int index = allowedTagEntry.method_10550(TAG_INDEX);
            class_2499 idsTag = allowedTagEntry.method_10554(TAG_IDS, 8);
            HashSet<class_2960> ids = new HashSet<class_2960>();
            for (int j = 0; j < idsTag.size(); ++j) {
                ids.add(class_2960.method_60654((String)idsTag.method_10608(j)));
            }
            this.allowedTagIds.set(index, ids);
        }
    }

    @Override
    public class_2487 toTag(class_7225.class_7874 provider) {
        class_2487 tag = super.toTag(provider);
        class_2499 allowedTagIdsTag = new class_2499();
        for (int i = 0; i < this.allowedTagIds.size(); ++i) {
            Set<class_2960> ids = this.allowedTagIds.get(i);
            if (ids == null) continue;
            class_2487 allowedTagEntry = new class_2487();
            allowedTagEntry.method_10569(TAG_INDEX, i);
            class_2499 idsTag = new class_2499();
            for (class_2960 id : ids) {
                idsTag.add((Object)class_2519.method_23256((String)id.toString()));
            }
            allowedTagEntry.method_10566(TAG_IDS, (class_2520)idsTag);
            allowedTagIdsTag.add((Object)allowedTagEntry);
        }
        tag.method_10566(TAG_ALLOWED_TAG_IDS, (class_2520)allowedTagIdsTag);
        return tag;
    }
}

