/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputResourceContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessingMatrixResourceSlot
extends ResourceSlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingMatrixResourceSlot.class);
    private static final class_2561 CLICK_TO_CONFIGURE_AMOUNT_AND_ALTERNATIVES = IdentifierUtil.createTranslationAsHeading("gui", "pattern_grid.processing.click_to_configure_amount_and_alternatives");
    private static final class_5250 INPUT_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.input_slots_help");
    private static final class_5250 OUTPUT_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.output_slots_help");
    private final Supplier<PatternType> patternTypeSupplier;
    private final boolean input;
    private final int startY;
    private final int endY;
    private Set<class_2960> cachedAllowedAlternatives;

    ProcessingMatrixResourceSlot(ResourceContainer resourceContainer, int index, int x, int y, boolean input, Supplier<PatternType> patternTypeSupplier, Pair<Integer, Integer> startEndY) {
        super(resourceContainer, index, (class_2561)(input ? INPUT_HELP : OUTPUT_HELP), x, y, ResourceSlotType.FILTER_WITH_AMOUNT);
        Set<Object> set;
        this.patternTypeSupplier = patternTypeSupplier;
        if (resourceContainer instanceof ProcessingMatrixInputResourceContainer) {
            ProcessingMatrixInputResourceContainer inputResourceContainer = (ProcessingMatrixInputResourceContainer)resourceContainer;
            set = inputResourceContainer.getAllowedTagIds(index);
        } else {
            set = Collections.emptySet();
        }
        this.cachedAllowedAlternatives = set;
        this.input = input;
        this.startY = (Integer)startEndY.getLeft();
        this.endY = (Integer)startEndY.getRight();
    }

    @Override
    public boolean broadcastChanges(class_1657 player) {
        boolean resourceChanged = super.broadcastChanges(player);
        ResourceContainer resourceContainer = this.resourceContainer;
        if (resourceContainer instanceof ProcessingMatrixInputResourceContainer) {
            ProcessingMatrixInputResourceContainer inputResourceContainer = (ProcessingMatrixInputResourceContainer)resourceContainer;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.checkAllowedAlternativesChanged(inputResourceContainer, serverPlayer, resourceChanged);
            }
        }
        return resourceChanged;
    }

    private void checkAllowedAlternativesChanged(ProcessingMatrixInputResourceContainer container, class_3222 serverPlayer, boolean resourceChanged) {
        Set<class_2960> currentAllowedAlternatives = container.getAllowedTagIds(this.method_34266());
        if (!currentAllowedAlternatives.equals(this.cachedAllowedAlternatives) || resourceChanged) {
            LOGGER.debug("Re-sending alternatives for resource slot {}", (Object)this.method_34266());
            this.cachedAllowedAlternatives = new HashSet<class_2960>(currentAllowedAlternatives);
            S2CPackets.sendPatternGridAllowedAlternativesUpdate(serverPlayer, this.method_34266(), currentAllowedAlternatives);
        }
    }

    boolean isInput() {
        return this.input;
    }

    public boolean method_7682() {
        PatternType patternType = this.patternTypeSupplier.get();
        return patternType == PatternType.PROCESSING && this.field_7872 >= this.startY && this.field_7872 < this.endY;
    }

    public boolean method_51306() {
        return false;
    }

    @Override
    public class_2561 getClickToConfigureAmountHelpTooltip() {
        if (this.input) {
            return CLICK_TO_CONFIGURE_AMOUNT_AND_ALTERNATIVES;
        }
        return super.getClickToConfigureAmountHelpTooltip();
    }
}

