/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.autocrafting.VanillaConstants;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8052;
import net.minecraft.class_8064;
import org.joml.Quaternionf;
import org.joml.Vector3f;

class SmithingTablePatternGridRenderer
implements PatternGridRenderer {
    private static final class_2960 SPRITE = IdentifierUtil.createIdentifier("pattern_grid/smithing_table");
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int topPos;
    private final int x;
    private final int y;
    private final class_8064 templateIcon;
    private final class_8064 baseIcon;
    private final class_8064 additionalIcon;
    @Nullable
    private class_1531 preview;
    private class_1799 result = class_1799.field_8037;

    SmithingTablePatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int topPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.x = x;
        this.y = y;
        this.templateIcon = new class_8064(menu.getFirstSmithingTableSlotIndex());
        this.baseIcon = new class_8064(menu.getFirstSmithingTableSlotIndex() + 1);
        this.additionalIcon = new class_8064(menu.getFirstSmithingTableSlotIndex() + 2);
    }

    @Override
    public void addWidgets(Consumer<class_339> widgets, Consumer<class_339> renderables) {
        class_1937 level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return;
        }
        this.preview = new class_1531(level, 0.0, 0.0, 0.0);
        this.preview.method_6907(true);
        this.preview.method_6913(true);
        this.preview.field_6283 = 210.0f;
        this.preview.method_36457(25.0f);
        this.preview.field_6241 = this.preview.method_36454();
        this.preview.field_6259 = this.preview.method_36454();
        this.result = this.menu.getSmithingTableResult().method_7972();
        this.updatePreview();
    }

    @Override
    public void tick() {
        class_1799 currentResult = this.menu.getSmithingTableResult();
        if (!class_1799.method_31577((class_1799)currentResult, (class_1799)this.result)) {
            this.result = currentResult.method_7972();
            this.updatePreview();
        }
        Optional<class_8052> templateItem = this.menu.getSmithingTableTemplateItem();
        this.templateIcon.method_48471(VanillaConstants.EMPTY_SLOT_SMITHING_TEMPLATES);
        this.baseIcon.method_48471(templateItem.map(class_8052::method_48423).orElse(List.of()));
        this.additionalIcon.method_48471(templateItem.map(class_8052::method_48413).orElse(List.of()));
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 112;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 26;
    }

    @Override
    public void renderBackground(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.method_44379(this.x, this.y, this.x + 138, this.y + 71);
        graphics.method_52706(SPRITE, this.x + 4, this.y + 26, 98, 18);
        this.renderIcons(graphics, partialTicks);
        if (this.preview != null) {
            class_490.method_48472((class_332)graphics, (float)((float)this.x + 128.0f), (float)((float)this.y + 52.0f), (float)25.0f, (Vector3f)VanillaConstants.ARMOR_STAND_TRANSLATION, (Quaternionf)VanillaConstants.ARMOR_STAND_ANGLE, null, (class_1309)this.preview);
        }
        graphics.method_44380();
    }

    private void renderIcons(class_332 graphics, float partialTicks) {
        this.templateIcon.method_48469((class_1703)this.menu, graphics, partialTicks, this.leftPos, this.topPos);
        this.baseIcon.method_48469((class_1703)this.menu, graphics, partialTicks, this.leftPos, this.topPos);
        this.additionalIcon.method_48469((class_1703)this.menu, graphics, partialTicks, this.leftPos, this.topPos);
    }

    @Override
    public void renderTooltip(class_327 font, @Nullable class_1735 hoveredSlot, class_332 graphics, int mouseX, int mouseY) {
        if (hoveredSlot == null || hoveredSlot.method_7681()) {
            return;
        }
        int firstSlotIndex = this.menu.getFirstSmithingTableSlotIndex();
        this.menu.getSmithingTableTemplateItem().ifPresentOrElse(template -> {
            if (hoveredSlot.field_7874 == firstSlotIndex + 1) {
                graphics.method_51447(font, SmithingTablePatternGridRenderer.split(font, template.method_48421()), mouseX, mouseY);
            } else if (hoveredSlot.field_7874 == firstSlotIndex + 2) {
                graphics.method_51447(font, SmithingTablePatternGridRenderer.split(font, template.method_48422()), mouseX, mouseY);
            }
        }, () -> {
            if (hoveredSlot.field_7874 == firstSlotIndex) {
                graphics.method_51447(font, SmithingTablePatternGridRenderer.split(font, VanillaConstants.MISSING_SMITHING_TEMPLATE_TOOLTIP), mouseX, mouseY);
            }
        });
    }

    private static List<class_5481> split(class_327 font, class_2561 template) {
        return font.method_1728((class_5348)template, 115);
    }

    private void updatePreview() {
        if (this.preview == null) {
            return;
        }
        for (class_1304 equipmentslot : class_1304.values()) {
            this.preview.method_5673(equipmentslot, class_1799.field_8037);
        }
        if (this.result.method_7960()) {
            return;
        }
        class_1792 class_17922 = this.result.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            this.preview.method_5673(armorItem.method_7685(), this.result);
        } else {
            this.preview.method_5673(class_1304.field_6171, this.result);
        }
    }
}

