/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.autocrafting.VanillaConstants;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3975;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

class StonecutterPatternGridRenderer
implements PatternGridRenderer {
    private static final class_2960 SPRITE = IdentifierUtil.createIdentifier("pattern_grid/stonecutter");
    @Nullable
    private ScrollbarWidget scrollbar;
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int x;
    private final int y;

    StonecutterPatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.x = x;
        this.y = y;
    }

    @Override
    public void addWidgets(Consumer<class_339> widgets, Consumer<class_339> renderables) {
        this.scrollbar = StonecutterPatternGridRenderer.createStonecutterScrollbar(this.menu, this.x, this.y);
        this.updateScrollbarMaxOffset();
        widgets.accept(this.scrollbar);
    }

    private static ScrollbarWidget createStonecutterScrollbar(PatternGridContainerMenu menu, int x, int y) {
        ScrollbarWidget scrollbar = new ScrollbarWidget(x + 107, y + 9, ScrollbarWidget.Type.NORMAL, 54);
        scrollbar.field_22764 = StonecutterPatternGridRenderer.isScrollbarVisible(menu);
        return scrollbar;
    }

    private void updateScrollbarMaxOffset() {
        if (this.scrollbar == null) {
            return;
        }
        int items = this.menu.getStonecutterRecipes().size();
        int rows = Math.ceilDiv(items, 4);
        int maxOffset = rows - 3;
        int maxOffsetCorrected = maxOffset * (this.scrollbar.isSmoothScrolling() ? 18 : 1);
        this.scrollbar.setMaxOffset(maxOffsetCorrected);
        this.scrollbar.setEnabled(maxOffsetCorrected > 0);
    }

    @Override
    public void tick() {
        this.updateScrollbarMaxOffset();
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scrollbar != null) {
            this.scrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 130;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 8;
    }

    @Override
    public void renderBackground(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.method_52706(SPRITE, this.x + 4, this.y + 4 + 4, 116, 56);
        graphics.method_44379(this.x + 40, this.y + 9, this.x + 40 + 64, this.y + 9 + 54);
        boolean isOverArea = this.isOverStonecutterArea(mouseX, mouseY);
        for (int i = 0; i < this.menu.getStonecutterRecipes().size(); ++i) {
            boolean hovering;
            class_8786<class_3975> recipe = this.menu.getStonecutterRecipes().get(i);
            int xx = this.getRecipeX(this.x, i);
            int row = i / 4;
            int yy = this.getRecipeY(this.y, row);
            if (yy < this.y + 9 - 18 || yy > this.y + 9 + 54) continue;
            boolean bl = hovering = mouseX >= xx && mouseY >= yy && mouseX < xx + 16 && mouseY < yy + 18;
            class_2960 buttonSprite = i == this.menu.getStonecutterSelectedRecipe() ? VanillaConstants.STONECUTTER_RECIPE_SELECTED_SPRITE : (isOverArea && hovering ? VanillaConstants.STONECUTTER_RECIPE_HIGHLIGHTED_SPRITE : VanillaConstants.STONECUTTER_RECIPE_SPRITE);
            graphics.method_52706(buttonSprite, xx, yy, 16, 18);
            graphics.method_51427(((class_3975)recipe.comp_1933()).method_8110((class_7225.class_7874)Objects.requireNonNull(ClientPlatformUtil.getClientLevel()).method_30349()), xx, yy + 1);
        }
        graphics.method_44380();
    }

    @Override
    public void renderTooltip(class_327 font, @Nullable class_1735 hoveredSlot, class_332 graphics, int mouseX, int mouseY) {
        if (!this.isOverStonecutterArea(mouseX, mouseY)) {
            return;
        }
        for (int i = 0; i < this.menu.getStonecutterRecipes().size(); ++i) {
            class_8786<class_3975> recipe = this.menu.getStonecutterRecipes().get(i);
            class_1799 result = ((class_3975)recipe.comp_1933()).method_8110((class_7225.class_7874)Objects.requireNonNull(ClientPlatformUtil.getClientLevel()).method_30349());
            int xx = this.getRecipeX(this.x, i);
            int row = i / 4;
            int yy = this.getRecipeY(this.y, row);
            if (yy < this.y + 9 - 18 || yy > this.y + 9 + 54 || mouseX < xx || mouseY < yy || mouseX >= xx + 16 || mouseY >= yy + 18) continue;
            graphics.method_51446(font, result, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        return this.scrollbar != null && this.scrollbar.method_25402(mouseX, mouseY, clickedButton) || this.clickedRecipe(mouseX, mouseY);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.method_16014(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollbar != null && this.scrollbar.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        return this.isOverStonecutterArea(mouseX, mouseY) && this.scrollbar != null && this.scrollbar.method_37303() && this.scrollbar.method_25401(mouseX, mouseY, mouseZ, delta);
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        if (this.scrollbar != null) {
            this.scrollbar.field_22764 = StonecutterPatternGridRenderer.isScrollbarVisible(this.menu);
        }
    }

    private static boolean isScrollbarVisible(PatternGridContainerMenu menu) {
        return menu.getPatternType() == PatternType.STONECUTTER;
    }

    private boolean clickedRecipe(double mouseX, double mouseY) {
        if (!this.isOverStonecutterArea(mouseX, mouseY)) {
            return false;
        }
        for (int i = 0; i < this.menu.getStonecutterRecipes().size(); ++i) {
            int xx = this.getRecipeX(this.x, i);
            int row = i / 4;
            int yy = this.getRecipeY(this.y, row);
            if (yy < this.y + 9 - 18 || yy > this.y + 9 + 54 || !(mouseX >= (double)xx) || !(mouseY >= (double)yy) || !(mouseX < (double)(xx + 16)) || !(mouseY < (double)(yy + 18))) continue;
            this.menu.setStonecutterSelectedRecipe(i);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
            return true;
        }
        return false;
    }

    private boolean isOverStonecutterArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + 40) && mouseX < (double)(this.x + 40 + 81) && mouseY > (double)(this.y + 8) && mouseY < (double)(this.y + 8 + 56);
    }

    private int getRecipeX(int insetX, int i) {
        return insetX + 40 + i % 4 * 16;
    }

    private int getRecipeY(int insetY, int row) {
        return insetY + 9 + row * 18 - (this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0) * (this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? 1 : 18);
    }
}

