/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewItem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewListener;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewStyle;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequestButton;
import com.refinedmods.refinedstorage.common.autocrafting.preview.FullscreenTreePreviewScreen;
import com.refinedmods.refinedstorage.common.autocrafting.preview.TreePreviewWidget;
import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.ActionIcon;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.ImageButton;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import org.joml.Vector3f;

public class AutocraftingPreviewScreen
extends AbstractAmountScreen<AutocraftingPreviewContainerMenu, Double>
implements AutocraftingPreviewListener {
    static final int REQUEST_BUTTON_HEIGHT = 24;
    static final int REQUEST_BUTTON_WIDTH = 64;
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafting_preview.png");
    private static final class_5250 TITLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.title");
    private static final class_5250 START = IdentifierUtil.createTranslation("gui", "autocrafting_preview.start");
    private static final class_5250 PENDING = IdentifierUtil.createTranslation("gui", "autocrafting_preview.pending");
    private static final class_5250 CANCELLING = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cancelling");
    private static final class_5250 CANCELLING_FORCE_CLOSE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cancelling.force_close");
    private static final class_5250 MAX = IdentifierUtil.createTranslation("gui", "autocrafting_preview.max");
    private static final class_5250 MAX_HELP = IdentifierUtil.createTranslation("gui", "autocrafting_preview.max.help");
    private static final class_5250 NOTIFY = IdentifierUtil.createTranslation("gui", "autocrafting_preview.notify");
    private static final class_5250 NOTIFY_HELP = IdentifierUtil.createTranslation("gui", "autocrafting_preview.notify.help");
    private static final class_5250 MISSING_RESOURCES = IdentifierUtil.createTranslation("gui", "autocrafting_preview.start.missing_resources");
    private static final class_5250 CYCLE_DETECTED = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    private static final class_5250 CYCLE_OUTPUTS = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected.outputs");
    private static final class_5250 BREAK_THE_CYCLE_AND_TRY_AGAIN = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected.break_the_cycle_and_try_again");
    private static final class_5250 REQUEST_TOO_LARGE_TO_HANDLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_too_large_to_handle").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    private static final class_5250 TRY_SMALLER_AMOUNT = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_too_large_to_handle.try_smaller_amount");
    private static final class_5250 REQUEST_CANCELLED = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_cancelled").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    private static final class_5250 TOO_MANY_SUBCOMPONENTS = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_cancelled.too_many_subcomponents");
    private static final class_5250 CRAFT_SUBCOMPONENTS_AND_TRY_AGAIN = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_cancelled.craft_subcomponents_and_try_again");
    private static final class_5250 NOT_AVAILABLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.not_available");
    private static final class_5250 ZOOM = IdentifierUtil.createTranslation("gui", "autocrafting_preview.zoom");
    private static final class_2960 ROW = IdentifierUtil.createIdentifier("autocrafting_preview/row");
    private static final class_2960 CRAFTING_REQUESTS = IdentifierUtil.createIdentifier("autocrafting_preview/requests");
    private static final class_2960 LIST_PREVIEW = IdentifierUtil.createIdentifier("autocrafting_preview/list_preview");
    private static final class_2960 TREE_PREVIEW = IdentifierUtil.createIdentifier("autocrafting_preview/tree_preview");
    private static final class_2960 TREE_PREVIEW_VIGNETTE = IdentifierUtil.createIdentifier("autocrafting_preview/tree_preview_vignette");
    private static final class_2960 LIST_ICON = IdentifierUtil.createIdentifier("widget/autocrafting_list_preview");
    private static final class_2960 TREE_ICON = IdentifierUtil.createIdentifier("widget/autocrafting_tree_preview");
    private static final class_2960 ZOOM_ICON = IdentifierUtil.createIdentifier("widget/autocrafting_zoom_tree_preview");
    private static final int ROWS_VISIBLE = 4;
    private static final int COLUMNS = 3;
    private static final int PREVIEW_AREA_WIDTH = 241;
    private static final int PREVIEW_AREA_HEIGHT = 121;
    private static final int PREVIEW_AREA_CONTENTS_LIST_WIDTH = 221;
    private static final int PREVIEW_AREA_CONTENTS_TREE_WIDTH = 239;
    private static final int PREVIEW_AREA_CONTENTS_HEIGHT = 119;
    private static final int ROW_HEIGHT = 30;
    private static final int ROW_WIDTH = 221;
    private static final int CELL_WIDTH = 73;
    private static final int CELL_HEIGHT = 29;
    private static final int REQUESTS_WIDTH = 91;
    private static final int REQUESTS_HEIGHT = 111;
    private static final int REQUESTS_INNER_WIDTH = 64;
    private static final int REQUESTS_INNER_HEIGHT = 96;
    private static final int REQUESTS_VISIBLE = 4;
    private static final int ITEM_COLOR = -2368549;
    private static final int MISSING_COLOR = -860450;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private ScrollbarWidget requestButtonsScrollbar;
    @Nullable
    private class_4185 maxButton;
    @Nullable
    private CheckboxWidget notifyCheckbox;
    @Nullable
    private class_4185 zoomButton;
    @Nullable
    private TreePreviewWidget tree;
    private final List<AutocraftingRequestButton> requestButtons = new ArrayList<AutocraftingRequestButton>();
    private final boolean requestsButtonsVisible;
    private final RateLimiter requestRateLimiter = RateLimiter.create((double)1.0);
    private final RateLimiter maxAmountRequestRateLimiter = RateLimiter.create((double)0.2);
    @Nullable
    private Double changedAmount;
    private boolean mayEnableMaxAmountRequestButtonAgain;
    private boolean requestedCancellation;

    public AutocraftingPreviewScreen(class_437 parent, class_1661 playerInventory, List<AutocraftingRequest> requests) {
        this(new AutocraftingPreviewContainerMenu(requests), parent, playerInventory);
    }

    public AutocraftingPreviewScreen(AutocraftingPreviewContainerMenu menu, class_1661 playerInventory) {
        this(menu, null, playerInventory);
    }

    public AutocraftingPreviewScreen(AutocraftingPreviewContainerMenu menu, @Nullable class_437 parent, class_1661 playerInventory) {
        super(menu, parent, playerInventory, (class_2561)TITLE, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(1.0).withIncrementsTop(1, 10, 64).withIncrementsTopStartPosition(new Vector3f(80.0f, 20.0f, 0.0f)).withIncrementsBottom(-1, -10, -64).withIncrementsBottomStartPosition(new Vector3f(80.0f, 71.0f, 0.0f)).withAmountFieldPosition(new Vector3f(77.0f, 51.0f, 0.0f)).withActionButtonsStartPosition(new Vector3f(7.0f, 222.0f, 0.0f)).withHorizontalActionButtons(true).withMinAmount(menu::getMinAmount).withResetAmount(1.0).withConfirmButtonText((class_2561)START).build(), DoubleAmountOperations.INSTANCE);
        this.field_2792 = 254;
        this.field_2779 = 249;
        this.requestsButtonsVisible = ((AutocraftingPreviewContainerMenu)this.method_17577()).getRequests().size() > 1;
        ((AutocraftingPreviewContainerMenu)this.method_17577()).setListener(this);
    }

    @Override
    protected void method_25426() {
        boolean wasAlreadyInitialized = this.amountField != null;
        super.method_25426();
        this.scrollbar = new ScrollbarWidget(this.field_2776 + 235, this.field_2800 + 98, ScrollbarWidget.Type.NORMAL, 119);
        this.scrollbar.field_22764 = false;
        this.scrollbar.setEnabled(false);
        if (this.requestsButtonsVisible) {
            this.initRequestButtons();
        }
        if (this.confirmButton != null) {
            this.disableStartButton();
        }
        if (!wasAlreadyInitialized) {
            ((AutocraftingPreviewContainerMenu)this.method_17577()).loadCurrentRequest();
        }
        boolean wasActive = this.maxButton == null || this.maxButton.field_22763;
        this.maxButton = class_4185.method_46430((class_2561)MAX, this::requestMaxAmount).method_46437(22, 15).method_46433(this.field_2776 + 185 - 1, this.field_2800 + 49 - 1).method_46431();
        this.maxButton.field_22763 = wasActive;
        this.method_37063((class_364)this.maxButton);
        this.tree = new TreePreviewWidget((class_437)this, this.field_2776 + 8, this.field_2800 + 98, 239, 119);
        this.zoomButton = new ImageButton(this.field_2776 + this.field_2792 - 6 - 16, this.field_2800 + 97 - 16, ZOOM_ICON, btn -> this.zoom());
        this.zoomButton.method_47400(class_7919.method_47407((class_2561)ZOOM));
        this.zoomButton.field_22763 = false;
        this.method_37063((class_364)this.zoomButton);
        AutocraftingPreviewStyle currentStyle = ((AutocraftingPreviewContainerMenu)this.field_2797).getStyle();
        ImageButton styleButton = new ImageButton(this.field_2776 + this.field_2792 - 6 - 16 - 16, this.field_2800 + 97 - 16, currentStyle == AutocraftingPreviewStyle.LIST ? TREE_ICON : LIST_ICON, this::toggleStyle);
        this.method_37063((class_364)styleButton);
        this.updateStyle(styleButton, currentStyle);
        boolean selected = this.notifyCheckbox == null ? ((AutocraftingPreviewContainerMenu)this.field_2797).isNotify() : this.notifyCheckbox.isSelected();
        this.notifyCheckbox = new CheckboxWidget(this.field_2776 + this.field_2792 - this.field_22793.method_27525((class_5348)NOTIFY) - 4 - 9 - 6, this.field_2800 + 222 + 6, (class_2561)NOTIFY, class_310.method_1551().field_1772, selected, CheckboxWidget.Size.SMALL);
        this.notifyCheckbox.setHelpTooltip((class_2561)NOTIFY_HELP);
        this.notifyCheckbox.setOnPressed((checkbox, notify) -> ((AutocraftingPreviewContainerMenu)this.field_2797).setNotify(notify));
        this.method_37063((class_364)this.notifyCheckbox);
        this.getExclusionZones().add(new class_768(this.field_2776 - 91 + 4, this.field_2800, 91, 111));
    }

    private void zoom() {
        TreePreview treePreview = ((AutocraftingPreviewContainerMenu)this.method_17577()).getCurrentRequest().getTreePreview();
        if (treePreview == null || treePreview.rootNode() == null) {
            return;
        }
        class_310.method_1551().method_1507((class_437)new FullscreenTreePreviewScreen((class_437)this, treePreview));
    }

    private void toggleStyle(ImageButton btn) {
        this.getAndValidateAmount().ifPresent(amount -> {
            AutocraftingPreviewStyle newStyle = ((AutocraftingPreviewContainerMenu)this.method_17577()).toggleStyle((double)amount);
            this.updateStyle(btn, newStyle);
        });
    }

    private void updateStyle(ImageButton btn, AutocraftingPreviewStyle newStyle) {
        btn.method_47400(class_7919.method_47407((class_2561)(newStyle == AutocraftingPreviewStyle.TREE ? AutocraftingPreviewStyle.LIST.getName() : AutocraftingPreviewStyle.TREE.getName())));
        btn.setSprite(newStyle == AutocraftingPreviewStyle.TREE ? LIST_ICON : TREE_ICON);
        if (this.scrollbar == null || this.zoomButton == null) {
            return;
        }
        this.scrollbar.field_22764 = newStyle == AutocraftingPreviewStyle.LIST;
        this.zoomButton.field_22763 = false;
    }

    @Override
    @Nullable
    protected ActionIcon getConfirmButtonIcon() {
        return null;
    }

    private void requestMaxAmount(class_4185 button) {
        button.field_22763 = false;
        ((AutocraftingPreviewContainerMenu)this.method_17577()).requestMaxAmount();
    }

    private void initRequestButtons() {
        this.requestButtons.clear();
        this.requestButtonsScrollbar = new ScrollbarWidget(this.field_2776 - 17 + 4, this.getRequestButtonsInnerY(), ScrollbarWidget.Type.NORMAL, 96);
        this.requestButtonsScrollbar.setListener(value -> {
            int scrollOffset = this.requestButtonsScrollbar.isSmoothScrolling() ? (int)this.requestButtonsScrollbar.getOffset() : (int)this.requestButtonsScrollbar.getOffset() * 24;
            for (int i = 0; i < this.requestButtons.size(); ++i) {
                AutocraftingRequestButton requestButton = this.requestButtons.get(i);
                int y = this.getCraftingRequestButtonY(i) - scrollOffset;
                requestButton.method_46419(y);
                requestButton.field_22764 = this.isCraftingRequestButtonVisible(y);
            }
        });
        this.updateRequestsScrollbar();
        for (int i = 0; i < ((AutocraftingPreviewContainerMenu)this.method_17577()).getRequests().size(); ++i) {
            AutocraftingRequest request = ((AutocraftingPreviewContainerMenu)this.method_17577()).getRequests().get(i);
            int buttonY = this.getCraftingRequestButtonY(i);
            AutocraftingRequestButton button = new AutocraftingRequestButton(this.getRequestButtonsInnerX(), buttonY, request, this::changeCurrentRequest);
            button.field_22764 = this.isCraftingRequestButtonVisible(buttonY);
            this.requestButtons.add((AutocraftingRequestButton)this.method_25429((class_364)button));
        }
    }

    private boolean isCraftingRequestButtonVisible(int y) {
        int innerY = this.getRequestButtonsInnerY();
        return y >= innerY - 24 && y <= innerY + 96;
    }

    private int getCraftingRequestButtonY(int i) {
        return this.getRequestButtonsInnerY() + i * 24;
    }

    private void changeCurrentRequest(AutocraftingRequest request) {
        ((AutocraftingPreviewContainerMenu)this.method_17577()).setCurrentRequest(request);
    }

    private void setRequest(AutocraftingRequest request) {
        for (AutocraftingRequestButton requestButton : this.requestButtons) {
            requestButton.field_22763 = requestButton.getRequest() != request;
        }
        this.updateAmount(request.getAmount());
        this.setPreview(request.getPreview(), request.getTreePreview());
    }

    private void setPreview(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (this.scrollbar == null || this.tree == null || this.zoomButton == null) {
            return;
        }
        this.tree.update(treePreview);
        this.zoomButton.field_22763 = this.tree.hasContents();
        this.updateConfirmButton(preview, treePreview);
        if (preview == null && treePreview == null) {
            this.scrollbar.setEnabled(false);
            this.scrollbar.setMaxOffset(0.0);
            this.disableStartButton();
        } else if (preview != null) {
            int items = preview.items().size();
            int rows = Math.ceilDiv(items, 3) - 4;
            this.scrollbar.setMaxOffset(this.scrollbar.isSmoothScrolling() ? (double)(rows * 30) : (double)rows);
            this.scrollbar.setEnabled(rows > 0);
        }
    }

    private void updateConfirmButton(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.method_25355((class_2561)START);
        boolean success = preview != null && preview.type() == PreviewType.SUCCESS || treePreview != null && treePreview.type() == PreviewType.SUCCESS;
        boolean missingResources = preview != null && preview.type() == PreviewType.MISSING_RESOURCES || treePreview != null && treePreview.type() == PreviewType.MISSING_RESOURCES;
        this.confirmButton.field_22763 = success;
        this.confirmButton.setIcon(success ? ActionIcon.START : ActionIcon.ERROR);
        this.confirmButton.method_47400(missingResources ? class_7919.method_47407((class_2561)MISSING_RESOURCES) : null);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.requestButtonsScrollbar != null) {
            this.requestButtonsScrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.requestsButtonsVisible) {
            int requestsInnerX = this.getRequestButtonsInnerX();
            int requestsInnerY = this.getRequestButtonsInnerY();
            graphics.method_44379(requestsInnerX, requestsInnerY, requestsInnerX + 64, requestsInnerY + 96);
            for (AutocraftingRequestButton requestButton : this.requestButtons) {
                requestButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.method_44380();
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        super.method_2389(graphics, delta, mouseX, mouseY);
        if (this.requestsButtonsVisible) {
            graphics.method_52706(CRAFTING_REQUESTS, this.field_2776 - 91 + 4, this.field_2800, 91, 111);
        }
        int contentsX = this.field_2776 + 8;
        int contentsY = this.field_2800 + 98;
        AutocraftingPreviewStyle style = ((AutocraftingPreviewContainerMenu)this.method_17577()).getStyle();
        this.renderContentsBackground(graphics, style, contentsX, contentsY);
        int contentsWidth = style == AutocraftingPreviewStyle.LIST ? 221 : 239;
        graphics.method_44379(contentsX, contentsY, contentsX + contentsWidth, contentsY + 119);
        this.renderContents(graphics, mouseX, mouseY, style, contentsX, contentsY);
        graphics.method_44380();
    }

    private void renderContentsBackground(class_332 graphics, AutocraftingPreviewStyle style, int contentsX, int contentsY) {
        if (style == AutocraftingPreviewStyle.LIST) {
            graphics.method_52706(LIST_PREVIEW, contentsX - 1, contentsY - 1, 241, 121);
        } else if (style == AutocraftingPreviewStyle.TREE) {
            graphics.method_52706(TREE_PREVIEW, contentsX - 1, contentsY - 1, 241, 121);
        }
    }

    private void renderContents(class_332 graphics, int mouseX, int mouseY, AutocraftingPreviewStyle style, int x, int y) {
        TreePreview treePreview;
        Preview preview = ((AutocraftingPreviewContainerMenu)this.method_17577()).getCurrentRequest().getPreview();
        PreviewType type = this.getType(preview, treePreview = ((AutocraftingPreviewContainerMenu)this.method_17577()).getCurrentRequest().getTreePreview());
        if (type != null && type != PreviewType.SUCCESS && type != PreviewType.MISSING_RESOURCES) {
            this.renderError(graphics, type, y, x, this.getOutputsOfPatternWithCycle(preview, treePreview));
        } else if (style == AutocraftingPreviewStyle.LIST) {
            this.renderListPreview(graphics, mouseX, mouseY, preview, x, y);
        } else if (style == AutocraftingPreviewStyle.TREE) {
            this.renderTreePreview(graphics, mouseX, mouseY, x, y);
        }
    }

    @Nullable
    private PreviewType getType(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (preview != null) {
            return preview.type();
        }
        if (treePreview != null) {
            return treePreview.type();
        }
        return null;
    }

    private List<ResourceAmount> getOutputsOfPatternWithCycle(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (preview != null) {
            return preview.outputsOfPatternWithCycle();
        }
        if (treePreview != null) {
            return treePreview.outputsOfPatternWithCycle();
        }
        return Collections.emptyList();
    }

    private void renderError(class_332 graphics, PreviewType type, int y, int x, List<ResourceAmount> outputsOfPatternWithCycle) {
        if (type == PreviewType.CYCLE_DETECTED) {
            this.renderCycleDetected(graphics, y, x, outputsOfPatternWithCycle);
        } else if (type == PreviewType.OVERFLOW) {
            this.renderRequestTooLargeToHandle(graphics, x, y);
        } else if (type == PreviewType.CANCELLED) {
            this.renderCancelled(graphics, x, y);
        } else if (type == PreviewType.NOT_AVAILABLE) {
            this.renderNotAvailable(graphics, x, y);
        }
    }

    private void renderCycleDetected(class_332 graphics, int y, int x, List<ResourceAmount> outputsOfPatternWithCycle) {
        int yy = y + 4;
        SmallText.render(graphics, this.field_22793, CYCLE_DETECTED.method_30937(), x + 4, yy, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.field_22793, CYCLE_OUTPUTS.method_30937(), x + 4, yy += 10, 0x404040, false, 0.5f);
        yy += 10;
        for (ResourceAmount output : outputsOfPatternWithCycle) {
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(output.resource().getClass());
            rendering.render(output.resource(), graphics, x + 4, yy);
            SmallText.render(graphics, this.field_22793, class_2561.method_43470((String)(output.amount() + "x ")).method_10852(rendering.getDisplayName(output.resource())).method_30937(), x + 4 + 16 + 3, yy + 5, 0x404040, false, 0.5f);
            yy += 18;
        }
        SmallText.render(graphics, this.field_22793, BREAK_THE_CYCLE_AND_TRY_AGAIN.method_30937(), x + 4, yy += 2, 0x404040, false, 0.5f);
    }

    private void renderRequestTooLargeToHandle(class_332 graphics, int x, int y) {
        SmallText.render(graphics, this.field_22793, REQUEST_TOO_LARGE_TO_HANDLE.method_30937(), x + 4, y + 4, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.field_22793, TRY_SMALLER_AMOUNT.method_30937(), x + 4, y + 4 + 10, 0x404040, false, 0.5f);
    }

    private void renderCancelled(class_332 graphics, int x, int y) {
        SmallText.render(graphics, this.field_22793, REQUEST_CANCELLED.method_30937(), x + 4, y + 4, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.field_22793, TOO_MANY_SUBCOMPONENTS.method_30937(), x + 4, y + 4 + 10, 0x404040, false, 0.5f);
        SmallText.render(graphics, this.field_22793, CRAFT_SUBCOMPONENTS_AND_TRY_AGAIN.method_30937(), x + 4, y + 4 + 10 + 10, 0x404040, false, 0.5f);
    }

    private void renderNotAvailable(class_332 graphics, int x, int y) {
        SmallText.render(graphics, this.field_22793, NOT_AVAILABLE.method_30937(), x + 4, y + 4, 0xFF5555, false, 0.5f);
    }

    private void renderListPreview(class_332 graphics, int mouseX, int mouseY, @Nullable Preview preview, int x, int y) {
        if (preview == null) {
            return;
        }
        List<PreviewItem> items = preview.items();
        int rows = Math.ceilDiv(items.size(), 3);
        for (int i = 0; i < rows; ++i) {
            int scrollOffset = this.getScrollOffset();
            int yy = y + i * 30 - scrollOffset;
            this.renderRow(graphics, x, yy, i, items, mouseX, mouseY);
        }
    }

    private int getScrollOffset() {
        if (this.scrollbar == null) {
            return 0;
        }
        return this.scrollbar.isSmoothScrolling() ? (int)this.scrollbar.getOffset() : (int)this.scrollbar.getOffset() * 30;
    }

    private void renderRow(class_332 graphics, int x, int y, int i, List<PreviewItem> items, double mouseX, double mouseY) {
        if (y <= this.field_2800 + 98 - 30 || y > this.field_2800 + 98 + 119) {
            return;
        }
        graphics.method_52706(ROW, x, y, 221, 30);
        for (int column = i * 3; column < Math.min(i * 3 + 3, items.size()); ++column) {
            PreviewItem item = items.get(column);
            int xx = x + column % 3 * 74;
            this.renderCell(graphics, xx, y, item, mouseX, mouseY);
        }
    }

    private void renderCell(class_332 graphics, int x, int y, PreviewItem item, double mouseX, double mouseY) {
        this.renderCellBackground(graphics, x, y, item, mouseX, mouseY);
        int xx = x + 2;
        int yy = y + 7;
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
        rendering.render(item.resource(), graphics, xx, yy);
        if (this.method_2378(xx - this.field_2776, yy - this.field_2800, 16, 16, mouseX, mouseY) && this.isHoveringOverPreviewArea(mouseX, mouseY)) {
            this.method_47414(rendering.getTooltip(item.resource()).stream().map(class_2561::method_30937).toList());
        }
        if (!SmallText.isSmall()) {
            yy -= 2;
        }
        xx += 19;
        if (item.missing() > 0L) {
            this.renderCellText(graphics, "missing", rendering, xx, yy, item.missing());
            yy += 7;
        }
        if (item.available() > 0L) {
            this.renderCellText(graphics, "available", rendering, xx, yy, item.available());
            yy += 7;
        }
        if (item.toCraft() > 0L) {
            this.renderCellText(graphics, "to_craft", rendering, xx, yy, item.toCraft());
        }
    }

    private void renderCellBackground(class_332 graphics, int x, int y, PreviewItem item, double mouseX, double mouseY) {
        boolean hovering = this.method_2378(x + 1 - this.field_2776, y + 1 - this.field_2800, 72, 28, mouseX, mouseY);
        if (item.missing() > 0L || hovering) {
            int backgroundColor = item.missing() > 0L ? -860450 : -2368549;
            graphics.method_25294(x, y, x + 73, y + 29, hovering ? MathUtil.darkenARGB(backgroundColor, 0.1) : backgroundColor);
        }
    }

    private void renderCellText(class_332 graphics, String type, ResourceRendering rendering, int x, int y, long amount) {
        SmallText.render(graphics, this.field_22793, IdentifierUtil.createTranslation("gui", "autocrafting_preview." + type, rendering.formatAmount(amount, true)).method_30937(), x, y, 0x404040, false, 0.5f);
    }

    private void renderTreePreview(class_332 graphics, int mouseX, int mouseY, int x, int y) {
        if (this.tree == null) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        this.tree.method_48579(graphics, mouseX, mouseY, 0.0f);
        graphics.method_51448().method_22909();
        this.renderTreePreviewVignette(graphics, x, y);
    }

    private void renderTreePreviewVignette(class_332 graphics, int contentsX, int contentsY) {
        RenderSystem.enableBlend();
        graphics.method_52706(TREE_PREVIEW_VIGNETTE, contentsX, contentsY, 239, 119);
        RenderSystem.disableBlend();
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        super.method_2380(graphics, x, y);
        if (this.maxButton != null && this.maxButton.method_49606()) {
            Platform.INSTANCE.renderTooltip(graphics, List.of(HelpClientTooltipComponent.createAlwaysDisplayed((class_2561)MAX_HELP)), x, y);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (this.requestButtonsScrollbar != null && this.requestButtonsScrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    public void method_16014(double mx, double my) {
        if (this.scrollbar != null) {
            this.scrollbar.method_16014(mx, my);
        }
        if (this.requestButtonsScrollbar != null) {
            this.requestButtonsScrollbar.method_16014(mx, my);
        }
        super.method_16014(mx, my);
    }

    public boolean method_25406(double mx, double my, int button) {
        if (this.scrollbar != null && this.scrollbar.method_25406(mx, my, button)) {
            return true;
        }
        if (this.requestButtonsScrollbar != null && this.requestButtonsScrollbar.method_25406(mx, my, button)) {
            return true;
        }
        return super.method_25406(mx, my, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.tree != null && this.tree.field_22764 && this.isHoveringOverPreviewArea(mouseX, mouseY) && this.tree.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25401(double x, double y, double z, double delta) {
        boolean didPreviewItemsScrollbar = this.didScrollPreviewItemsScrollbar(x, y, z, delta);
        boolean didTreePreview = this.didScrollTreePreview(x, y, z, delta);
        if (didPreviewItemsScrollbar || didTreePreview) {
            return true;
        }
        boolean didRequestButtonsScrollbar = this.requestButtonsScrollbar != null && this.isHoveringOverRequestButtons(x, y) && this.requestButtonsScrollbar.method_25401(x, y, z, delta);
        return didRequestButtonsScrollbar || super.method_25401(x, y, z, delta);
    }

    private boolean didScrollTreePreview(double x, double y, double z, double delta) {
        return this.tree != null && this.tree.field_22764 && this.isHoveringOverPreviewArea(x, y) && this.tree.method_25401(x, y, z, delta);
    }

    private boolean didScrollPreviewItemsScrollbar(double x, double y, double z, double delta) {
        return this.scrollbar != null && this.scrollbar.field_22764 && this.isHoveringOverPreviewArea(x, y) && this.scrollbar.method_25401(x, y, z, delta);
    }

    private boolean isHoveringOverPreviewArea(double x, double y) {
        return this.method_2378(7, 97, 241, 121, x, y);
    }

    private boolean isHoveringOverRequestButtons(double x, double y) {
        int requestsInnerX = this.getRequestButtonsInnerX() - 1;
        int requestsInnerY = this.getRequestButtonsInnerY() - 1;
        return this.method_2378(requestsInnerX - this.field_2776, requestsInnerY - this.field_2800, 80, 98, x, y);
    }

    private int getRequestButtonsInnerY() {
        return this.field_2800 + 8;
    }

    private int getRequestButtonsInnerX() {
        return this.field_2776 - 83 + 4;
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    protected void onAmountFieldChanged() {
        if (this.amountField == null || this.confirmButton == null) {
            return;
        }
        this.disableStartButton();
        this.getAndValidateAmount().ifPresentOrElse(amount -> {
            this.confirmButton.method_25355((class_2561)PENDING);
            this.changedAmount = amount;
            this.amountField.method_1868(0xFFFFFF);
        }, () -> {
            this.confirmButton.method_25355((class_2561)START);
            this.amountField.method_1868(0xFF5555);
        });
    }

    private void disableStartButton() {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.field_22763 = false;
        this.confirmButton.setIcon(null);
        this.confirmButton.method_47400(null);
    }

    protected void method_37432() {
        super.method_37432();
        if (this.changedAmount != null && this.requestRateLimiter.tryAcquire()) {
            ((AutocraftingPreviewContainerMenu)this.method_17577()).amountChanged(this.changedAmount);
            this.changedAmount = null;
        }
        if (this.mayEnableMaxAmountRequestButtonAgain && this.maxButton != null && this.maxAmountRequestRateLimiter.tryAcquire()) {
            this.maxButton.field_22763 = true;
            this.mayEnableMaxAmountRequestButtonAgain = false;
        }
    }

    @Override
    protected boolean beforeClose() {
        if (this.requestedCancellation) {
            return true;
        }
        this.requestedCancellation = true;
        if (this.cancelButton != null) {
            this.cancelButton.field_22763 = false;
            this.cancelButton.method_25355((class_2561)CANCELLING);
            this.cancelButton.method_47400(class_7919.method_47407((class_2561)CANCELLING_FORCE_CLOSE));
        }
        ((AutocraftingPreviewContainerMenu)this.method_17577()).sendCancelRequest();
        return false;
    }

    public void cancelResponseReceived() {
        if (!this.requestedCancellation) {
            return;
        }
        this.close();
    }

    @Override
    protected void reset() {
        this.updateAmount(((AutocraftingPreviewContainerMenu)this.method_17577()).getCurrentRequest().getAmount());
    }

    @Override
    protected boolean confirm(Double amount) {
        this.disableStartButton();
        if (this.confirmButton != null) {
            this.confirmButton.method_25355((class_2561)PENDING);
        }
        ((AutocraftingPreviewContainerMenu)this.method_17577()).sendRequest(amount, this.notifyCheckbox == null ? ((AutocraftingPreviewContainerMenu)this.field_2797).isNotify() : this.notifyCheckbox.isSelected());
        return false;
    }

    @Override
    public void requestChanged(AutocraftingRequest request) {
        this.setRequest(request);
    }

    @Override
    public void previewChanged(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        this.setPreview(preview, treePreview);
    }

    @Override
    public void requestRemoved(AutocraftingRequest request, boolean last) {
        if (last) {
            this.close();
            return;
        }
        this.requestButtons.stream().filter(btn -> btn.getRequest() == request).findFirst().ifPresent(btn -> {
            this.method_37066((class_364)btn);
            this.requestButtons.remove(btn);
        });
        this.updateRequestsScrollbar();
        for (int i = 0; i < this.requestButtons.size(); ++i) {
            AutocraftingRequestButton requestButton = this.requestButtons.get(i);
            int buttonY = this.getCraftingRequestButtonY(i);
            requestButton.method_46419(buttonY);
            requestButton.field_22764 = this.isCraftingRequestButtonVisible(buttonY);
        }
    }

    @Override
    public void maxAmountReceived(double maxAmount) {
        this.updateAmount(maxAmount);
        this.maxAmountRequestRateLimiter.tryAcquire();
        this.mayEnableMaxAmountRequestButtonAgain = true;
    }

    private void updateRequestsScrollbar() {
        if (this.requestButtonsScrollbar == null) {
            return;
        }
        int totalRequestButtons = ((AutocraftingPreviewContainerMenu)this.method_17577()).getRequests().size() - 4;
        int maxOffset = this.requestButtonsScrollbar.isSmoothScrolling() ? totalRequestButtons * 24 : totalRequestButtons;
        this.requestButtonsScrollbar.setEnabled(maxOffset > 0);
        this.requestButtonsScrollbar.setMaxOffset(maxOffset);
    }
}

