/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6382;

class AutocraftingRequestButton
extends class_4264 {
    private final AutocraftingRequest request;
    private final TextMarquee text;
    private final Consumer<AutocraftingRequest> onPress;

    AutocraftingRequestButton(int x, int y, AutocraftingRequest request, Consumer<AutocraftingRequest> onPress) {
        super(x, y, 64, 24, (class_2561)class_2561.method_43473());
        this.request = request;
        ResourceKey resource = request.getResource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.text = new TextMarquee(rendering.getDisplayName(resource), 36, 0xFFFFFF, true, true);
        this.onPress = onPress;
    }

    AutocraftingRequest getRequest() {
        return this.request;
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(graphics, mouseX, mouseY, partialTick);
        this.renderResourceIcon(graphics);
        int yOffset = SmallText.isSmall() ? 8 : 5;
        this.text.render(graphics, this.method_46426() + 3 + 16 + 3, this.method_46427() + yOffset, class_310.method_1551().field_1772, this.field_22762);
    }

    private void renderResourceIcon(class_332 graphics) {
        long l;
        ResourceKey resource = this.request.getResource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        int resourceX = this.method_46426() + 3;
        int resourceY = this.method_46427() + 4;
        rendering.render(resource, graphics, resourceX, resourceY);
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            l = platformResource.getResourceType().normalizeAmount(this.request.getAmount());
        } else {
            l = 0L;
        }
        long normalizedAmount = l;
        ResourceSlotRendering.renderAmount(graphics, resourceX, resourceY, normalizedAmount, rendering);
    }

    public void method_25306() {
        this.onPress.accept(this.request);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

