/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreviewNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.repackage.org.abego.treelayout.TreeLayout;
import com.refinedmods.refinedstorage.common.repackage.org.abego.treelayout.util.DefaultConfiguration;
import com.refinedmods.refinedstorage.common.repackage.org.abego.treelayout.util.DefaultTreeForTreeLayout;
import com.refinedmods.refinedstorage.common.repackage.org.abego.treelayout.util.FixedNodeExtentProvider;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

class TreePreviewWidget
extends class_339 {
    private static final class_2960 BACKGROUND = IdentifierUtil.createIdentifier("autocrafting_preview/tree_background");
    private static final class_2960 NODE_BACKGROUND = IdentifierUtil.createIdentifier("autocrafting_preview/tree_node");
    private static final class_2960 NODE_BACKGROUND_HOVER = IdentifierUtil.createIdentifier("autocrafting_preview/tree_node_hover");
    private static final class_2960 CRAFTING_NODE_BACKGROUND = IdentifierUtil.createIdentifier("autocrafting_preview/tree_node_crafting");
    private static final class_2960 CRAFTING_NODE_BACKGROUND_HOVER = IdentifierUtil.createIdentifier("autocrafting_preview/tree_node_crafting_hover");
    private static final class_2960 MISSING_NODE_BACKGROUND = IdentifierUtil.createIdentifier("autocrafting_preview/tree_node_missing");
    private static final class_2960 MISSING_NODE_BACKGROUND_HOVER = IdentifierUtil.createIdentifier("autocrafting_preview/tree_node_missing_hover");
    private static final double MIN_ZOOM = 0.5;
    private static final double MAX_ZOOM = 4.0;
    private static final double SMOOTH_FACTOR = 0.15;
    private static final double[] ZOOM_LEVELS = new double[]{0.5, 1.0, 2.0, 4.0};
    private static final double DRAG_SMOOTH_FACTOR = 0.15;
    private static final int LINE_COLOR = -8289919;
    private static final int INACTIVE_LINE_COLOR = -2138996351;
    private static final int NODE_SIZE = 26;
    private final class_437 screen;
    private final Set<TreePreviewNode> activeNodes = new HashSet<TreePreviewNode>();
    @Nullable
    private TreeLayout<TreePreviewNode> tree;
    @Nullable
    private TreePreviewNode hoveredNode;
    private double zoom = 1.0;
    private double targetZoom = 1.0;
    private double translateX = 0.0;
    private double translateY = 0.0;
    private double targetTranslateX = 0.0;
    private double targetTranslateY = 0.0;

    TreePreviewWidget(class_437 screen, int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.screen = screen;
    }

    void update(@Nullable TreePreview preview) {
        if (preview == null || preview.rootNode() == null) {
            this.tree = null;
            return;
        }
        DefaultTreeForTreeLayout<TreePreviewNode> treeContents = new DefaultTreeForTreeLayout<TreePreviewNode>(preview.rootNode());
        TreePreviewWidget.addChildren(treeContents, preview.rootNode());
        this.tree = new TreeLayout<TreePreviewNode>(treeContents, new FixedNodeExtentProvider(26.0, 26.0), new DefaultConfiguration(15.0, 10.0));
        this.ensureThatTheTreeIsCentered();
    }

    boolean hasContents() {
        return this.tree != null;
    }

    private void ensureThatTheTreeIsCentered() {
        double scaleY;
        if (this.tree == null) {
            return;
        }
        Rectangle2D bounds = this.tree.getBounds();
        double scaleX = (double)this.field_22758 / bounds.getWidth();
        double scale = Math.min(scaleX, scaleY = (double)this.field_22759 / bounds.getHeight());
        if (scale < 1.0) {
            this.targetZoom = this.zoom = Math.max(0.5, Math.min(4.0, scale));
        } else {
            this.zoom = 1.0;
            this.targetZoom = 1.0;
        }
        double centerX = bounds.getX() + bounds.getWidth() / 2.0;
        double centerY = bounds.getY() + bounds.getHeight() / 2.0;
        this.translateX = (double)this.field_22758 / 2.0 - centerX * this.zoom;
        this.translateY = (double)this.field_22759 / 2.0 - centerY * this.zoom;
        this.targetTranslateX = this.translateX;
        this.targetTranslateY = this.translateY;
    }

    private static void addChildren(DefaultTreeForTreeLayout<TreePreviewNode> treeContents, TreePreviewNode parent) {
        for (TreePreviewNode child : parent.getChildren()) {
            treeContents.addChild(parent, child);
            TreePreviewWidget.addChildren(treeContents, child);
        }
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_22764) {
            return;
        }
        this.renderBackground(graphics);
        if (this.tree == null) {
            return;
        }
        this.zoom += (this.targetZoom - this.zoom) * 0.15;
        this.translateX += (this.targetTranslateX - this.translateX) * 0.15;
        this.translateY += (this.targetTranslateY - this.translateY) * 0.15;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(this.translateX, this.translateY, 0.0);
        graphics.method_51448().method_22905((float)this.zoom, (float)this.zoom, 1.0f);
        this.renderEdges(graphics, this.tree.getTree().getRoot());
        if (!this.renderNode(graphics, this.tree.getTree().getRoot(), mouseX, mouseY)) {
            this.hoveredNode = null;
            this.activeNodes.clear();
        }
        graphics.method_51448().method_22909();
    }

    private void renderBackground(class_332 graphics) {
        graphics.method_52706(BACKGROUND, 0, 0, this.field_22758, this.field_22759);
    }

    private boolean renderNode(class_332 graphics, TreePreviewNode node, int mouseX, int mouseY) {
        if (this.tree == null) {
            return false;
        }
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(node.getResource().getClass());
        Rectangle2D.Double bounds = this.tree.getNodeBounds().get(node);
        boolean anyHovering = false;
        if (this.isInView((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height)) {
            anyHovering = this.renderNode(graphics, node, bounds, rendering, mouseX, mouseY);
        }
        for (TreePreviewNode child : node.getChildren()) {
            if (!this.renderNode(graphics, child, mouseX, mouseY)) continue;
            anyHovering = true;
        }
        return anyHovering;
    }

    private boolean renderNode(class_332 graphics, TreePreviewNode node, Rectangle2D.Double bounds, ResourceRendering rendering, double mouseX, double mouseY) {
        boolean inactive;
        boolean hovering;
        double worldMouseX = (mouseX - (double)this.method_46426() - this.translateX) / this.zoom;
        double worldMouseY = (mouseY - (double)this.method_46427() - this.translateY) / this.zoom;
        boolean bl = hovering = worldMouseX >= bounds.x + 1.0 && worldMouseX <= bounds.x + bounds.width - 1.0 && worldMouseY >= bounds.y + 1.0 && worldMouseY <= bounds.y + bounds.height - 1.0;
        if (hovering) {
            if (this.hoveredNode != node) {
                this.hoveredNode = node;
                this.activeNodes.clear();
                this.calculateActiveNodes(this.hoveredNode);
            }
            this.screen.method_47414(this.getTooltip(node, rendering));
        }
        class_2960 background = TreePreviewWidget.getNodeBackground(node, hovering);
        graphics.method_52706(background, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
        rendering.render(node.getResource(), graphics, (int)bounds.x + 5, (int)bounds.y + 5);
        boolean large = class_310.method_1551().method_1573() || Platform.INSTANCE.getConfig().getGrid().isLargeFont();
        ResourceSlotRendering.renderAmount(graphics, (int)bounds.x + 5, (int)bounds.y + 5, rendering.formatAmount(node.getAmount(), true), 0xFFFFFF, large);
        boolean bl2 = inactive = !this.activeNodes.isEmpty() && !this.activeNodes.contains(node);
        if (inactive) {
            graphics.method_51737((int)bounds.x + 2, (int)bounds.y + 2, (int)bounds.x + (int)bounds.width - 2, (int)bounds.y + (int)bounds.height - 2, 400, Integer.MIN_VALUE);
        }
        return hovering;
    }

    private void calculateActiveNodes(TreePreviewNode node) {
        this.activeNodes.add(node);
        node.getChildren().forEach(this::calculateActiveNodes);
    }

    private static class_2960 getNodeBackground(TreePreviewNode node, boolean hovering) {
        if (node.getMissing() > 0L) {
            return hovering ? MISSING_NODE_BACKGROUND_HOVER : MISSING_NODE_BACKGROUND;
        }
        if (node.getToCraft() > 0L) {
            return hovering ? CRAFTING_NODE_BACKGROUND_HOVER : CRAFTING_NODE_BACKGROUND;
        }
        return hovering ? NODE_BACKGROUND_HOVER : NODE_BACKGROUND;
    }

    private List<class_5481> getTooltip(TreePreviewNode node, ResourceRendering resourceRendering) {
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>(resourceRendering.getTooltip(node.getResource()).stream().map(class_2561::method_30937).toList());
        if (node.getAvailable() > 0L) {
            tooltip.add(IdentifierUtil.createTranslation("gui", "autocrafting_preview.available", resourceRendering.formatAmount(node.getAvailable())).method_30937());
        }
        if (node.getToCraft() > 0L) {
            tooltip.add(IdentifierUtil.createTranslation("gui", "autocrafting_preview.to_craft", resourceRendering.formatAmount(node.getToCraft())).method_30937());
        }
        if (node.getMissing() > 0L) {
            tooltip.add(IdentifierUtil.createTranslation("gui", "autocrafting_preview.missing", resourceRendering.formatAmount(node.getMissing())).method_30937());
        }
        return tooltip;
    }

    private void renderEdges(class_332 graphics, TreePreviewNode node) {
        if (this.tree == null || this.tree.getTree().isLeaf(node)) {
            return;
        }
        Rectangle2D.Double bounds1 = this.tree.getNodeBounds().get(node);
        int x1 = (int)bounds1.getCenterX();
        int y1 = (int)bounds1.getCenterY();
        for (TreePreviewNode child : node.getChildren()) {
            if (this.tree == null) {
                return;
            }
            Rectangle2D.Double bounds2 = this.tree.getNodeBounds().get(child);
            int x2 = (int)bounds2.getCenterX();
            int y2 = (int)bounds2.getCenterY();
            if (this.isInView(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1))) {
                boolean active = !this.activeNodes.isEmpty() && (!this.activeNodes.contains(child) || !this.activeNodes.contains(node));
                int lineColor = active ? -2138996351 : -8289919;
                this.drawLine(graphics, x1, y1, x2, y2, lineColor);
            }
            this.renderEdges(graphics, child);
        }
    }

    private void drawLine(class_332 graphics, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int xx = x1;
        int yy = y1;
        int err = dx - dy;
        while (true) {
            graphics.method_25292(xx, xx, yy, color);
            if (xx == x2 && yy == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                xx += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            yy += sy;
        }
    }

    private boolean isInView(double x, double y, int width, int height) {
        double screenX = x * this.zoom + this.translateX;
        double screenY = y * this.zoom + this.translateY;
        double screenWidth = (double)width * this.zoom;
        double screenHeight = (double)height * this.zoom;
        return screenX + screenWidth >= 0.0 && screenY + screenHeight >= 0.0 && screenX <= (double)this.field_22758 && screenY <= (double)this.field_22759;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            double prevZoom = this.targetZoom;
            int index = this.getClosestZoomLevelIndex(this.targetZoom);
            index = Math.max(0, Math.min(ZOOM_LEVELS.length - 1, index + (scrollY > 0.0 ? 1 : -1)));
            this.targetZoom = ZOOM_LEVELS[index];
            this.zoomInTheDirectionOfTheMouseCursor(mouseX, mouseY, prevZoom);
        }
        return true;
    }

    private int getClosestZoomLevelIndex(double scrollY) {
        int closest = 0;
        for (int i = 1; i < ZOOM_LEVELS.length; ++i) {
            if (!(Math.abs(ZOOM_LEVELS[i] - scrollY) < Math.abs(ZOOM_LEVELS[closest] - scrollY))) continue;
            closest = i;
        }
        return closest;
    }

    private void zoomInTheDirectionOfTheMouseCursor(double mouseX, double mouseY, double prevZoom) {
        double scaleChange = this.targetZoom / prevZoom;
        double worldMouseX = (mouseX - (double)this.method_46426() - this.translateX) / this.zoom;
        double worldMouseY = (mouseY - (double)this.method_46427() - this.translateY) / this.zoom;
        this.targetTranslateX -= worldMouseX * (scaleChange - 1.0) * this.zoom;
        this.targetTranslateY -= worldMouseY * (scaleChange - 1.0) * this.zoom;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.targetTranslateX += dragX;
        this.targetTranslateY += dragY;
        return true;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

