/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.configurationcard;

import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.configurationcard.ConfigurationCardState;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class ConfigurationCardItem
extends class_1792 {
    private static final class_2561 EMPTY_HELP = IdentifierUtil.createTranslation("item", "configuration_card.empty_help");
    private static final class_2561 CONFIGURED_HELP = IdentifierUtil.createTranslation("item", "configuration_card.configured_help");
    private static final class_2561 EMPTY = IdentifierUtil.createTranslation("item", "configuration_card.empty").method_27692(class_124.field_1080);

    public ConfigurationCardItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public class_1269 method_7884(class_1838 ctx) {
        if (ctx.method_8045().method_8608() || ctx.method_8036() == null) {
            return class_1269.field_21466;
        }
        class_2586 blockEntity = ctx.method_8045().method_8321(ctx.method_8037());
        if (!(blockEntity instanceof ConfigurationCardTarget)) {
            return class_1269.field_21466;
        }
        ConfigurationCardTarget target = (ConfigurationCardTarget)blockEntity;
        class_1799 stack = ctx.method_8041();
        ConfigurationCardState state = (ConfigurationCardState)stack.method_57824(DataComponents.INSTANCE.getConfigurationCardState());
        if (state == null) {
            stack.method_57379(DataComponents.INSTANCE.getConfigurationCardState(), (Object)new ConfigurationCardState(blockEntity.method_11017(), this.createConfigTag(target, (class_7225.class_7874)ctx.method_8045().method_30349()), target.getUpgrades()));
            this.sendCopiedConfigurationMessage(ctx.method_8036(), blockEntity.method_11017());
            return class_1269.field_21466;
        }
        return this.applyConfiguration(ctx.method_8036(), blockEntity, target, state, (class_7225.class_7874)ctx.method_8045().method_30349());
    }

    private class_1269 applyConfiguration(class_1657 player, class_2586 targetBlockEntity, ConfigurationCardTarget target, ConfigurationCardState state, class_7225.class_7874 provider) {
        if (state.blockEntityType() != targetBlockEntity.method_11017()) {
            return this.configurationCardIsConfiguredForDifferentType(player, state.blockEntityType());
        }
        target.readConfiguration(state.config(), provider);
        this.tryTransferUpgrades(player, target, state.upgrades());
        targetBlockEntity.method_5431();
        player.method_43496((class_2561)IdentifierUtil.createTranslation("item", "configuration_card.applied_configuration"));
        return class_1269.field_5812;
    }

    private void tryTransferUpgrades(class_1657 player, ConfigurationCardTarget target, List<class_1799> upgrades) {
        for (class_1799 upgrade : upgrades) {
            int upgradeIndexInPlayerInventory = player.method_31548().method_7395(upgrade);
            if (upgradeIndexInPlayerInventory < 0 || !target.addUpgrade(upgrade)) continue;
            player.method_31548().method_5434(upgradeIndexInPlayerInventory, 1);
        }
    }

    private class_1269 configurationCardIsConfiguredForDifferentType(class_1657 player, @Nullable class_2591<?> existingConfiguredType) {
        if (existingConfiguredType != null) {
            player.method_43496((class_2561)IdentifierUtil.createTranslation("item", "configuration_card.cannot_apply_configuration", ConfigurationCardItem.getConfiguredTypeTranslation(existingConfiguredType).method_27692(class_124.field_1054)));
        }
        return class_1269.field_21466;
    }

    private class_2487 createConfigTag(ConfigurationCardTarget target, class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        target.writeConfiguration(tag, provider);
        return tag;
    }

    private void sendCopiedConfigurationMessage(class_1657 player, class_2591<?> configuredType) {
        if (player.method_37908().method_8608()) {
            return;
        }
        player.method_43496((class_2561)IdentifierUtil.createTranslation("item", "configuration_card.copied_configuration", ConfigurationCardItem.getConfiguredTypeTranslation(configuredType).method_27692(class_124.field_1054)));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (player.method_18276()) {
            if (!level.method_8608()) {
                player.method_43496((class_2561)IdentifierUtil.createTranslation("item", "configuration_card.cleared_configuration"));
            }
            return new class_1271(class_1269.field_21466, (Object)new class_1799((class_1935)this));
        }
        return super.method_7836(level, player, hand);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> lines, class_1836 flag) {
        super.method_7851(stack, context, lines, flag);
        ConfigurationCardState state = (ConfigurationCardState)stack.method_57824(DataComponents.INSTANCE.getConfigurationCardState());
        if (state == null) {
            lines.add(EMPTY);
            return;
        }
        lines.add((class_2561)IdentifierUtil.createTranslation("item", "configuration_card.configured", ConfigurationCardItem.getConfiguredTypeTranslation(state.blockEntityType()).method_27692(class_124.field_1068)).method_27692(class_124.field_1080));
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new HelpTooltipComponent(this.isActive(stack) ? CONFIGURED_HELP : EMPTY_HELP));
    }

    boolean isActive(class_1799 stack) {
        return stack.method_57826(DataComponents.INSTANCE.getConfigurationCardState());
    }

    private static class_5250 getConfiguredTypeTranslation(class_2591<?> type) {
        class_2960 typeId = class_7923.field_41181.method_10221(type);
        if (typeId == null) {
            return class_2561.method_43473();
        }
        return class_2561.method_43471((String)("block." + typeId.method_12836() + "." + typeId.method_12832()));
    }
}

