/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategyFactory;
import com.refinedmods.refinedstorage.common.constructordestructor.AutocraftOnMissingResourcesConstructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.CompositeConstructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorContainerMenu;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorData;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorNetworkNode;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeContainer;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public abstract class AbstractConstructorBlockEntity
extends AbstractCableLikeBlockEntity<ConstructorNetworkNode>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ConstructorData> {
    private static final String TAG_DROP_ITEMS = "di";
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(UpgradeDestinations.CONSTRUCTOR, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getConstructor().getEnergyUsage();
        ((ConstructorNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.method_5431();
        class_1937 patt0$temp = this.field_11863;
        if (patt0$temp instanceof class_3218) {
            class_3218 serverLevel = (class_3218)patt0$temp;
            this.initialize(serverLevel);
        }
    }, 20);
    private final FilterWithFuzzyMode filter;
    private final SchedulingModeContainer schedulingModeContainer;
    private boolean dropItems;

    protected AbstractConstructorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getConstructor(), pos, state, new ConstructorNetworkNode(Platform.INSTANCE.getConfig().getConstructor().getEnergyUsage()));
        this.ticker = this.upgradeContainer.getTicker();
        this.schedulingModeContainer = new SchedulingModeContainer(schedulingMode -> {
            ((ConstructorNetworkNode)this.mainNetworkNode).setSchedulingMode((SchedulingMode)schedulingMode);
            this.method_5431();
        });
        this.filter = FilterWithFuzzyMode.createAndListenForFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractConstructorBlockEntity)this).method_5431(), this::setFilters);
    }

    void setFilters(List<ResourceKey> filters) {
        ((ConstructorNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ((ConstructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((ConstructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private ConstructorStrategy createStrategy(class_3218 serverLevel, class_2350 direction) {
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = this.field_11867.method_10093(direction);
        Collection<ConstructorStrategyFactory> factories = RefinedStorageApi.INSTANCE.getConstructorStrategyFactories();
        List<ConstructorStrategy> strategies = factories.stream().flatMap(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, this.upgradeContainer, this.dropItems).stream()).toList();
        CompositeConstructorStrategy strategy = new CompositeConstructorStrategy(strategies);
        if (this.upgradeContainer.has(Items.INSTANCE.getAutocraftingUpgrade())) {
            return new AutocraftOnMissingResourcesConstructorStrategy(strategy);
        }
        return strategy;
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10556(TAG_DROP_ITEMS, this.dropItems);
        this.schedulingModeContainer.writeToTag(tag);
        this.filter.save(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545(TAG_DROP_ITEMS)) {
            this.dropItems = tag.method_10577(TAG_DROP_ITEMS);
        }
        this.schedulingModeContainer.loadFromTag(tag);
        this.filter.load(tag, provider);
    }

    void setSchedulingModeType(SchedulingModeType type) {
        this.schedulingModeContainer.setType(type);
    }

    SchedulingModeType getSchedulingModeType() {
        return this.schedulingModeContainer.getType();
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    boolean isDropItems() {
        return this.dropItems;
    }

    void setDropItems(boolean dropItems) {
        this.dropItems = dropItems;
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.CONSTRUCTOR);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new ConstructorContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators());
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((ConstructorNetworkNode)this.mainNetworkNode).getLastResult(i)), false);
    }

    private ExportingIndicator toExportingIndicator(@Nullable ConstructorStrategy.Result result) {
        ConstructorStrategy.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (ConstructorStrategy.Result)result2, n)) {
            case 0 -> ExportingIndicator.RESOURCE_MISSING;
            case 1 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 2 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    @Override
    public ConstructorData getMenuData() {
        return new ConstructorData(ResourceContainerData.of(this.filter.getFilterContainer()), this.getExportingIndicators().getAll());
    }

    @Override
    public class_9142<class_9129, ConstructorData> getMenuCodec() {
        return ConstructorData.STREAM_CODEC;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

