/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.CompositeDestructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorContainerMenu;
import com.refinedmods.refinedstorage.common.constructordestructor.DestructorNetworkNode;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public abstract class AbstractDestructorBlockEntity
extends AbstractCableLikeBlockEntity<DestructorNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_PICKUP_ITEMS = "pi";
    private static final String TAG_UPGRADES = "upgr";
    private final FilterWithFuzzyMode filterWithFuzzyMode = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractDestructorBlockEntity)this).method_5431(), this::setFilters);
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(UpgradeDestinations.DESTRUCTOR, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getDestructor().getEnergyUsage();
        ((DestructorNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.method_5431();
        class_1937 patt0$temp = this.field_11863;
        if (patt0$temp instanceof class_3218) {
            class_3218 serverLevel = (class_3218)patt0$temp;
            this.initialize(serverLevel);
        }
    }, 20);
    private boolean pickupItems;

    protected AbstractDestructorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getDestructor(), pos, state, new DestructorNetworkNode(Platform.INSTANCE.getConfig().getDestructor().getEnergyUsage()));
        this.ticker = this.upgradeContainer.getTicker();
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public boolean isPickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean pickupItems) {
        this.pickupItems = pickupItems;
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
    }

    void setFilters(Set<ResourceKey> filters) {
        ((DestructorNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    public FilterMode getFilterMode() {
        return ((DestructorNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    public void setFilterMode(FilterMode mode) {
        ((DestructorNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.method_5431();
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(((DestructorNetworkNode)this.mainNetworkNode).getFilterMode()));
        tag.method_10556(TAG_PICKUP_ITEMS, this.pickupItems);
        this.filterWithFuzzyMode.save(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filterWithFuzzyMode.load(tag, provider);
        if (tag.method_10545(TAG_FILTER_MODE)) {
            ((DestructorNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode(tag.method_10550(TAG_FILTER_MODE)));
        }
        if (tag.method_10545(TAG_PICKUP_ITEMS)) {
            this.pickupItems = tag.method_10577(TAG_PICKUP_ITEMS);
        }
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filterWithFuzzyMode.getFilterContainer());
    }

    @Override
    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.DESTRUCTOR);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new DestructorContainerMenu(syncId, player, this, this.filterWithFuzzyMode.getFilterContainer(), this.upgradeContainer);
    }

    @Override
    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ((DestructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((DestructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private CompositeDestructorStrategy createStrategy(class_3218 level, class_2350 direction) {
        class_2338 pos = this.method_11016().method_10093(direction);
        class_2350 incomingDirection = direction.method_10153();
        List<DestructorStrategy> strategies = RefinedStorageApi.INSTANCE.getDestructorStrategyFactories().stream().flatMap(factory -> factory.create(level, pos, incomingDirection, this.upgradeContainer, this.pickupItems).stream()).toList();
        return new CompositeDestructorStrategy(strategies);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

