/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

abstract class AbstractItemConstructorStrategy
implements ConstructorStrategy {
    protected final class_3218 level;
    protected final class_2338 pos;
    protected final class_2350 direction;

    AbstractItemConstructorStrategy(class_3218 level, class_2338 pos, class_2350 direction) {
        this.level = level;
        this.pos = pos;
        this.direction = direction;
    }

    protected long getTransferAmount() {
        return 1L;
    }

    @Override
    public final ConstructorStrategy.Result apply(ResourceKey resource, Actor actor, class_1657 player, Network network) {
        long amount;
        if (!this.level.method_8477(this.pos) || !(resource instanceof ItemResource)) {
            return ConstructorStrategy.Result.SKIPPED;
        }
        ItemResource itemResource = (ItemResource)resource;
        if (!this.hasWork()) {
            return ConstructorStrategy.Result.SUCCESS;
        }
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        long extractedAmount = rootStorage.extract(itemResource, amount = this.getTransferAmount(), Action.SIMULATE, actor);
        if (extractedAmount == 0L) {
            return ConstructorStrategy.Result.RESOURCE_MISSING;
        }
        class_1799 itemStack = itemResource.toItemStack(extractedAmount);
        boolean success = this.apply(itemStack, actor, player);
        if (success) {
            rootStorage.extract(itemResource, extractedAmount, Action.EXECUTE, actor);
        }
        return success ? ConstructorStrategy.Result.SUCCESS : ConstructorStrategy.Result.SKIPPED;
    }

    protected abstract boolean apply(class_1799 var1, Actor var2, class_1657 var3);

    protected abstract boolean hasWork();

    protected double getDispensePositionX() {
        return (double)this.pos.method_10263() + 0.5;
    }

    protected double getDispensePositionY() {
        return (double)this.pos.method_10264() + (this.direction == class_2350.field_11033 ? 0.45 : 0.5);
    }

    protected double getDispensePositionZ() {
        return (double)this.pos.method_10260() + 0.5;
    }
}

