/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import net.minecraft.class_1657;

class AutocraftOnMissingResourcesConstructorStrategy
implements ConstructorStrategy {
    private final ConstructorStrategy delegate;

    AutocraftOnMissingResourcesConstructorStrategy(ConstructorStrategy delegate) {
        this.delegate = delegate;
    }

    @Override
    public ConstructorStrategy.Result apply(ResourceKey resource, Actor actor, class_1657 player, Network network) {
        AutocraftingNetworkComponent autocrafting;
        ConstructorStrategy.Result result = this.delegate.apply(resource, actor, player, network);
        if (result == ConstructorStrategy.Result.RESOURCE_MISSING && !(autocrafting = network.getComponent(AutocraftingNetworkComponent.class)).getPatternsByOutput(resource).isEmpty()) {
            long l;
            if (resource instanceof PlatformResourceKey) {
                PlatformResourceKey platformResource = (PlatformResourceKey)resource;
                l = platformResource.getResourceType().normalizeAmount(1.0);
            } else {
                l = 1L;
            }
            long amount = l;
            AutocraftingNetworkComponent.EnsureResult ensureResult = autocrafting.ensureTask(resource, amount, actor);
            boolean success = ensureResult == AutocraftingNetworkComponent.EnsureResult.TASK_CREATED || ensureResult == AutocraftingNetworkComponent.EnsureResult.TASK_ALREADY_RUNNING;
            return success ? ConstructorStrategy.Result.AUTOCRAFTING_STARTED : ConstructorStrategy.Result.AUTOCRAFTING_MISSING_RESOURCES;
        }
        return result;
    }
}

