/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

class BlockBreakDestructorStrategy
implements DestructorStrategy {
    private final class_3218 level;
    private final class_2338 pos;
    private final class_2350 direction;
    private final class_1799 tool;

    BlockBreakDestructorStrategy(class_3218 level, class_2338 pos, class_2350 direction, class_1799 tool) {
        this.level = level;
        this.pos = pos;
        this.direction = direction;
        this.tool = tool;
    }

    @Override
    public boolean apply(Filter filter, Actor actor, Supplier<Network> networkProvider, class_1657 player) {
        if (!this.level.method_8477(this.pos)) {
            return false;
        }
        class_2680 blockState = this.level.method_8320(this.pos);
        class_2248 block = blockState.method_26204();
        if (BlockBreakDestructorStrategy.isFastExit(blockState) || (double)blockState.method_26214((class_1922)this.level, this.pos) == -1.0 || !this.isAllowed(player, filter, blockState, block) || !Platform.INSTANCE.canBreakBlock((class_1937)this.level, this.pos, blockState, player)) {
            return false;
        }
        List drops = class_2248.method_9609((class_2680)blockState, (class_3218)this.level, (class_2338)this.pos, (class_2586)this.level.method_8321(this.pos), (class_1297)player, (class_1799)this.tool);
        if (!this.insertDrops(actor, drops, BlockBreakDestructorStrategy.getRootStorage(networkProvider), Action.SIMULATE)) {
            return false;
        }
        block.method_9576((class_1937)this.level, this.pos, blockState, player);
        this.level.method_8650(this.pos, false);
        this.insertDrops(actor, drops, BlockBreakDestructorStrategy.getRootStorage(networkProvider), Action.EXECUTE);
        return true;
    }

    private static RootStorage getRootStorage(Supplier<Network> network) {
        return network.get().getComponent(StorageNetworkComponent.class);
    }

    private static boolean isFastExit(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26204() instanceof class_2404;
    }

    private boolean isAllowed(class_1657 actingPlayer, Filter filter, class_2680 state, class_2248 block) {
        class_1799 blockAsStack = Platform.INSTANCE.getBlockAsItemStack(block, state, this.direction, (class_4538)this.level, this.pos, actingPlayer);
        if (blockAsStack.method_7960()) {
            return false;
        }
        ItemResource blockAsResource = ItemResource.ofItemStack(blockAsStack);
        return filter.isAllowed(blockAsResource);
    }

    private boolean insertDrops(Actor actor, List<class_1799> drops, RootStorage storage, Action action) {
        for (class_1799 drop : drops) {
            boolean didWeDisconnectStorageInTheProcessOfRemovingABlock;
            ItemResource resource = ItemResource.ofItemStack(drop);
            boolean didNotInsertCompletely = storage.insert(resource, drop.method_7947(), action, actor) != (long)drop.method_7947();
            if (!didNotInsertCompletely) continue;
            boolean bl = didWeDisconnectStorageInTheProcessOfRemovingABlock = action == Action.EXECUTE;
            if (didWeDisconnectStorageInTheProcessOfRemovingABlock) {
                class_1264.method_5449((class_1937)this.level, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), (class_1799)drop);
                continue;
            }
            return false;
        }
        return true;
    }
}

