/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1657;

public class ConstructorNetworkNode
extends SimpleNetworkNode {
    private final Actor actor = new NetworkNodeActor(this);
    private final List<ConstructorTask> tasks = new ArrayList<ConstructorTask>();
    @Nullable
    private Supplier<class_1657> playerProvider;
    @Nullable
    private ConstructorStrategy strategy;
    @Nullable
    private SchedulingMode schedulingMode;

    ConstructorNetworkNode(long energyUsage) {
        super(energyUsage);
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive() || this.schedulingMode == null) {
            return;
        }
        this.schedulingMode.execute(this.tasks);
    }

    void setPlayerProvider(@Nullable Supplier<class_1657> playerSupplier) {
        this.playerProvider = playerSupplier;
    }

    void setSchedulingMode(@Nullable SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    void setFilters(List<ResourceKey> filters) {
        ArrayList<ConstructorTask> updatedTasks = new ArrayList<ConstructorTask>();
        for (int i = 0; i < filters.size(); ++i) {
            ResourceKey filter = filters.get(i);
            ConstructorStrategy.Result lastResult = i < this.tasks.size() && this.tasks.get((int)i).filter.equals(filter) ? this.tasks.get((int)i).lastResult : null;
            ConstructorTask task = new ConstructorTask(filter, lastResult);
            updatedTasks.add(task);
        }
        this.tasks.clear();
        this.tasks.addAll(updatedTasks);
    }

    void setStrategy(@Nullable ConstructorStrategy strategy) {
        this.strategy = strategy;
    }

    @Nullable
    public ConstructorStrategy.Result getLastResult(int filterIndex) {
        return this.tasks.get((int)filterIndex).lastResult;
    }

    private class ConstructorTask
    implements SchedulingMode.ScheduledTask {
        private final ResourceKey filter;
        @Nullable
        private ConstructorStrategy.Result lastResult;

        private ConstructorTask(@Nullable ResourceKey filter, ConstructorStrategy.Result lastResult) {
            this.filter = filter;
            this.lastResult = lastResult;
        }

        @Override
        public boolean run() {
            if (ConstructorNetworkNode.this.strategy == null || ConstructorNetworkNode.this.network == null || ConstructorNetworkNode.this.playerProvider == null) {
                return false;
            }
            class_1657 player = ConstructorNetworkNode.this.playerProvider.get();
            this.lastResult = ConstructorNetworkNode.this.strategy.apply(this.filter, ConstructorNetworkNode.this.actor, player, ConstructorNetworkNode.this.network);
            return this.lastResult == ConstructorStrategy.Result.SUCCESS;
        }
    }
}

