/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

class FluidBreakDestructorStrategy
implements DestructorStrategy {
    private final class_3218 level;
    private final class_2338 pos;

    FluidBreakDestructorStrategy(class_3218 level, class_2338 pos) {
        this.level = level;
        this.pos = pos;
    }

    @Override
    public boolean apply(Filter filter, Actor actor, Supplier<Network> networkProvider, class_1657 player) {
        class_2404 liquidBlock;
        class_2680 blockState;
        block6: {
            block5: {
                if (!this.level.method_8477(this.pos)) {
                    return false;
                }
                blockState = this.level.method_8320(this.pos);
                class_2248 class_22482 = blockState.method_26204();
                if (!(class_22482 instanceof class_2404)) break block5;
                liquidBlock = (class_2404)class_22482;
                if ((Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0) break block6;
            }
            return false;
        }
        class_3611 fluid = blockState.method_26227().method_15772();
        FluidResource fluidResource = new FluidResource(fluid);
        if (!filter.isAllowed(fluidResource)) {
            return false;
        }
        return this.tryInsert(actor, networkProvider, player, blockState, liquidBlock, fluidResource);
    }

    private boolean tryInsert(Actor actor, Supplier<Network> networkSupplier, class_1657 actingPlayer, class_2680 blockState, class_2404 liquidBlock, FluidResource fluidResource) {
        long amount = Platform.INSTANCE.getBucketAmount();
        long inserted = this.getRootStorage(networkSupplier).insert(fluidResource, amount, Action.SIMULATE, actor);
        if (inserted != amount) {
            return false;
        }
        this.level.method_8652(this.pos, class_2246.field_10124.method_9564(), 11);
        Platform.INSTANCE.getBucketPickupSound(liquidBlock, blockState).ifPresent(sound -> this.level.method_8396(null, this.pos, sound, class_3419.field_15245, 1.0f, 1.0f));
        this.level.method_33596((class_1297)actingPlayer, (class_6880)class_5712.field_28167, this.pos);
        this.getRootStorage(networkSupplier).insert(fluidResource, amount, Action.EXECUTE, actor);
        return true;
    }

    private RootStorage getRootStorage(Supplier<Network> networkSupplier) {
        return networkSupplier.get().getComponent(StorageNetworkComponent.class);
    }
}

