/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class PlaceFluidConstructorStrategy
implements ConstructorStrategy {
    protected final class_3218 level;
    protected final class_2338 pos;
    protected final class_2350 direction;

    public PlaceFluidConstructorStrategy(class_3218 level, class_2338 pos, class_2350 direction) {
        this.level = level;
        this.pos = pos;
        this.direction = direction;
    }

    @Override
    public ConstructorStrategy.Result apply(ResourceKey resource, Actor actor, class_1657 player, Network network) {
        if (!this.level.method_8477(this.pos)) {
            return ConstructorStrategy.Result.SKIPPED;
        }
        if (!(resource instanceof FluidResource)) {
            return ConstructorStrategy.Result.SKIPPED;
        }
        FluidResource fluidResource = (FluidResource)resource;
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        long bucketAmount = Platform.INSTANCE.getBucketAmount();
        long extractedAmount = rootStorage.extract(fluidResource, bucketAmount, Action.SIMULATE, actor);
        if (bucketAmount != extractedAmount) {
            return ConstructorStrategy.Result.RESOURCE_MISSING;
        }
        boolean success = Platform.INSTANCE.placeFluid((class_1937)this.level, this.pos, this.direction, player, fluidResource);
        if (success) {
            rootStorage.extract(fluidResource, bucketAmount, Action.EXECUTE, actor);
        }
        return success ? ConstructorStrategy.Result.SUCCESS : ConstructorStrategy.Result.SKIPPED;
    }
}

