/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.content;

import com.refinedmods.refinedstorage.common.content.BlockFactory;
import com.refinedmods.refinedstorage.common.content.ColorMap;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class BlockColorMap<T extends class_2248, I extends class_1747>
extends ColorMap<T> {
    private final BlockFactory<T> blockFactory;
    private final class_5250 baseName;

    public BlockColorMap(BlockFactory<T> blockFactory, class_2960 baseId, class_5250 baseName, class_1767 defaultColor) {
        super(baseId, defaultColor);
        this.blockFactory = Objects.requireNonNull(blockFactory);
        this.baseName = Objects.requireNonNull(baseName);
    }

    public Optional<class_1269> updateColor(class_2680 state, class_1799 heldItem, class_1937 level, class_2338 pos, class_1657 player) {
        class_1767 color;
        class_1792 class_17922 = heldItem.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dye = (class_1769)class_17922;
            v0 = dye.method_7802();
        } else {
            v0 = color = null;
        }
        if (color == null || state.method_26204().equals(this.get(color))) {
            return Optional.empty();
        }
        if (!level.method_8608()) {
            this.updateColorOnServer(state, heldItem, level, pos, (class_3222)player, color);
        }
        return Optional.of(class_1269.method_29236((boolean)level.method_8608()));
    }

    private void updateColorOnServer(class_2680 state, class_1799 heldItem, class_1937 level, class_2338 pos, class_3222 player, class_1767 color) {
        class_2248 newBlock = (class_2248)this.get(color);
        level.method_8501(pos, this.getNewState(newBlock, state));
        if (player.field_13974.method_14257() != class_1934.field_9220) {
            heldItem.method_7934(1);
        }
    }

    public class_2248[] toArray() {
        return this.values().toArray(new class_2248[0]);
    }

    private class_2680 getNewState(class_2248 newBlock, class_2680 oldState) {
        class_2680 newState = newBlock.method_9564();
        for (class_2769 property : oldState.method_28501()) {
            if (!newState.method_28498(property)) continue;
            newState = (class_2680)newState.method_11657(property, oldState.method_11654(property));
        }
        return newState;
    }

    private class_5250 getName(class_1767 color) {
        if (color != this.defaultColor) {
            class_5250 colorTranslation = class_2561.method_43471((String)("color.minecraft." + color.method_7792()));
            return IdentifierUtil.createTranslation("item", "color_and_item_name", colorTranslation, this.baseName);
        }
        return this.baseName;
    }

    public void registerBlocks(RegistryCallback<class_2248> callback) {
        this.putAll(color -> callback.register(this.getId((class_1767)color), () -> this.blockFactory.createBlock((class_1767)color, this.getName((class_1767)color))));
    }

    public void registerItems(RegistryCallback<class_1792> callback) {
        this.registerItems(callback, itemSupplier -> {});
    }

    public void registerItems(RegistryCallback<class_1792> callback, Consumer<Supplier<I>> acceptor) {
        this.forEach((color, id, block) -> {
            Supplier<class_1747> itemSupplier = () -> BlockColorMap.lambda$registerItems$3((Supplier)block);
            acceptor.accept(callback.register(id, itemSupplier));
        });
    }

    private static /* synthetic */ class_1747 lambda$registerItems$3(Supplier block) {
        return ((BlockItemProvider)((class_2248)block.get())).createBlockItem();
    }
}

