/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.content;

import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_2960;

public class ColorMap<T> {
    protected final class_1767 defaultColor;
    private final Map<class_1767, Supplier<T>> map = new EnumMap<class_1767, Supplier<T>>(class_1767.class);
    private final class_2960 baseId;

    public ColorMap(class_2960 baseId, class_1767 defaultColor) {
        this.baseId = Objects.requireNonNull(baseId);
        this.defaultColor = Objects.requireNonNull(defaultColor);
    }

    public boolean isDefaultColor(class_1767 color) {
        return this.defaultColor == color;
    }

    protected final void putAll(Function<class_1767, Supplier<T>> factory) {
        for (class_1767 color : class_1767.values()) {
            this.map.put(color, factory.apply(color));
        }
    }

    protected final class_2960 getId(class_1767 color) {
        if (color == this.defaultColor) {
            return this.baseId;
        }
        return class_2960.method_60655((String)this.baseId.method_12836(), (String)(color.method_7792() + "_" + this.baseId.method_12832()));
    }

    public void forEach(ColoredConsumer<T> consumer) {
        this.map.entrySet().stream().sorted(new ColoredSorter(this.defaultColor)).forEach((? super T entry) -> consumer.accept((class_1767)entry.getKey(), this.getId((class_1767)entry.getKey()), (Supplier)entry.getValue()));
    }

    public T get(class_1767 color) {
        return this.map.get(color).get();
    }

    public T getDefault() {
        return this.get(this.defaultColor);
    }

    public Collection<T> values() {
        return this.map.values().stream().map(Supplier::get).toList();
    }

    private record ColoredSorter<T>(class_1767 defaultColor) implements Comparator<Map.Entry<class_1767, T>>
    {
        @Override
        public int compare(Map.Entry<class_1767, T> entry1, Map.Entry<class_1767, T> entry2) {
            return this.getId(entry1) - this.getId(entry2);
        }

        private int getId(Map.Entry<class_1767, T> entry) {
            return (entry.getKey().method_7789() - this.defaultColor.method_7789() + 16) % 16;
        }
    }

    @FunctionalInterface
    public static interface ColoredConsumer<T> {
        public void accept(class_1767 var1, class_2960 var2, Supplier<T> var3);
    }
}

