/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.controller;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.controller.ControllerNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.energy.TransferableBlockEntityEnergy;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.controller.AbstractControllerBlock;
import com.refinedmods.refinedstorage.common.controller.ControllerContainerMenu;
import com.refinedmods.refinedstorage.common.controller.ControllerData;
import com.refinedmods.refinedstorage.common.controller.ControllerEnergyType;
import com.refinedmods.refinedstorage.common.controller.ControllerType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.energy.BlockEntityEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.CreativeEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<ControllerNetworkNode>
implements NetworkNodeExtendedMenuProvider<ControllerData>,
TransferableBlockEntityEnergy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerBlockEntity.class);
    private static final String TAG_CAPACITY = "capacity";
    private final ControllerType type;
    private final EnergyStorage energyStorage;
    private final RateLimiter energyStateChangeRateLimiter = RateLimiter.create((double)1.0);

    public ControllerBlockEntity(ControllerType type, class_2338 pos, class_2680 state) {
        super(ControllerBlockEntity.getBlockEntityType(type), pos, state, new ControllerNetworkNode());
        this.type = type;
        this.energyStorage = ControllerBlockEntity.createEnergyStorage(type, this);
        ((ControllerNetworkNode)this.mainNetworkNode).setEnergyStorage(this.energyStorage);
    }

    private static EnergyStorage createEnergyStorage(ControllerType type, class_2586 blockEntity) {
        if (type == ControllerType.CREATIVE) {
            return CreativeEnergyStorage.INSTANCE;
        }
        return new BlockEntityEnergyStorage(new EnergyStorageImpl(Platform.INSTANCE.getConfig().getController().getEnergyCapacity()), blockEntity);
    }

    private static class_2591<ControllerBlockEntity> getBlockEntityType(ControllerType type) {
        return type == ControllerType.CREATIVE ? BlockEntities.INSTANCE.getCreativeController() : BlockEntities.INSTANCE.getController();
    }

    public void updateEnergyTypeInLevel(class_2680 state) {
        ControllerEnergyType currentEnergyType = (ControllerEnergyType)((Object)state.method_11654(AbstractControllerBlock.ENERGY_TYPE));
        ControllerEnergyType newEnergyType = ControllerEnergyType.ofState(((ControllerNetworkNode)this.mainNetworkNode).getState());
        if (newEnergyType != currentEnergyType && this.field_11863 != null && this.energyStateChangeRateLimiter.tryAcquire()) {
            LOGGER.debug("Energy type state change for controller at {}: {} -> {}", new Object[]{this.method_11016(), currentEnergyType, newEnergyType});
            this.field_11863.method_8501(this.method_11016(), (class_2680)state.method_11657(AbstractControllerBlock.ENERGY_TYPE, (Comparable)((Object)newEnergyType)));
        }
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        ItemBlockEnergyStorage.writeToTag(tag, ((ControllerNetworkNode)this.mainNetworkNode).getActualStored());
        this.saveRenderingInfo(tag);
    }

    private void saveRenderingInfo(class_2487 tag) {
        tag.method_10544(TAG_CAPACITY, ((ControllerNetworkNode)this.mainNetworkNode).getActualCapacity());
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        ItemBlockEnergyStorage.readFromTag(this.energyStorage, tag);
    }

    public class_2561 method_5477() {
        class_5250 defaultName = this.type == ControllerType.CREATIVE ? ContentNames.CREATIVE_CONTROLLER : ContentNames.CONTROLLER;
        return this.overrideName((class_2561)defaultName);
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new ControllerContainerMenu(syncId, inv, this, player);
    }

    @Override
    public ControllerData getMenuData() {
        return new ControllerData(this.getActualStored(), this.getActualCapacity());
    }

    @Override
    public class_9142<class_9129, ControllerData> getMenuCodec() {
        return ControllerData.STREAM_CODEC;
    }

    long getActualStored() {
        return ((ControllerNetworkNode)this.mainNetworkNode).getActualStored();
    }

    long getActualCapacity() {
        return ((ControllerNetworkNode)this.mainNetworkNode).getActualCapacity();
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

