/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.detector;

import com.refinedmods.refinedstorage.api.network.impl.node.detector.AbstractDetectorAmountStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorAmountStrategyImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorMode;
import com.refinedmods.refinedstorage.api.network.impl.node.detector.DetectorNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.detector.DetectorBlock;
import com.refinedmods.refinedstorage.common.detector.DetectorConnectionStrategy;
import com.refinedmods.refinedstorage.common.detector.DetectorContainerMenu;
import com.refinedmods.refinedstorage.common.detector.DetectorModeSettings;
import com.refinedmods.refinedstorage.common.detector.FuzzyDetectorAmountStrategy;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.containermenu.SingleAmountData;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<DetectorNetworkNode>
implements NetworkNodeExtendedMenuProvider<SingleAmountData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectorBlockEntity.class);
    private static final int POWERED_CHANGE_TICK_RATE = 20;
    private static final String TAG_AMOUNT = "amount";
    private static final String TAG_MODE = "mode";
    private final FilterWithFuzzyMode filter;
    private int poweredChangeTicks;
    private double amount;

    public DetectorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getDetector(), pos, state, new DetectorNetworkNode(Platform.INSTANCE.getConfig().getDetector().getEnergyUsage()));
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(1);
        this.filter = FilterWithFuzzyMode.createAndListenForFilters(resourceContainer, () -> {
            this.propagateAmount();
            this.method_5431();
        }, filters -> ((DetectorNetworkNode)this.mainNetworkNode).setConfiguredResource(filters.isEmpty() ? null : (ResourceKey)filters.getFirst()));
        this.initialize();
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(DetectorNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).connectionStrategy(new DetectorConnectionStrategy(() -> ((DetectorBlockEntity)this).method_11010(), this.method_11016())).build();
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
        tag.method_10549(TAG_AMOUNT, this.amount);
        tag.method_10569(TAG_MODE, DetectorModeSettings.getDetectorMode(((DetectorNetworkNode)this.mainNetworkNode).getMode()));
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
        if (tag.method_10545(TAG_AMOUNT)) {
            this.amount = tag.method_10574(TAG_AMOUNT);
        }
        if (tag.method_10545(TAG_MODE)) {
            ((DetectorNetworkNode)this.mainNetworkNode).setMode(DetectorModeSettings.getDetectorMode(tag.method_10550(TAG_MODE)));
        }
        this.initialize();
        this.propagateAmount();
    }

    void setAmount(double amount) {
        this.amount = amount;
        this.propagateAmount();
        this.method_5431();
    }

    private void propagateAmount() {
        PlatformResourceKey configuredResource = this.filter.getFilterContainer().getResource(0);
        long normalizedAmount = configuredResource == null ? (long)this.amount : configuredResource.getResourceType().normalizeAmount(this.amount);
        LOGGER.debug("Updating detector amount of {} normalized as {}", (Object)this.amount, (Object)normalizedAmount);
        ((DetectorNetworkNode)this.mainNetworkNode).setAmount(normalizedAmount);
    }

    void setConfiguredResource(ResourceKey configuredResource) {
        ((DetectorNetworkNode)this.mainNetworkNode).setConfiguredResource(configuredResource);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.initialize();
    }

    void setMode(DetectorMode mode) {
        ((DetectorNetworkNode)this.mainNetworkNode).setMode(mode);
        this.method_5431();
    }

    DetectorMode getMode() {
        return ((DetectorNetworkNode)this.mainNetworkNode).getMode();
    }

    private void initialize() {
        DetectorAmountStrategyImpl defaultStrategy = new DetectorAmountStrategyImpl();
        AbstractDetectorAmountStrategy strategy = this.isFuzzyMode() ? new FuzzyDetectorAmountStrategy(defaultStrategy) : defaultStrategy;
        ((DetectorNetworkNode)this.mainNetworkNode).setAmountStrategy(strategy);
    }

    @Override
    public SingleAmountData getMenuData() {
        return new SingleAmountData(Optional.empty(), this.amount, ResourceContainerData.of(this.filter.getFilterContainer()));
    }

    @Override
    public class_9142<class_9129, SingleAmountData> getMenuCodec() {
        return SingleAmountData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.DETECTOR);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new DetectorContainerMenu(syncId, player, this, this.filter.getFilterContainer());
    }

    @Override
    public void updateActiveness(class_2680 state, @Nullable class_2746 activenessProperty) {
        boolean needToUpdatePowered;
        super.updateActiveness(state, activenessProperty);
        boolean powered = ((DetectorNetworkNode)this.mainNetworkNode).isActive() && ((DetectorNetworkNode)this.mainNetworkNode).isActivated();
        boolean bl = needToUpdatePowered = (Boolean)state.method_11654((class_2769)DetectorBlock.POWERED) != powered;
        if (this.field_11863 != null && needToUpdatePowered && this.poweredChangeTicks++ % 20 == 0) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
            this.poweredChangeTicks = 0;
        }
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

